# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, conlist
from linebot.v3.messaging.models.quick_reply_item import QuickReplyItem

class QuickReply(BaseModel):
    """
    Quick reply
    https://developers.line.biz/en/reference/messaging-api/#items-object
    """
    items: Optional[conlist(QuickReplyItem, max_items=13)] = Field(None, description="Quick reply button objects.")

    __properties = ["items"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> QuickReply:
        """Create an instance of QuickReply from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in items (list)
        _items = []
        if self.items:
            for _item in self.items:
                if _item:
                    _items.append(_item.to_dict())
            _dict['items'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> QuickReply:
        """Create an instance of QuickReply from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return QuickReply.parse_obj(obj)

        _obj = QuickReply.parse_obj({
            "items": [QuickReplyItem.from_dict(_item) for _item in obj.get("items")] if obj.get("items") is not None else None
        })
        return _obj

