# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic.v1 import BaseModel, Field, StrictStr, conlist

class RichMenuBulkUnlinkRequest(BaseModel):
    """
    RichMenuBulkUnlinkRequest
    https://developers.line.biz/en/reference/messaging-api/#unlink-rich-menu-from-users
    """
    user_ids: conlist(StrictStr, max_items=500, min_items=1) = Field(..., alias="userIds", description="Array of user IDs. Found in the `source` object of webhook event objects. Do not use the LINE ID used in LINE.")

    __properties = ["userIds"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RichMenuBulkUnlinkRequest:
        """Create an instance of RichMenuBulkUnlinkRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RichMenuBulkUnlinkRequest:
        """Create an instance of RichMenuBulkUnlinkRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RichMenuBulkUnlinkRequest.parse_obj(obj)

        _obj = RichMenuBulkUnlinkRequest.parse_obj({
            "user_ids": obj.get("userIds")
        })
        return _obj

