# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr, conlist, constr
from linebot.v3.messaging.models.rich_menu_area import RichMenuArea
from linebot.v3.messaging.models.rich_menu_size import RichMenuSize

class RichMenuResponse(BaseModel):
    """
    RichMenuResponse
    """
    rich_menu_id: StrictStr = Field(..., alias="richMenuId", description="ID of a rich menu")
    size: RichMenuSize = Field(...)
    selected: StrictBool = Field(..., description="`true` to display the rich menu by default. Otherwise, `false`.")
    name: constr(strict=True, max_length=300) = Field(..., description="Name of the rich menu. This value can be used to help manage your rich menus and is not displayed to users.")
    chat_bar_text: constr(strict=True, max_length=14) = Field(..., alias="chatBarText", description="Text displayed in the chat bar")
    areas: conlist(RichMenuArea, max_items=20) = Field(..., description="Array of area objects which define the coordinates and size of tappable areas")

    __properties = ["richMenuId", "size", "selected", "name", "chatBarText", "areas"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RichMenuResponse:
        """Create an instance of RichMenuResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic.v1 by calling `to_dict()` of size
        if self.size:
            _dict['size'] = self.size.to_dict()
        # override the default output from pydantic.v1 by calling `to_dict()` of each item in areas (list)
        _items = []
        if self.areas:
            for _item in self.areas:
                if _item:
                    _items.append(_item.to_dict())
            _dict['areas'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RichMenuResponse:
        """Create an instance of RichMenuResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RichMenuResponse.parse_obj(obj)

        _obj = RichMenuResponse.parse_obj({
            "rich_menu_id": obj.get("richMenuId"),
            "size": RichMenuSize.from_dict(obj.get("size")) if obj.get("size") is not None else None,
            "selected": obj.get("selected"),
            "name": obj.get("name"),
            "chat_bar_text": obj.get("chatBarText"),
            "areas": [RichMenuArea.from_dict(_item) for _item in obj.get("areas")] if obj.get("areas") is not None else None
        })
        return _obj

