# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr

class ModuleBot(BaseModel):
    """
    basic information about the bot.
    https://developers.line.biz/en/reference/partner-docs/#get-multiple-bot-info-api
    """
    user_id: StrictStr = Field(..., alias="userId", description="Bot's user ID")
    basic_id: StrictStr = Field(..., alias="basicId", description="Bot's basic ID")
    premium_id: Optional[StrictStr] = Field(None, alias="premiumId", description="Bot's premium ID. Not included in the response if the premium ID isn't set.")
    display_name: StrictStr = Field(..., alias="displayName", description="Bot's display name")
    picture_url: Optional[StrictStr] = Field(None, alias="pictureUrl", description="Profile image URL. Image URL starting with `https://`. Not included in the response if the bot doesn't have a profile image.")

    __properties = ["userId", "basicId", "premiumId", "displayName", "pictureUrl"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ModuleBot:
        """Create an instance of ModuleBot from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ModuleBot:
        """Create an instance of ModuleBot from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ModuleBot.parse_obj(obj)

        _obj = ModuleBot.parse_obj({
            "user_id": obj.get("userId"),
            "basic_id": obj.get("basicId"),
            "premium_id": obj.get("premiumId"),
            "display_name": obj.get("displayName"),
            "picture_url": obj.get("pictureUrl")
        })
        return _obj

