# coding: utf-8

"""
    LINE Messaging API

    This document describes LINE Messaging API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io

from pydantic.v1 import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic.v1 import Field, StrictStr

from typing import Optional

from linebot.v3.moduleattach.models.attach_module_response import AttachModuleResponse

from linebot.v3.moduleattach.api_client import ApiClient
from linebot.v3.moduleattach.api_response import ApiResponse
from linebot.v3.moduleattach.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class LineModuleAttach(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client
        self.line_base_path = "https://manager.line.biz"


    @validate_arguments
    def attach_module(self, grant_type : Annotated[Optional[StrictStr], Field(description="authorization_code")] = None, code : Annotated[Optional[StrictStr], Field(description="Authorization code received from the LINE Platform.")] = None, redirect_uri : Annotated[Optional[StrictStr], Field(description="Specify the redirect_uri specified in the URL for authentication and authorization.")] = None, code_verifier : Annotated[Optional[StrictStr], Field(description="Specify when using PKCE (Proof Key for Code Exchange) defined in the OAuth 2.0 extension specification as a countermeasure against authorization code interception attacks.")] = None, client_id : Annotated[Optional[StrictStr], Field(description="Instead of using Authorization header, you can use this parameter to specify the channel ID of the module channel. You can find the channel ID of the module channel in the LINE Developers Console. ")] = None, client_secret : Annotated[Optional[StrictStr], Field(description="Instead of using Authorization header, you can use this parameter to specify the channel secret of the module channel. You can find the channel secret of the module channel in the LINE Developers Console. ")] = None, region : Annotated[Optional[StrictStr], Field(description="If you specified a value for region in the URL for authentication and authorization, specify the same value. ")] = None, basic_search_id : Annotated[Optional[StrictStr], Field(description="If you specified a value for basic_search_id in the URL for authentication and authorization, specify the same value.")] = None, scope : Annotated[Optional[StrictStr], Field(description="If you specified a value for scope in the URL for authentication and authorization, specify the same value.")] = None, brand_type : Annotated[Optional[StrictStr], Field(description="If you specified a value for brand_type in the URL for authentication and authorization, specify the same value.")] = None, **kwargs) -> AttachModuleResponse:  # noqa: E501
        """attach_module  # noqa: E501

        Attach by operation of the module channel provider  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.attach_module(grant_type, code, redirect_uri, code_verifier, client_id, client_secret, region, basic_search_id, scope, brand_type, async_req=True)
        >>> result = thread.get()

        :param grant_type: authorization_code
        :type grant_type: str
        :param code: Authorization code received from the LINE Platform.
        :type code: str
        :param redirect_uri: Specify the redirect_uri specified in the URL for authentication and authorization.
        :type redirect_uri: str
        :param code_verifier: Specify when using PKCE (Proof Key for Code Exchange) defined in the OAuth 2.0 extension specification as a countermeasure against authorization code interception attacks.
        :type code_verifier: str
        :param client_id: Instead of using Authorization header, you can use this parameter to specify the channel ID of the module channel. You can find the channel ID of the module channel in the LINE Developers Console. 
        :type client_id: str
        :param client_secret: Instead of using Authorization header, you can use this parameter to specify the channel secret of the module channel. You can find the channel secret of the module channel in the LINE Developers Console. 
        :type client_secret: str
        :param region: If you specified a value for region in the URL for authentication and authorization, specify the same value. 
        :type region: str
        :param basic_search_id: If you specified a value for basic_search_id in the URL for authentication and authorization, specify the same value.
        :type basic_search_id: str
        :param scope: If you specified a value for scope in the URL for authentication and authorization, specify the same value.
        :type scope: str
        :param brand_type: If you specified a value for brand_type in the URL for authentication and authorization, specify the same value.
        :type brand_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AttachModuleResponse
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the attach_module_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.attach_module_with_http_info(grant_type, code, redirect_uri, code_verifier, client_id, client_secret, region, basic_search_id, scope, brand_type, **kwargs)  # noqa: E501

    @validate_arguments
    def attach_module_with_http_info(self, grant_type : Annotated[Optional[StrictStr], Field(description="authorization_code")] = None, code : Annotated[Optional[StrictStr], Field(description="Authorization code received from the LINE Platform.")] = None, redirect_uri : Annotated[Optional[StrictStr], Field(description="Specify the redirect_uri specified in the URL for authentication and authorization.")] = None, code_verifier : Annotated[Optional[StrictStr], Field(description="Specify when using PKCE (Proof Key for Code Exchange) defined in the OAuth 2.0 extension specification as a countermeasure against authorization code interception attacks.")] = None, client_id : Annotated[Optional[StrictStr], Field(description="Instead of using Authorization header, you can use this parameter to specify the channel ID of the module channel. You can find the channel ID of the module channel in the LINE Developers Console. ")] = None, client_secret : Annotated[Optional[StrictStr], Field(description="Instead of using Authorization header, you can use this parameter to specify the channel secret of the module channel. You can find the channel secret of the module channel in the LINE Developers Console. ")] = None, region : Annotated[Optional[StrictStr], Field(description="If you specified a value for region in the URL for authentication and authorization, specify the same value. ")] = None, basic_search_id : Annotated[Optional[StrictStr], Field(description="If you specified a value for basic_search_id in the URL for authentication and authorization, specify the same value.")] = None, scope : Annotated[Optional[StrictStr], Field(description="If you specified a value for scope in the URL for authentication and authorization, specify the same value.")] = None, brand_type : Annotated[Optional[StrictStr], Field(description="If you specified a value for brand_type in the URL for authentication and authorization, specify the same value.")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """attach_module  # noqa: E501

        Attach by operation of the module channel provider  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.attach_module_with_http_info(grant_type, code, redirect_uri, code_verifier, client_id, client_secret, region, basic_search_id, scope, brand_type, async_req=True)
        >>> result = thread.get()

        :param grant_type: authorization_code
        :type grant_type: str
        :param code: Authorization code received from the LINE Platform.
        :type code: str
        :param redirect_uri: Specify the redirect_uri specified in the URL for authentication and authorization.
        :type redirect_uri: str
        :param code_verifier: Specify when using PKCE (Proof Key for Code Exchange) defined in the OAuth 2.0 extension specification as a countermeasure against authorization code interception attacks.
        :type code_verifier: str
        :param client_id: Instead of using Authorization header, you can use this parameter to specify the channel ID of the module channel. You can find the channel ID of the module channel in the LINE Developers Console. 
        :type client_id: str
        :param client_secret: Instead of using Authorization header, you can use this parameter to specify the channel secret of the module channel. You can find the channel secret of the module channel in the LINE Developers Console. 
        :type client_secret: str
        :param region: If you specified a value for region in the URL for authentication and authorization, specify the same value. 
        :type region: str
        :param basic_search_id: If you specified a value for basic_search_id in the URL for authentication and authorization, specify the same value.
        :type basic_search_id: str
        :param scope: If you specified a value for scope in the URL for authentication and authorization, specify the same value.
        :type scope: str
        :param brand_type: If you specified a value for brand_type in the URL for authentication and authorization, specify the same value.
        :type brand_type: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AttachModuleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _host = self.line_base_path
        _params = locals()

        _all_params = [
            'grant_type',
            'code',
            'redirect_uri',
            'code_verifier',
            'client_id',
            'client_secret',
            'region',
            'basic_search_id',
            'scope',
            'brand_type'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method attach_module" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        if _params['grant_type']:
            _form_params.append(('grant_type', _params['grant_type']))

        if _params['code']:
            _form_params.append(('code', _params['code']))

        if _params['redirect_uri']:
            _form_params.append(('redirect_uri', _params['redirect_uri']))

        if _params['code_verifier']:
            _form_params.append(('code_verifier', _params['code_verifier']))

        if _params['client_id']:
            _form_params.append(('client_id', _params['client_id']))

        if _params['client_secret']:
            _form_params.append(('client_secret', _params['client_secret']))

        if _params['region']:
            _form_params.append(('region', _params['region']))

        if _params['basic_search_id']:
            _form_params.append(('basic_search_id', _params['basic_search_id']))

        if _params['scope']:
            _form_params.append(('scope', _params['scope']))

        if _params['brand_type']:
            _form_params.append(('brand_type', _params['brand_type']))

        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/x-www-form-urlencoded']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['basicAuth']  # noqa: E501

        _response_types_map = {
            '200': "AttachModuleResponse",
        }

        return self.api_client.call_api(
            '/module/auth/v1/token', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            _host=_host,
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
