# coding: utf-8

"""
    Channel Access Token API

    This document describes Channel Access Token API.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr

class VerifyChannelAccessTokenResponse(BaseModel):
    """
    Verification result
    """
    client_id: StrictStr = Field(..., description="The channel ID for which the channel access token was issued.")
    expires_in: StrictInt = Field(..., description="Number of seconds before the channel access token expires.")
    scope: Optional[StrictStr] = Field(None, description="Permissions granted to the channel access token.")

    __properties = ["client_id", "expires_in", "scope"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VerifyChannelAccessTokenResponse:
        """Create an instance of VerifyChannelAccessTokenResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VerifyChannelAccessTokenResponse:
        """Create an instance of VerifyChannelAccessTokenResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VerifyChannelAccessTokenResponse.parse_obj(obj)

        _obj = VerifyChannelAccessTokenResponse.parse_obj({
            "client_id": obj.get("client_id"),
            "expires_in": obj.get("expires_in"),
            "scope": obj.get("scope")
        })
        return _obj

