# coding: utf-8

"""
    Webhook Type Definition

    Webhook event definition of the LINE Messaging API  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr

class Emoji(BaseModel):
    """
    Emoji
    """
    index: StrictInt = Field(..., description="Index position for a character in text, with the first character being at position 0.")
    length: StrictInt = Field(..., description="The length of the LINE emoji string. For LINE emoji (hello), 7 is the length.")
    product_id: StrictStr = Field(..., alias="productId", description="Product ID for a LINE emoji set.")
    emoji_id: StrictStr = Field(..., alias="emojiId", description="ID for a LINE emoji inside a set.")

    __properties = ["index", "length", "productId", "emojiId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Emoji:
        """Create an instance of Emoji from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Emoji:
        """Create an instance of Emoji from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Emoji.parse_obj(obj)

        _obj = Emoji.parse_obj({
            "index": obj.get("index"),
            "length": obj.get("length"),
            "product_id": obj.get("productId"),
            "emoji_id": obj.get("emojiId")
        })
        return _obj

