# coding: utf-8

"""
    Webhook Type Definition

    Webhook event definition of the LINE Messaging API  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictInt, StrictStr

class ImageSet(BaseModel):
    """
    ImageSet
    """
    id: StrictStr = Field(..., description="Image set ID. Only included when multiple images are sent simultaneously.")
    index: Optional[StrictInt] = Field(None, description="An index starting from 1, indicating the image number in a set of images sent simultaneously. Only included when multiple images are sent simultaneously. However, it won't be included if the sender is using LINE 11.15 or earlier for Android.")
    total: Optional[StrictInt] = Field(None, description="The total number of images sent simultaneously.")

    __properties = ["id", "index", "total"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImageSet:
        """Create an instance of ImageSet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ImageSet:
        """Create an instance of ImageSet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ImageSet.parse_obj(obj)

        _obj = ImageSet.parse_obj({
            "id": obj.get("id"),
            "index": obj.get("index"),
            "total": obj.get("total")
        })
        return _obj

