# coding: utf-8

"""
    Webhook Type Definition

    Webhook event definition of the LINE Messaging API  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic.v1 import BaseModel, Field, StrictStr

class PnpDelivery(BaseModel):
    """
    A delivery object containing a hashed phone number string or a string specified by `X-Line-Delivery-Tag` header
    """
    data: StrictStr = Field(..., description="A hashed phone number string or a string specified by `X-Line-Delivery-Tag` header")

    __properties = ["data"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PnpDelivery:
        """Create an instance of PnpDelivery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PnpDelivery:
        """Create an instance of PnpDelivery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PnpDelivery.parse_obj(obj)

        _obj = PnpDelivery.parse_obj({
            "data": obj.get("data")
        })
        return _obj

