# How To contribute to MainWP

Community made patches, localizations, bug reports and contributions are always welcome. Your help making it even more awesome will be greatly appreciated :)

When contributing please ensure you follow the guidelines below to help us keep on top of things.

__Please Note:__

GitHub is for _bug reports and contributions only_ - if you have a support question or a request for a customization this is not the right place to post it. Use [MainWP Support](https://mainwp.com/support/) for customer support and for customizations we recommend one of the following services:

- [Codeable](https://codeable.io/)
- [UpWork] (htpps://upwork.com)


## Contributing To The Core

### Reporting Issues

Reporting issues is a great way to become a contributor as it doesn't require technical skills. In fact you don't even need to know a programming language or to be able to check the code itself, you just need to make sure that everything works as expected and [submit an issue report](https://github.com/mainwp/mainwp/issues/new) if you spot a bug. Sound like something you're up for? Go for it!

#### How To Submit An Issue Report

If something isn't working, congratulations you've found a bug! Help us fix it by submitting an issue report:

* Make sure you have a [GitHub account](https://github.com/signup/free)
* Search the [Existing Issues](https://github.com/mainwp/mainwp/issues) to be sure that the one you've noticed isn't already there
* Submit a report for your issue
  * Clearly describe the issue (including steps to reproduce it if it's a bug)
  * Make sure you fill in the earliest version that you know has the issue.

### Making Changes

Helping aking changes to the MainWP Dashboard is a key way to help us improve MainWP overall. You will need some technical skills to make a change, like knowing a bit of PHP, CSS, SASS or JavaScript.

If you think something could be improved and you're able to do so, make your changes and submit a Pull Request. We'll be pleased to get it :)

#### How To Submit A PR

* Fork the repository on GitHub
* Make the changes to your forked repository
  * **Ensure you stick to the [WordPress Coding Standards](http://make.wordpress.org/core/handbook/coding-standards/php/).**
  * Ensure you use LF line endings - no crazy Windows line endings please :)
* When committing, reference your issue number (#1234) and include a note about the fix
* Push the changes to your fork and submit a pull request on the master branch of the MainWP Dashboard repository. Existing maintenance branches will be maintained by MainWP developers
* Please **don't** modify the changelog - this will be maintained by the MainWP developers.
* Please **don't** add your localizations or update the .pot files - these will also be maintained by the MainWP developers. To contribute to the localization of MainWP, please join the [translate.wordpress.org project](https://translate.wordpress.org/projects/wp-plugins/mainwp). This is much needed, if you speak a language that needs translating consider yourself officially invited.

After you follow the step above, the next stage will be waiting on us to merge your Pull Request. We review them all, and make suggestions and changes as and if necessary.

## Contribute To Localizing MainWP

Localization is a very important part of MainWP. We believe in net neutrality and want our platform to be available to everyone, everywhere with equal ease. When you localize MainWP, you are helping hundreds of people in the world, and all the people who speak your language. That's pretty neat.

### Glossary & Style Guide

Please refer to this page on the [Translator Handbook](https://make.wordpress.org/polyglots/handbook/translating/glossary-style-guide/) for information about the glossary and the style guide.

Each translation editor will take care of updating the glossary on GlotPress by editing/adding items when needed.

_**Note**: Only editors can create/import and edit glossaries and glossary items on GlotPress. Anyone can suggest new items to add to the glossary or translate them._

### Translating The Core

We have a [project on translate.wordpress.org](https://translate.wordpress.org/projects/wp-plugins/mainwp). You can join the localization team of your language and help by translating MainWP. [Find more about using joining a language team and using GlotPress](https://make.wordpress.org/polyglots/handbook/tools/glotpress-translate-wordpress-org/).

If MainWP is already 100% translated for your language, join the team anyway! We regularly update our language files and there will definitely be need of your help soon.


# Additional Resources

* [General GitHub documentation](http://help.github.com/)
* [GitHub pull request documentation](http://help.github.com/send-pull-requests/)
* [Translator Handbook](https://make.wordpress.org/polyglots/handbook/)
* [MainWP Docs](http://docs.mainwp.com/)
* [MainWP API / Codex](http://codex.mainwp.com/)

# CONTRIBUTING File Credit

This CONTRIBUTING.md file relies heavily WooCommerce's [CONTRIBUTING.md](https://github.com/woothemes/woocommerce/blob/master/CONTRIBUTING.md) for wording and contribution requirements.   
