/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.ConverterRegistry;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.SingleValueConverterWrapper;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.BigDecimalConverter;
import com.thoughtworks.xstream.converters.basic.BigIntegerConverter;
import com.thoughtworks.xstream.converters.basic.BooleanConverter;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.converters.basic.CharConverter;
import com.thoughtworks.xstream.converters.basic.DateConverter;
import com.thoughtworks.xstream.converters.basic.DoubleConverter;
import com.thoughtworks.xstream.converters.basic.FloatConverter;
import com.thoughtworks.xstream.converters.basic.IntConverter;
import com.thoughtworks.xstream.converters.basic.LongConverter;
import com.thoughtworks.xstream.converters.basic.NullConverter;
import com.thoughtworks.xstream.converters.basic.ShortConverter;
import com.thoughtworks.xstream.converters.basic.StringBufferConverter;
import com.thoughtworks.xstream.converters.basic.StringConverter;
import com.thoughtworks.xstream.converters.basic.URIConverter;
import com.thoughtworks.xstream.converters.basic.URLConverter;
import com.thoughtworks.xstream.converters.collections.ArrayConverter;
import com.thoughtworks.xstream.converters.collections.BitSetConverter;
import com.thoughtworks.xstream.converters.collections.CharArrayConverter;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.converters.collections.PropertiesConverter;
import com.thoughtworks.xstream.converters.collections.SingletonCollectionConverter;
import com.thoughtworks.xstream.converters.collections.SingletonMapConverter;
import com.thoughtworks.xstream.converters.collections.TreeMapConverter;
import com.thoughtworks.xstream.converters.collections.TreeSetConverter;
import com.thoughtworks.xstream.converters.extended.ColorConverter;
import com.thoughtworks.xstream.converters.extended.DynamicProxyConverter;
import com.thoughtworks.xstream.converters.extended.EncodedByteArrayConverter;
import com.thoughtworks.xstream.converters.extended.FileConverter;
import com.thoughtworks.xstream.converters.extended.FontConverter;
import com.thoughtworks.xstream.converters.extended.GregorianCalendarConverter;
import com.thoughtworks.xstream.converters.extended.JavaClassConverter;
import com.thoughtworks.xstream.converters.extended.JavaFieldConverter;
import com.thoughtworks.xstream.converters.extended.JavaMethodConverter;
import com.thoughtworks.xstream.converters.extended.LocaleConverter;
import com.thoughtworks.xstream.converters.extended.LookAndFeelConverter;
import com.thoughtworks.xstream.converters.extended.SqlDateConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimeConverter;
import com.thoughtworks.xstream.converters.extended.SqlTimestampConverter;
import com.thoughtworks.xstream.converters.extended.TextAttributeConverter;
import com.thoughtworks.xstream.converters.reflection.ExternalizableConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import com.thoughtworks.xstream.core.ClassLoaderReference;
import com.thoughtworks.xstream.core.DefaultConverterLookup;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.core.ReferenceByIdMarshallingStrategy;
import com.thoughtworks.xstream.core.ReferenceByXPathMarshallingStrategy;
import com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import com.thoughtworks.xstream.core.util.CompositeClassLoader;
import com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import com.thoughtworks.xstream.core.util.CustomObjectOutputStream;
import com.thoughtworks.xstream.core.util.SelfStreamingInstanceChecker;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StatefulWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.AnnotationConfiguration;
import com.thoughtworks.xstream.mapper.ArrayMapper;
import com.thoughtworks.xstream.mapper.AttributeAliasingMapper;
import com.thoughtworks.xstream.mapper.AttributeMapper;
import com.thoughtworks.xstream.mapper.CachingMapper;
import com.thoughtworks.xstream.mapper.ClassAliasingMapper;
import com.thoughtworks.xstream.mapper.DefaultImplementationsMapper;
import com.thoughtworks.xstream.mapper.DefaultMapper;
import com.thoughtworks.xstream.mapper.DynamicProxyMapper;
import com.thoughtworks.xstream.mapper.ElementIgnoringMapper;
import com.thoughtworks.xstream.mapper.FieldAliasingMapper;
import com.thoughtworks.xstream.mapper.ImmutableTypesMapper;
import com.thoughtworks.xstream.mapper.ImplicitCollectionMapper;
import com.thoughtworks.xstream.mapper.LocalConversionMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import com.thoughtworks.xstream.mapper.OuterClassMapper;
import com.thoughtworks.xstream.mapper.PackageAliasingMapper;
import com.thoughtworks.xstream.mapper.SecurityMapper;
import com.thoughtworks.xstream.mapper.SystemAttributeAliasingMapper;
import com.thoughtworks.xstream.mapper.XStream11XmlFriendlyMapper;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.thoughtworks.xstream.security.ArrayTypePermission;
import com.thoughtworks.xstream.security.ExplicitTypePermission;
import com.thoughtworks.xstream.security.InterfaceTypePermission;
import com.thoughtworks.xstream.security.NoPermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import com.thoughtworks.xstream.security.RegExpTypePermission;
import com.thoughtworks.xstream.security.TypeHierarchyPermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class XStream {
    private ReflectionProvider reflectionProvider;
    private HierarchicalStreamDriver hierarchicalStreamDriver;
    private ClassLoaderReference classLoaderReference;
    private MarshallingStrategy marshallingStrategy;
    private ConverterLookup converterLookup;
    private ConverterRegistry converterRegistry;
    private Mapper mapper;
    private PackageAliasingMapper packageAliasingMapper;
    private ClassAliasingMapper classAliasingMapper;
    private FieldAliasingMapper fieldAliasingMapper;
    private ElementIgnoringMapper elementIgnoringMapper;
    private AttributeAliasingMapper attributeAliasingMapper;
    private SystemAttributeAliasingMapper systemAttributeAliasingMapper;
    private AttributeMapper attributeMapper;
    private DefaultImplementationsMapper defaultImplementationsMapper;
    private ImmutableTypesMapper immutableTypesMapper;
    private ImplicitCollectionMapper implicitCollectionMapper;
    private LocalConversionMapper localConversionMapper;
    private SecurityMapper securityMapper;
    private AnnotationConfiguration annotationConfiguration;
    private transient boolean securityInitialized;
    private transient boolean securityWarningGiven;
    private boolean is141Compatible = true;
    public static final int NO_REFERENCES = 1001;
    public static final int ID_REFERENCES = 1002;
    public static final int XPATH_RELATIVE_REFERENCES = 1003;
    public static final int XPATH_ABSOLUTE_REFERENCES = 1004;
    public static final int SINGLE_NODE_XPATH_RELATIVE_REFERENCES = 1005;
    public static final int SINGLE_NODE_XPATH_ABSOLUTE_REFERENCES = 1006;
    public static final int PRIORITY_VERY_HIGH = 10000;
    public static final int PRIORITY_NORMAL = 0;
    public static final int PRIORITY_LOW = -10;
    public static final int PRIORITY_VERY_LOW = -20;
    private static final String ANNOTATION_MAPPER_TYPE = "com.thoughtworks.xstream.mapper.AnnotationMapper";
    private static final Pattern IGNORE_ALL = Pattern.compile(".*");
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$Mapper;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$ConverterRegistry;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$ConverterLookup;
    static /* synthetic */ Class class$com$thoughtworks$xstream$core$ClassLoaderReference;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$reflection$ReflectionProvider;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$PackageAliasingMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$ClassAliasingMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$ElementIgnoringMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$FieldAliasingMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$AttributeMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$AttributeAliasingMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$SystemAttributeAliasingMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$ImplicitCollectionMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$DefaultImplementationsMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$ImmutableTypesMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$LocalConversionMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$SecurityMapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$AnnotationConfiguration;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Map$Entry;
    static /* synthetic */ Class class$java$lang$reflect$Member;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$util$TimeZone;
    static /* synthetic */ Class class$java$util$BitSet;
    static /* synthetic */ Class class$java$nio$charset$Charset;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$util$Currency;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$text$DecimalFormatSymbols;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$regex$Pattern;
    static /* synthetic */ Class class$java$lang$StackTraceElement;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$Mapper$Null;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$reflect$Method;
    static /* synthetic */ Class class$java$lang$reflect$Constructor;
    static /* synthetic */ Class class$java$lang$reflect$Field;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$GregorianCalendar;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Void;

    public XStream() {
        this(null, (Mapper)null, new XppDriver());
    }

    public XStream(boolean is141Compatible) {
        this(null, (Mapper)null, new XppDriver(), is141Compatible);
    }

    public XStream(ReflectionProvider reflectionProvider) {
        this(reflectionProvider, (Mapper)null, new XppDriver(), true);
    }

    public XStream(HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(null, (Mapper)null, hierarchicalStreamDriver);
    }

    public XStream(HierarchicalStreamDriver hierarchicalStreamDriver, boolean is141Compatible) {
        this(null, (Mapper)null, hierarchicalStreamDriver, is141Compatible);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver hierarchicalStreamDriver) {
        this(reflectionProvider, (Mapper)null, hierarchicalStreamDriver);
    }

    public XStream(ReflectionProvider reflectionProvider, Mapper mapper, HierarchicalStreamDriver driver) {
        this(reflectionProvider, driver, new CompositeClassLoader(), mapper);
    }

    public XStream(ReflectionProvider reflectionProvider, Mapper mapper, HierarchicalStreamDriver driver, boolean is141Compatible) {
        this(reflectionProvider, driver, new CompositeClassLoader(), mapper, is141Compatible);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference) {
        this(reflectionProvider, driver, classLoaderReference, null);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader) {
        this(reflectionProvider, driver, classLoader, null);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, Mapper mapper) {
        this(reflectionProvider, driver, new ClassLoaderReference(classLoader), mapper, new DefaultConverterLookup());
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, Mapper mapper, boolean is141Compatible) {
        this(reflectionProvider, driver, new ClassLoaderReference(classLoader), mapper, new DefaultConverterLookup(), is141Compatible);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper) {
        this(reflectionProvider, driver, classLoaderReference, mapper, new DefaultConverterLookup());
    }

    private XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoader, Mapper mapper, final DefaultConverterLookup defaultConverterLookup) {
        this(reflectionProvider, driver, classLoader, mapper, new ConverterLookup(){

            public Converter lookupConverterForType(Class type) {
                return defaultConverterLookup.lookupConverterForType(type);
            }
        }, new ConverterRegistry(){

            public void registerConverter(Converter converter, int priority) {
                defaultConverterLookup.registerConverter(converter, priority);
            }
        });
    }

    private XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoader, Mapper mapper, final DefaultConverterLookup defaultConverterLookup, boolean is141Compatible) {
        this(reflectionProvider, driver, classLoader, mapper, new ConverterLookup(){

            public Converter lookupConverterForType(Class type) {
                return defaultConverterLookup.lookupConverterForType(type);
            }
        }, new ConverterRegistry(){

            public void registerConverter(Converter converter, int priority) {
                defaultConverterLookup.registerConverter(converter, priority);
            }
        }, is141Compatible);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoader classLoader, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry) {
        this(reflectionProvider, driver, new ClassLoaderReference(classLoader), mapper, converterLookup, converterRegistry);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry) {
        this(reflectionProvider, driver, classLoaderReference, mapper, converterLookup, converterRegistry, true);
    }

    public XStream(ReflectionProvider reflectionProvider, HierarchicalStreamDriver driver, ClassLoaderReference classLoaderReference, Mapper mapper, ConverterLookup converterLookup, ConverterRegistry converterRegistry, boolean is141Compatible) {
        if (reflectionProvider == null) {
            reflectionProvider = JVM.newReflectionProvider();
        }
        this.reflectionProvider = reflectionProvider;
        this.hierarchicalStreamDriver = driver;
        this.classLoaderReference = classLoaderReference;
        this.converterLookup = converterLookup;
        this.converterRegistry = converterRegistry;
        this.mapper = mapper == null ? this.buildMapper() : mapper;
        this.is141Compatible = is141Compatible;
        this.setupMappers();
        this.setupSecurity();
        this.setupAliases();
        this.setupDefaultImplementations();
        this.setupConverters();
        this.setupImmutableTypes();
        this.setMode(1003);
    }

    private Mapper buildMapper() {
        Mapper mapper = new DefaultMapper(this.classLoaderReference);
        if (this.useXStream11XmlFriendlyMapper()) {
            mapper = new XStream11XmlFriendlyMapper(mapper);
        }
        mapper = new DynamicProxyMapper(mapper);
        mapper = new PackageAliasingMapper(mapper);
        mapper = new ClassAliasingMapper(mapper);
        mapper = new ElementIgnoringMapper(mapper);
        mapper = new FieldAliasingMapper(mapper);
        mapper = new AttributeAliasingMapper(mapper);
        mapper = new SystemAttributeAliasingMapper(mapper);
        mapper = new ImplicitCollectionMapper(mapper, this.reflectionProvider);
        mapper = new OuterClassMapper(mapper);
        mapper = new ArrayMapper(mapper);
        mapper = new DefaultImplementationsMapper(mapper);
        mapper = new AttributeMapper(mapper, this.converterLookup, this.reflectionProvider);
        if (JVM.isVersion(5)) {
            mapper = this.buildMapperDynamically("com.thoughtworks.xstream.mapper.EnumMapper", new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper, class$java$lang$Boolean == null ? (class$java$lang$Boolean = XStream.class$("java.lang.Boolean")) : class$java$lang$Boolean}, new Object[]{mapper, this.is141Compatible});
        }
        mapper = new LocalConversionMapper(mapper);
        mapper = new ImmutableTypesMapper(mapper);
        if (JVM.isVersion(8) && !this.is141Compatible) {
            mapper = this.buildMapperDynamically("com.thoughtworks.xstream.mapper.LambdaMapper", new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper}, new Object[]{mapper});
        }
        mapper = new SecurityMapper(mapper);
        if (JVM.isVersion(5)) {
            mapper = this.buildMapperDynamically(ANNOTATION_MAPPER_TYPE, new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper, class$com$thoughtworks$xstream$converters$ConverterRegistry == null ? (class$com$thoughtworks$xstream$converters$ConverterRegistry = XStream.class$("com.thoughtworks.xstream.converters.ConverterRegistry")) : class$com$thoughtworks$xstream$converters$ConverterRegistry, class$com$thoughtworks$xstream$converters$ConverterLookup == null ? (class$com$thoughtworks$xstream$converters$ConverterLookup = XStream.class$("com.thoughtworks.xstream.converters.ConverterLookup")) : class$com$thoughtworks$xstream$converters$ConverterLookup, class$com$thoughtworks$xstream$core$ClassLoaderReference == null ? (class$com$thoughtworks$xstream$core$ClassLoaderReference = XStream.class$("com.thoughtworks.xstream.core.ClassLoaderReference")) : class$com$thoughtworks$xstream$core$ClassLoaderReference, class$com$thoughtworks$xstream$converters$reflection$ReflectionProvider == null ? (class$com$thoughtworks$xstream$converters$reflection$ReflectionProvider = XStream.class$("com.thoughtworks.xstream.converters.reflection.ReflectionProvider")) : class$com$thoughtworks$xstream$converters$reflection$ReflectionProvider}, new Object[]{mapper, this.converterRegistry, this.converterLookup, this.classLoaderReference, this.reflectionProvider});
        }
        mapper = this.wrapMapper((MapperWrapper)mapper);
        mapper = new CachingMapper(mapper);
        return mapper;
    }

    private Mapper buildMapperDynamically(String className, Class[] constructorParamTypes, Object[] constructorParamValues) {
        try {
            Class<?> type = Class.forName(className, false, this.classLoaderReference.getReference());
            Constructor<?> constructor = type.getConstructor(constructorParamTypes);
            return (Mapper)constructor.newInstance(constructorParamValues);
        }
        catch (Exception e) {
            throw new com.thoughtworks.xstream.InitializationException("Could not instantiate mapper : " + className, e);
        }
        catch (LinkageError e) {
            throw new com.thoughtworks.xstream.InitializationException("Could not instantiate mapper : " + className, e);
        }
    }

    protected MapperWrapper wrapMapper(MapperWrapper next) {
        return next;
    }

    protected boolean useXStream11XmlFriendlyMapper() {
        return false;
    }

    private void setupMappers() {
        this.packageAliasingMapper = (PackageAliasingMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$PackageAliasingMapper == null ? (class$com$thoughtworks$xstream$mapper$PackageAliasingMapper = XStream.class$("com.thoughtworks.xstream.mapper.PackageAliasingMapper")) : class$com$thoughtworks$xstream$mapper$PackageAliasingMapper);
        this.classAliasingMapper = (ClassAliasingMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$ClassAliasingMapper == null ? (class$com$thoughtworks$xstream$mapper$ClassAliasingMapper = XStream.class$("com.thoughtworks.xstream.mapper.ClassAliasingMapper")) : class$com$thoughtworks$xstream$mapper$ClassAliasingMapper);
        this.elementIgnoringMapper = (ElementIgnoringMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$ElementIgnoringMapper == null ? (class$com$thoughtworks$xstream$mapper$ElementIgnoringMapper = XStream.class$("com.thoughtworks.xstream.mapper.ElementIgnoringMapper")) : class$com$thoughtworks$xstream$mapper$ElementIgnoringMapper);
        this.fieldAliasingMapper = (FieldAliasingMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$FieldAliasingMapper == null ? (class$com$thoughtworks$xstream$mapper$FieldAliasingMapper = XStream.class$("com.thoughtworks.xstream.mapper.FieldAliasingMapper")) : class$com$thoughtworks$xstream$mapper$FieldAliasingMapper);
        this.attributeMapper = (AttributeMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$AttributeMapper == null ? (class$com$thoughtworks$xstream$mapper$AttributeMapper = XStream.class$("com.thoughtworks.xstream.mapper.AttributeMapper")) : class$com$thoughtworks$xstream$mapper$AttributeMapper);
        this.attributeAliasingMapper = (AttributeAliasingMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$AttributeAliasingMapper == null ? (class$com$thoughtworks$xstream$mapper$AttributeAliasingMapper = XStream.class$("com.thoughtworks.xstream.mapper.AttributeAliasingMapper")) : class$com$thoughtworks$xstream$mapper$AttributeAliasingMapper);
        this.systemAttributeAliasingMapper = (SystemAttributeAliasingMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$SystemAttributeAliasingMapper == null ? (class$com$thoughtworks$xstream$mapper$SystemAttributeAliasingMapper = XStream.class$("com.thoughtworks.xstream.mapper.SystemAttributeAliasingMapper")) : class$com$thoughtworks$xstream$mapper$SystemAttributeAliasingMapper);
        this.implicitCollectionMapper = (ImplicitCollectionMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$ImplicitCollectionMapper == null ? (class$com$thoughtworks$xstream$mapper$ImplicitCollectionMapper = XStream.class$("com.thoughtworks.xstream.mapper.ImplicitCollectionMapper")) : class$com$thoughtworks$xstream$mapper$ImplicitCollectionMapper);
        this.defaultImplementationsMapper = (DefaultImplementationsMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$DefaultImplementationsMapper == null ? (class$com$thoughtworks$xstream$mapper$DefaultImplementationsMapper = XStream.class$("com.thoughtworks.xstream.mapper.DefaultImplementationsMapper")) : class$com$thoughtworks$xstream$mapper$DefaultImplementationsMapper);
        this.immutableTypesMapper = (ImmutableTypesMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$ImmutableTypesMapper == null ? (class$com$thoughtworks$xstream$mapper$ImmutableTypesMapper = XStream.class$("com.thoughtworks.xstream.mapper.ImmutableTypesMapper")) : class$com$thoughtworks$xstream$mapper$ImmutableTypesMapper);
        this.localConversionMapper = (LocalConversionMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$LocalConversionMapper == null ? (class$com$thoughtworks$xstream$mapper$LocalConversionMapper = XStream.class$("com.thoughtworks.xstream.mapper.LocalConversionMapper")) : class$com$thoughtworks$xstream$mapper$LocalConversionMapper);
        this.securityMapper = (SecurityMapper)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$SecurityMapper == null ? (class$com$thoughtworks$xstream$mapper$SecurityMapper = XStream.class$("com.thoughtworks.xstream.mapper.SecurityMapper")) : class$com$thoughtworks$xstream$mapper$SecurityMapper);
        this.annotationConfiguration = (AnnotationConfiguration)((Object)this.mapper.lookupMapperOfType(class$com$thoughtworks$xstream$mapper$AnnotationConfiguration == null ? (class$com$thoughtworks$xstream$mapper$AnnotationConfiguration = XStream.class$("com.thoughtworks.xstream.mapper.AnnotationConfiguration")) : class$com$thoughtworks$xstream$mapper$AnnotationConfiguration));
    }

    protected void setupSecurity() {
        if (this.securityMapper == null) {
            return;
        }
        this.addPermission(AnyTypePermission.ANY);
        this.securityInitialized = false;
    }

    public static void setupDefaultSecurity(XStream xstream) {
        Class[] classes;
        if (!xstream.securityInitialized) {
            xstream.addPermission(NoTypePermission.NONE);
            xstream.addPermission(NullPermission.NULL);
            xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
            xstream.addPermission(ArrayTypePermission.ARRAYS);
            xstream.addPermission(InterfaceTypePermission.INTERFACES);
            xstream.allowTypeHierarchy(class$java$util$Calendar == null ? (class$java$util$Calendar = XStream.class$("java.util.Calendar")) : class$java$util$Calendar);
            xstream.allowTypeHierarchy(class$java$util$Collection == null ? (class$java$util$Collection = XStream.class$("java.util.Collection")) : class$java$util$Collection);
            xstream.allowTypeHierarchy(class$java$util$Map == null ? (class$java$util$Map = XStream.class$("java.util.Map")) : class$java$util$Map);
            xstream.allowTypeHierarchy(class$java$util$Map$Entry == null ? (class$java$util$Map$Entry = XStream.class$("java.util.Map$Entry")) : class$java$util$Map$Entry);
            xstream.allowTypeHierarchy(class$java$lang$reflect$Member == null ? (class$java$lang$reflect$Member = XStream.class$("java.lang.reflect.Member")) : class$java$lang$reflect$Member);
            xstream.allowTypeHierarchy(class$java$lang$Number == null ? (class$java$lang$Number = XStream.class$("java.lang.Number")) : class$java$lang$Number);
            xstream.allowTypeHierarchy(class$java$lang$Throwable == null ? (class$java$lang$Throwable = XStream.class$("java.lang.Throwable")) : class$java$lang$Throwable);
            xstream.allowTypeHierarchy(class$java$util$TimeZone == null ? (class$java$util$TimeZone = XStream.class$("java.util.TimeZone")) : class$java$util$TimeZone);
            Class type = JVM.loadClassForName("java.lang.Enum");
            if (type != null) {
                xstream.allowTypeHierarchy(type);
            }
            if ((type = JVM.loadClassForName("java.nio.file.Path")) != null) {
                xstream.allowTypeHierarchy(type);
            }
            HashSet<Class> types = new HashSet<Class>();
            types.add(class$java$util$BitSet == null ? (class$java$util$BitSet = XStream.class$("java.util.BitSet")) : class$java$util$BitSet);
            types.add(class$java$nio$charset$Charset == null ? (class$java$nio$charset$Charset = XStream.class$("java.nio.charset.Charset")) : class$java$nio$charset$Charset);
            types.add(class$java$lang$Class == null ? (class$java$lang$Class = XStream.class$("java.lang.Class")) : class$java$lang$Class);
            types.add(class$java$util$Currency == null ? (class$java$util$Currency = XStream.class$("java.util.Currency")) : class$java$util$Currency);
            types.add(class$java$util$Date == null ? (class$java$util$Date = XStream.class$("java.util.Date")) : class$java$util$Date);
            types.add(class$java$text$DecimalFormatSymbols == null ? (class$java$text$DecimalFormatSymbols = XStream.class$("java.text.DecimalFormatSymbols")) : class$java$text$DecimalFormatSymbols);
            types.add(class$java$io$File == null ? (class$java$io$File = XStream.class$("java.io.File")) : class$java$io$File);
            types.add(class$java$util$Locale == null ? (class$java$util$Locale = XStream.class$("java.util.Locale")) : class$java$util$Locale);
            types.add(class$java$lang$Object == null ? (class$java$lang$Object = XStream.class$("java.lang.Object")) : class$java$lang$Object);
            types.add(class$java$util$regex$Pattern == null ? (class$java$util$regex$Pattern = XStream.class$("java.util.regex.Pattern")) : class$java$util$regex$Pattern);
            types.add(class$java$lang$StackTraceElement == null ? (class$java$lang$StackTraceElement = XStream.class$("java.lang.StackTraceElement")) : class$java$lang$StackTraceElement);
            types.add(class$java$lang$String == null ? (class$java$lang$String = XStream.class$("java.lang.String")) : class$java$lang$String);
            types.add(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = XStream.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
            types.add(JVM.loadClassForName("java.lang.StringBuilder"));
            types.add(class$java$net$URL == null ? (class$java$net$URL = XStream.class$("java.net.URL")) : class$java$net$URL);
            types.add(class$java$net$URI == null ? (class$java$net$URI = XStream.class$("java.net.URI")) : class$java$net$URI);
            types.add(JVM.loadClassForName("java.util.UUID"));
            if (JVM.isSQLAvailable()) {
                types.add(JVM.loadClassForName("java.sql.Timestamp"));
                types.add(JVM.loadClassForName("java.sql.Time"));
                types.add(JVM.loadClassForName("java.sql.Date"));
            }
            if (JVM.isVersion(8)) {
                xstream.allowTypeHierarchy(JVM.loadClassForName("java.time.Clock"));
                types.add(JVM.loadClassForName("java.time.Duration"));
                types.add(JVM.loadClassForName("java.time.Instant"));
                types.add(JVM.loadClassForName("java.time.LocalDate"));
                types.add(JVM.loadClassForName("java.time.LocalDateTime"));
                types.add(JVM.loadClassForName("java.time.LocalTime"));
                types.add(JVM.loadClassForName("java.time.MonthDay"));
                types.add(JVM.loadClassForName("java.time.OffsetDateTime"));
                types.add(JVM.loadClassForName("java.time.OffsetTime"));
                types.add(JVM.loadClassForName("java.time.Period"));
                types.add(JVM.loadClassForName("java.time.Ser"));
                types.add(JVM.loadClassForName("java.time.Year"));
                types.add(JVM.loadClassForName("java.time.YearMonth"));
                types.add(JVM.loadClassForName("java.time.ZonedDateTime"));
                xstream.allowTypeHierarchy(JVM.loadClassForName("java.time.ZoneId"));
                types.add(JVM.loadClassForName("java.time.chrono.HijrahDate"));
                types.add(JVM.loadClassForName("java.time.chrono.JapaneseDate"));
                types.add(JVM.loadClassForName("java.time.chrono.JapaneseEra"));
                types.add(JVM.loadClassForName("java.time.chrono.MinguoDate"));
                types.add(JVM.loadClassForName("java.time.chrono.ThaiBuddhistDate"));
                types.add(JVM.loadClassForName("java.time.chrono.Ser"));
                xstream.allowTypeHierarchy(JVM.loadClassForName("java.time.chrono.Chronology"));
                types.add(JVM.loadClassForName("java.time.temporal.ValueRange"));
                types.add(JVM.loadClassForName("java.time.temporal.WeekFields"));
            }
            types.remove(null);
            Iterator iter = types.iterator();
            classes = new Class[types.size()];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = (Class)iter.next();
            }
        } else {
            throw new IllegalArgumentException("Security framework of XStream instance already initialized");
        }
        xstream.allowTypes(classes);
    }

    protected void setupAliases() {
        Class type;
        if (this.classAliasingMapper == null) {
            return;
        }
        this.alias("null", class$com$thoughtworks$xstream$mapper$Mapper$Null == null ? (class$com$thoughtworks$xstream$mapper$Mapper$Null = XStream.class$("com.thoughtworks.xstream.mapper.Mapper$Null")) : class$com$thoughtworks$xstream$mapper$Mapper$Null);
        this.alias("int", class$java$lang$Integer == null ? (class$java$lang$Integer = XStream.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.alias("float", class$java$lang$Float == null ? (class$java$lang$Float = XStream.class$("java.lang.Float")) : class$java$lang$Float);
        this.alias("double", class$java$lang$Double == null ? (class$java$lang$Double = XStream.class$("java.lang.Double")) : class$java$lang$Double);
        this.alias("long", class$java$lang$Long == null ? (class$java$lang$Long = XStream.class$("java.lang.Long")) : class$java$lang$Long);
        this.alias("short", class$java$lang$Short == null ? (class$java$lang$Short = XStream.class$("java.lang.Short")) : class$java$lang$Short);
        this.alias("char", class$java$lang$Character == null ? (class$java$lang$Character = XStream.class$("java.lang.Character")) : class$java$lang$Character);
        this.alias("byte", class$java$lang$Byte == null ? (class$java$lang$Byte = XStream.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.alias("boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = XStream.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.alias("number", class$java$lang$Number == null ? (class$java$lang$Number = XStream.class$("java.lang.Number")) : class$java$lang$Number);
        this.alias("object", class$java$lang$Object == null ? (class$java$lang$Object = XStream.class$("java.lang.Object")) : class$java$lang$Object);
        this.alias("big-int", class$java$math$BigInteger == null ? (class$java$math$BigInteger = XStream.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        this.alias("big-decimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = XStream.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        this.alias("string-buffer", class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = XStream.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        this.alias("string", class$java$lang$String == null ? (class$java$lang$String = XStream.class$("java.lang.String")) : class$java$lang$String);
        this.alias("java-class", class$java$lang$Class == null ? (class$java$lang$Class = XStream.class$("java.lang.Class")) : class$java$lang$Class);
        this.alias("method", class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = XStream.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method);
        this.alias("constructor", class$java$lang$reflect$Constructor == null ? (class$java$lang$reflect$Constructor = XStream.class$("java.lang.reflect.Constructor")) : class$java$lang$reflect$Constructor);
        this.alias("field", class$java$lang$reflect$Field == null ? (class$java$lang$reflect$Field = XStream.class$("java.lang.reflect.Field")) : class$java$lang$reflect$Field);
        this.alias("date", class$java$util$Date == null ? (class$java$util$Date = XStream.class$("java.util.Date")) : class$java$util$Date);
        this.alias("uri", class$java$net$URI == null ? (class$java$net$URI = XStream.class$("java.net.URI")) : class$java$net$URI);
        this.alias("url", class$java$net$URL == null ? (class$java$net$URL = XStream.class$("java.net.URL")) : class$java$net$URL);
        this.alias("bit-set", class$java$util$BitSet == null ? (class$java$util$BitSet = XStream.class$("java.util.BitSet")) : class$java$util$BitSet);
        this.alias("map", class$java$util$Map == null ? (class$java$util$Map = XStream.class$("java.util.Map")) : class$java$util$Map);
        this.alias("entry", class$java$util$Map$Entry == null ? (class$java$util$Map$Entry = XStream.class$("java.util.Map$Entry")) : class$java$util$Map$Entry);
        this.alias("properties", class$java$util$Properties == null ? (class$java$util$Properties = XStream.class$("java.util.Properties")) : class$java$util$Properties);
        this.alias("list", class$java$util$List == null ? (class$java$util$List = XStream.class$("java.util.List")) : class$java$util$List);
        this.alias("set", class$java$util$Set == null ? (class$java$util$Set = XStream.class$("java.util.Set")) : class$java$util$Set);
        this.alias("sorted-set", class$java$util$SortedSet == null ? (class$java$util$SortedSet = XStream.class$("java.util.SortedSet")) : class$java$util$SortedSet);
        this.alias("linked-list", class$java$util$LinkedList == null ? (class$java$util$LinkedList = XStream.class$("java.util.LinkedList")) : class$java$util$LinkedList);
        this.alias("vector", class$java$util$Vector == null ? (class$java$util$Vector = XStream.class$("java.util.Vector")) : class$java$util$Vector);
        this.alias("tree-map", class$java$util$TreeMap == null ? (class$java$util$TreeMap = XStream.class$("java.util.TreeMap")) : class$java$util$TreeMap);
        this.alias("tree-set", class$java$util$TreeSet == null ? (class$java$util$TreeSet = XStream.class$("java.util.TreeSet")) : class$java$util$TreeSet);
        this.alias("hashtable", class$java$util$Hashtable == null ? (class$java$util$Hashtable = XStream.class$("java.util.Hashtable")) : class$java$util$Hashtable);
        if (!this.is141Compatible) {
            this.alias("empty-list", Collections.EMPTY_LIST.getClass());
            this.alias("empty-map", Collections.EMPTY_MAP.getClass());
            this.alias("empty-set", Collections.EMPTY_SET.getClass());
            this.alias("singleton-list", Collections.singletonList(this).getClass());
            this.alias("singleton-map", Collections.singletonMap(this, null).getClass());
            this.alias("singleton-set", Collections.singleton(this).getClass());
        }
        if (JVM.isAWTAvailable()) {
            this.alias("awt-color", JVM.loadClassForName("java.awt.Color", false));
            this.alias("awt-font", JVM.loadClassForName("java.awt.Font", false));
            this.alias("awt-text-attribute", JVM.loadClassForName("java.awt.font.TextAttribute"));
        }
        if ((type = JVM.loadClassForName("javax.activation.ActivationDataFlavor")) != null && !this.is141Compatible) {
            this.alias("activation-data-flavor", type);
        }
        if (JVM.isSQLAvailable()) {
            this.alias("sql-timestamp", JVM.loadClassForName("java.sql.Timestamp"));
            this.alias("sql-time", JVM.loadClassForName("java.sql.Time"));
            this.alias("sql-date", JVM.loadClassForName("java.sql.Date"));
        }
        this.alias("file", class$java$io$File == null ? (class$java$io$File = XStream.class$("java.io.File")) : class$java$io$File);
        this.alias("locale", class$java$util$Locale == null ? (class$java$util$Locale = XStream.class$("java.util.Locale")) : class$java$util$Locale);
        this.alias("gregorian-calendar", class$java$util$Calendar == null ? (class$java$util$Calendar = XStream.class$("java.util.Calendar")) : class$java$util$Calendar);
        if (JVM.isVersion(4)) {
            this.aliasDynamically("auth-subject", "javax.security.auth.Subject");
            this.alias("linked-hash-map", JVM.loadClassForName("java.util.LinkedHashMap"));
            this.alias("linked-hash-set", JVM.loadClassForName("java.util.LinkedHashSet"));
            this.alias("trace", JVM.loadClassForName("java.lang.StackTraceElement"));
            this.alias("currency", JVM.loadClassForName("java.util.Currency"));
            this.aliasType("charset", JVM.loadClassForName("java.nio.charset.Charset"));
        }
        if (JVM.isVersion(5)) {
            this.aliasDynamically(this.is141Compatible ? "duration" : "xml-duration", "javax.xml.datatype.Duration");
            if (!this.is141Compatible) {
                this.alias("concurrent-hash-map", JVM.loadClassForName("java.util.concurrent.ConcurrentHashMap"));
            }
            this.alias("enum-set", JVM.loadClassForName("java.util.EnumSet"));
            this.alias("enum-map", JVM.loadClassForName("java.util.EnumMap"));
            this.alias("string-builder", JVM.loadClassForName("java.lang.StringBuilder"));
            this.alias("uuid", JVM.loadClassForName("java.util.UUID"));
        }
        if (JVM.isVersion(7) && !this.is141Compatible) {
            this.aliasType("path", JVM.loadClassForName("java.nio.file.Path"));
        }
        if (JVM.isVersion(8) && !this.is141Compatible) {
            this.alias("fixed-clock", JVM.loadClassForName("java.time.Clock$FixedClock"));
            this.alias("offset-clock", JVM.loadClassForName("java.time.Clock$OffsetClock"));
            this.alias("system-clock", JVM.loadClassForName("java.time.Clock$SystemClock"));
            this.alias("tick-clock", JVM.loadClassForName("java.time.Clock$TickClock"));
            this.alias("day-of-week", JVM.loadClassForName("java.time.DayOfWeek"));
            this.alias("duration", JVM.loadClassForName("java.time.Duration"));
            this.alias("instant", JVM.loadClassForName("java.time.Instant"));
            this.alias("local-date", JVM.loadClassForName("java.time.LocalDate"));
            this.alias("local-date-time", JVM.loadClassForName("java.time.LocalDateTime"));
            this.alias("local-time", JVM.loadClassForName("java.time.LocalTime"));
            this.alias("month", JVM.loadClassForName("java.time.Month"));
            this.alias("month-day", JVM.loadClassForName("java.time.MonthDay"));
            this.alias("offset-date-time", JVM.loadClassForName("java.time.OffsetDateTime"));
            this.alias("offset-time", JVM.loadClassForName("java.time.OffsetTime"));
            this.alias("period", JVM.loadClassForName("java.time.Period"));
            this.alias("year", JVM.loadClassForName("java.time.Year"));
            this.alias("year-month", JVM.loadClassForName("java.time.YearMonth"));
            this.alias("zoned-date-time", JVM.loadClassForName("java.time.ZonedDateTime"));
            this.aliasType("zone-id", JVM.loadClassForName("java.time.ZoneId"));
            this.aliasType("chronology", JVM.loadClassForName("java.time.chrono.Chronology"));
            this.alias("hijrah-date", JVM.loadClassForName("java.time.chrono.HijrahDate"));
            this.alias("hijrah-era", JVM.loadClassForName("java.time.chrono.HijrahEra"));
            this.alias("japanese-date", JVM.loadClassForName("java.time.chrono.JapaneseDate"));
            this.alias("japanese-era", JVM.loadClassForName("java.time.chrono.JapaneseEra"));
            this.alias("minguo-date", JVM.loadClassForName("java.time.chrono.MinguoDate"));
            this.alias("minguo-era", JVM.loadClassForName("java.time.chrono.MinguoEra"));
            this.alias("thai-buddhist-date", JVM.loadClassForName("java.time.chrono.ThaiBuddhistDate"));
            this.alias("thai-buddhist-era", JVM.loadClassForName("java.time.chrono.ThaiBuddhistEra"));
            this.alias("chrono-field", JVM.loadClassForName("java.time.temporal.ChronoField"));
            this.alias("chrono-unit", JVM.loadClassForName("java.time.temporal.ChronoUnit"));
            this.alias("iso-field", JVM.loadClassForName("java.time.temporal.IsoFields$Field"));
            this.alias("iso-unit", JVM.loadClassForName("java.time.temporal.IsoFields$Unit"));
            this.alias("julian-field", JVM.loadClassForName("java.time.temporal.JulianFields$Field"));
            this.alias("temporal-value-range", JVM.loadClassForName("java.time.temporal.ValueRange"));
            this.alias("week-fields", JVM.loadClassForName("java.time.temporal.WeekFields"));
        }
        if (JVM.loadClassForName("java.lang.invoke.SerializedLambda") != null && !this.is141Compatible) {
            this.aliasDynamically("serialized-lambda", "java.lang.invoke.SerializedLambda");
        }
    }

    private void aliasDynamically(String alias, String className) {
        Class type = JVM.loadClassForName(className);
        if (type != null) {
            this.alias(alias, type);
        }
    }

    protected void setupDefaultImplementations() {
        if (this.defaultImplementationsMapper == null) {
            return;
        }
        this.addDefaultImplementation(class$java$util$HashMap == null ? (class$java$util$HashMap = XStream.class$("java.util.HashMap")) : class$java$util$HashMap, class$java$util$Map == null ? (class$java$util$Map = XStream.class$("java.util.Map")) : class$java$util$Map);
        this.addDefaultImplementation(class$java$util$ArrayList == null ? (class$java$util$ArrayList = XStream.class$("java.util.ArrayList")) : class$java$util$ArrayList, class$java$util$List == null ? (class$java$util$List = XStream.class$("java.util.List")) : class$java$util$List);
        this.addDefaultImplementation(class$java$util$HashSet == null ? (class$java$util$HashSet = XStream.class$("java.util.HashSet")) : class$java$util$HashSet, class$java$util$Set == null ? (class$java$util$Set = XStream.class$("java.util.Set")) : class$java$util$Set);
        this.addDefaultImplementation(class$java$util$TreeSet == null ? (class$java$util$TreeSet = XStream.class$("java.util.TreeSet")) : class$java$util$TreeSet, class$java$util$SortedSet == null ? (class$java$util$SortedSet = XStream.class$("java.util.SortedSet")) : class$java$util$SortedSet);
        this.addDefaultImplementation(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = XStream.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar, class$java$util$Calendar == null ? (class$java$util$Calendar = XStream.class$("java.util.Calendar")) : class$java$util$Calendar);
    }

    protected void setupConverters() {
        this.registerConverter(new ReflectionConverter(this.mapper, this.reflectionProvider), -20);
        this.registerConverter(new SerializableConverter(this.mapper, this.reflectionProvider, this.classLoaderReference), -10);
        this.registerConverter(new ExternalizableConverter(this.mapper, this.classLoaderReference), -10);
        this.registerConverter(new InternalBlackList(), -10);
        this.registerConverter(new NullConverter(), 10000);
        this.registerConverter(new IntConverter(), 0);
        this.registerConverter(new FloatConverter(), 0);
        this.registerConverter(new DoubleConverter(), 0);
        this.registerConverter(new LongConverter(), 0);
        this.registerConverter(new ShortConverter(), 0);
        this.registerConverter(new CharConverter(), 0);
        this.registerConverter(new BooleanConverter(), 0);
        this.registerConverter(new ByteConverter(), 0);
        this.registerConverter(new StringConverter(), 0);
        this.registerConverter(new StringBufferConverter(), 0);
        this.registerConverter(new DateConverter(), 0);
        this.registerConverter(new BitSetConverter(), 0);
        this.registerConverter(new URIConverter(), 0);
        this.registerConverter(new URLConverter(), 0);
        this.registerConverter(new BigIntegerConverter(), 0);
        this.registerConverter(new BigDecimalConverter(), 0);
        this.registerConverter(new ArrayConverter(this.mapper), 0);
        this.registerConverter(new CharArrayConverter(), 0);
        this.registerConverter(new CollectionConverter(this.mapper), 0);
        this.registerConverter(new MapConverter(this.mapper), 0);
        this.registerConverter(new TreeMapConverter(this.mapper), 0);
        this.registerConverter(new TreeSetConverter(this.mapper), 0);
        if (!this.is141Compatible) {
            this.registerConverter(new SingletonCollectionConverter(this.mapper), 0);
            this.registerConverter(new SingletonMapConverter(this.mapper), 0);
        }
        this.registerConverter(new PropertiesConverter(), 0);
        this.registerConverter(new EncodedByteArrayConverter(), 0);
        this.registerConverter(new FileConverter(), 0);
        if (JVM.isSQLAvailable()) {
            this.registerConverter(new SqlTimestampConverter(), 0);
            this.registerConverter(new SqlTimeConverter(), 0);
            this.registerConverter(new SqlDateConverter(), 0);
        }
        this.registerConverter(new DynamicProxyConverter(this.mapper, this.classLoaderReference), 0);
        this.registerConverter(new JavaClassConverter(this.classLoaderReference), 0);
        this.registerConverter(new JavaMethodConverter(this.classLoaderReference), 0);
        this.registerConverter(new JavaFieldConverter(this.classLoaderReference), 0);
        if (JVM.isAWTAvailable()) {
            this.registerConverter(new FontConverter(this.mapper), 0);
            this.registerConverter(new ColorConverter(), 0);
            this.registerConverter(new TextAttributeConverter(), 0);
        }
        if (JVM.isSwingAvailable()) {
            this.registerConverter(new LookAndFeelConverter(this.mapper, this.reflectionProvider), 0);
        }
        this.registerConverter(new LocaleConverter(), 0);
        this.registerConverter(new GregorianCalendarConverter(), 0);
        if (JVM.isVersion(4)) {
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.SubjectConverter", 0, new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper}, new Object[]{this.mapper});
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.ThrowableConverter", 0, new Class[]{class$com$thoughtworks$xstream$converters$ConverterLookup == null ? (class$com$thoughtworks$xstream$converters$ConverterLookup = XStream.class$("com.thoughtworks.xstream.converters.ConverterLookup")) : class$com$thoughtworks$xstream$converters$ConverterLookup}, new Object[]{this.converterLookup});
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.StackTraceElementConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.CurrencyConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.RegexPatternConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.CharsetConverter", 0, null, null);
        }
        if (JVM.isVersion(5)) {
            if (JVM.loadClassForName("javax.xml.datatype.Duration") != null) {
                this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.DurationConverter", 0, null, null);
            }
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.enums.EnumConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.enums.EnumSetConverter", 0, new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper}, new Object[]{this.mapper});
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.enums.EnumMapConverter", 0, new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper}, new Object[]{this.mapper});
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.basic.StringBuilderConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.basic.UUIDConverter", 0, null, null);
        }
        if (!this.is141Compatible && JVM.loadClassForName("javax.activation.ActivationDataFlavor") != null) {
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.ActivationDataFlavorConverter", 0, null, null);
        }
        if (!this.is141Compatible && JVM.isVersion(7)) {
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.extended.PathConverter", 0, null, null);
        }
        if (!this.is141Compatible && JVM.isVersion(8)) {
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.ChronologyConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.DurationConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.HijrahDateConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.JapaneseDateConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.JapaneseEraConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.InstantConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.LocalDateConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.LocalDateTimeConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.LocalTimeConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.MinguoDateConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.MonthDayConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.OffsetDateTimeConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.OffsetTimeConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.PeriodConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.SystemClockConverter", 0, new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper}, new Object[]{this.mapper});
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.ThaiBuddhistDateConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.ValueRangeConverter", 0, new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper}, new Object[]{this.mapper});
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.WeekFieldsConverter", 0, new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper}, new Object[]{this.mapper});
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.YearConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.YearMonthConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.ZonedDateTimeConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.time.ZoneIdConverter", 0, null, null);
            this.registerConverterDynamically("com.thoughtworks.xstream.converters.reflection.LambdaConverter", 0, new Class[]{class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStream.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper, class$com$thoughtworks$xstream$converters$reflection$ReflectionProvider == null ? (class$com$thoughtworks$xstream$converters$reflection$ReflectionProvider = XStream.class$("com.thoughtworks.xstream.converters.reflection.ReflectionProvider")) : class$com$thoughtworks$xstream$converters$reflection$ReflectionProvider, class$com$thoughtworks$xstream$core$ClassLoaderReference == null ? (class$com$thoughtworks$xstream$core$ClassLoaderReference = XStream.class$("com.thoughtworks.xstream.core.ClassLoaderReference")) : class$com$thoughtworks$xstream$core$ClassLoaderReference}, new Object[]{this.mapper, this.reflectionProvider, this.classLoaderReference});
        }
        this.registerConverter(new SelfStreamingInstanceChecker(this.converterLookup, (Object)this), 0);
    }

    private void registerConverterDynamically(String className, int priority, Class[] constructorParamTypes, Object[] constructorParamValues) {
        try {
            Class<?> type = Class.forName(className, false, this.classLoaderReference.getReference());
            Constructor<?> constructor = type.getConstructor(constructorParamTypes);
            Object instance = constructor.newInstance(constructorParamValues);
            if (instance instanceof Converter) {
                this.registerConverter((Converter)instance, priority);
            } else if (instance instanceof SingleValueConverter) {
                this.registerConverter((SingleValueConverter)instance, priority);
            }
        }
        catch (Exception e) {
            throw new com.thoughtworks.xstream.InitializationException("Could not instantiate converter : " + className, e);
        }
        catch (LinkageError e) {
            throw new com.thoughtworks.xstream.InitializationException("Could not instantiate converter : " + className, e);
        }
    }

    protected void setupImmutableTypes() {
        block14: {
            Class type;
            if (this.immutableTypesMapper == null) {
                return;
            }
            this.addImmutableType(Boolean.TYPE, false);
            this.addImmutableType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = XStream.class$("java.lang.Boolean")) : class$java$lang$Boolean, false);
            this.addImmutableType(Byte.TYPE, false);
            this.addImmutableType(class$java$lang$Byte == null ? (class$java$lang$Byte = XStream.class$("java.lang.Byte")) : class$java$lang$Byte, false);
            this.addImmutableType(Character.TYPE, false);
            this.addImmutableType(class$java$lang$Character == null ? (class$java$lang$Character = XStream.class$("java.lang.Character")) : class$java$lang$Character, false);
            this.addImmutableType(Double.TYPE, false);
            this.addImmutableType(class$java$lang$Double == null ? (class$java$lang$Double = XStream.class$("java.lang.Double")) : class$java$lang$Double, false);
            this.addImmutableType(Float.TYPE, false);
            this.addImmutableType(class$java$lang$Float == null ? (class$java$lang$Float = XStream.class$("java.lang.Float")) : class$java$lang$Float, false);
            this.addImmutableType(Integer.TYPE, false);
            this.addImmutableType(class$java$lang$Integer == null ? (class$java$lang$Integer = XStream.class$("java.lang.Integer")) : class$java$lang$Integer, false);
            this.addImmutableType(Long.TYPE, false);
            this.addImmutableType(class$java$lang$Long == null ? (class$java$lang$Long = XStream.class$("java.lang.Long")) : class$java$lang$Long, false);
            this.addImmutableType(Short.TYPE, false);
            this.addImmutableType(class$java$lang$Short == null ? (class$java$lang$Short = XStream.class$("java.lang.Short")) : class$java$lang$Short, false);
            this.addImmutableType(class$com$thoughtworks$xstream$mapper$Mapper$Null == null ? (class$com$thoughtworks$xstream$mapper$Mapper$Null = XStream.class$("com.thoughtworks.xstream.mapper.Mapper$Null")) : class$com$thoughtworks$xstream$mapper$Mapper$Null, false);
            this.addImmutableType(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = XStream.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, false);
            this.addImmutableType(class$java$math$BigInteger == null ? (class$java$math$BigInteger = XStream.class$("java.math.BigInteger")) : class$java$math$BigInteger, false);
            this.addImmutableType(class$java$lang$String == null ? (class$java$lang$String = XStream.class$("java.lang.String")) : class$java$lang$String, false);
            this.addImmutableType(class$java$net$URI == null ? (class$java$net$URI = XStream.class$("java.net.URI")) : class$java$net$URI, true);
            this.addImmutableType(class$java$net$URL == null ? (class$java$net$URL = XStream.class$("java.net.URL")) : class$java$net$URL, false);
            this.addImmutableType(class$java$io$File == null ? (class$java$io$File = XStream.class$("java.io.File")) : class$java$io$File, false);
            this.addImmutableType(class$java$lang$Class == null ? (class$java$lang$Class = XStream.class$("java.lang.Class")) : class$java$lang$Class, false);
            if (!this.is141Compatible) {
                this.addImmutableType(Collections.EMPTY_LIST.getClass(), true);
                this.addImmutableType(Collections.EMPTY_SET.getClass(), true);
                this.addImmutableType(Collections.EMPTY_MAP.getClass(), true);
            }
            if (!this.is141Compatible && JVM.isVersion(7) && (type = JVM.loadClassForName("java.nio.file.Paths")) != null) {
                try {
                    Object path;
                    Method methodGet = type.getDeclaredMethod("get", class$java$lang$String == null ? (class$java$lang$String = XStream.class$("java.lang.String")) : class$java$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = XStream.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    if (methodGet != null && (path = methodGet.invoke(null, ".", new String[0])) != null) {
                        this.addImmutableType(path.getClass(), false);
                    }
                }
                catch (NoSuchMethodException e) {
                }
                catch (SecurityException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                }
                catch (RuntimeException e) {
                    if ("java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) break block14;
                    throw e;
                }
            }
        }
        if (JVM.isAWTAvailable()) {
            this.addImmutableTypeDynamically("java.awt.font.TextAttribute", false);
        }
        if (JVM.isVersion(4)) {
            this.addImmutableTypeDynamically("java.nio.charset.Charset", true);
            this.addImmutableTypeDynamically("java.util.Currency", true);
        }
        if (!this.is141Compatible && JVM.isVersion(5)) {
            this.addImmutableTypeDynamically("java.util.UUID", true);
        }
        if (!this.is141Compatible && JVM.isVersion(8)) {
            this.addImmutableTypeDynamically("java.time.Duration", false);
            this.addImmutableTypeDynamically("java.time.Instant", false);
            this.addImmutableTypeDynamically("java.time.LocalDate", false);
            this.addImmutableTypeDynamically("java.time.LocalDateTime", false);
            this.addImmutableTypeDynamically("java.time.LocalTime", false);
            this.addImmutableTypeDynamically("java.time.MonthDay", false);
            this.addImmutableTypeDynamically("java.time.OffsetDateTime", false);
            this.addImmutableTypeDynamically("java.time.OffsetTime", false);
            this.addImmutableTypeDynamically("java.time.Period", false);
            this.addImmutableTypeDynamically("java.time.Year", false);
            this.addImmutableTypeDynamically("java.time.YearMonth", false);
            this.addImmutableTypeDynamically("java.time.ZonedDateTime", false);
            this.addImmutableTypeDynamically("java.time.ZoneId", false);
            this.addImmutableTypeDynamically("java.time.ZoneOffset", false);
            this.addImmutableTypeDynamically("java.time.ZoneRegion", false);
            this.addImmutableTypeDynamically("java.time.chrono.HijrahChronology", false);
            this.addImmutableTypeDynamically("java.time.chrono.HijrahDate", false);
            this.addImmutableTypeDynamically("java.time.chrono.IsoChronology", false);
            this.addImmutableTypeDynamically("java.time.chrono.JapaneseChronology", false);
            this.addImmutableTypeDynamically("java.time.chrono.JapaneseDate", false);
            this.addImmutableTypeDynamically("java.time.chrono.JapaneseEra", false);
            this.addImmutableTypeDynamically("java.time.chrono.MinguoChronology", false);
            this.addImmutableTypeDynamically("java.time.chrono.MinguoDate", false);
            this.addImmutableTypeDynamically("java.time.chrono.ThaiBuddhistChronology", false);
            this.addImmutableTypeDynamically("java.time.chrono.ThaiBuddhistDate", false);
            this.addImmutableTypeDynamically("java.time.temporal.IsoFields$Field", false);
            this.addImmutableTypeDynamically("java.time.temporal.IsoFields$Unit", false);
            this.addImmutableTypeDynamically("java.time.temporal.JulianFields$Field", false);
        }
    }

    private void addImmutableTypeDynamically(String className, boolean isReferenceable) {
        Class type = JVM.loadClassForName(className);
        if (type != null) {
            this.addImmutableType(type, isReferenceable);
        }
    }

    public void setMarshallingStrategy(MarshallingStrategy marshallingStrategy) {
        this.marshallingStrategy = marshallingStrategy;
    }

    public String toXML(Object obj) {
        StringWriter writer = new StringWriter();
        this.toXML(obj, writer);
        return ((Object)writer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXML(Object obj, Writer out) {
        HierarchicalStreamWriter writer = this.hierarchicalStreamDriver.createWriter(out);
        try {
            this.marshal(obj, writer);
        }
        finally {
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXML(Object obj, OutputStream out) {
        HierarchicalStreamWriter writer = this.hierarchicalStreamDriver.createWriter(out);
        try {
            this.marshal(obj, writer);
        }
        finally {
            writer.flush();
        }
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer) {
        this.marshal(obj, writer, null);
    }

    public void marshal(Object obj, HierarchicalStreamWriter writer, DataHolder dataHolder) {
        this.marshallingStrategy.marshal(writer, obj, this.converterLookup, this.mapper, dataHolder);
    }

    public Object fromXML(String xml) {
        return this.fromXML(new StringReader(xml));
    }

    public Object fromXML(Reader reader) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(reader), null);
    }

    public Object fromXML(InputStream input) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(input), null);
    }

    public Object fromXML(URL url) {
        return this.fromXML(url, null);
    }

    public Object fromXML(File file) {
        return this.fromXML(file, null);
    }

    public Object fromXML(String xml, Object root) {
        return this.fromXML(new StringReader(xml), root);
    }

    public Object fromXML(Reader xml, Object root) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(xml), root);
    }

    public Object fromXML(URL url, Object root) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(url), root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fromXML(File file, Object root) {
        HierarchicalStreamReader reader = this.hierarchicalStreamDriver.createReader(file);
        try {
            Object object = this.unmarshal(reader, root);
            return object;
        }
        finally {
            reader.close();
        }
    }

    public Object fromXML(InputStream input, Object root) {
        return this.unmarshal(this.hierarchicalStreamDriver.createReader(input), root);
    }

    public Object unmarshal(HierarchicalStreamReader reader) {
        return this.unmarshal(reader, null, null);
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root) {
        return this.unmarshal(reader, root, null);
    }

    public Object unmarshal(HierarchicalStreamReader reader, Object root, DataHolder dataHolder) {
        try {
            if (!this.securityInitialized && !this.securityWarningGiven) {
                this.securityWarningGiven = true;
                if (!this.is141Compatible) {
                    System.err.println("Security framework of XStream not initialized, XStream is probably vulnerable.");
                }
            }
            return this.marshallingStrategy.unmarshal(root, reader, dataHolder, this.converterLookup, this.mapper);
        }
        catch (ConversionException e) {
            Package pkg = this.getClass().getPackage();
            String version = pkg != null ? pkg.getImplementationVersion() : null;
            e.add("version", version != null ? version : "not available");
            throw e;
        }
    }

    public void alias(String name, Class type) {
        if (this.classAliasingMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$ClassAliasingMapper == null ? (class$com$thoughtworks$xstream$mapper$ClassAliasingMapper = XStream.class$("com.thoughtworks.xstream.mapper.ClassAliasingMapper")) : class$com$thoughtworks$xstream$mapper$ClassAliasingMapper).getName() + " available");
        }
        this.classAliasingMapper.addClassAlias(name, type);
    }

    public void aliasType(String name, Class type) {
        if (this.classAliasingMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$ClassAliasingMapper == null ? (class$com$thoughtworks$xstream$mapper$ClassAliasingMapper = XStream.class$("com.thoughtworks.xstream.mapper.ClassAliasingMapper")) : class$com$thoughtworks$xstream$mapper$ClassAliasingMapper).getName() + " available");
        }
        this.classAliasingMapper.addTypeAlias(name, type);
    }

    public void alias(String name, Class type, Class defaultImplementation) {
        this.alias(name, type);
        this.addDefaultImplementation(defaultImplementation, type);
    }

    public void aliasPackage(String name, String pkgName) {
        if (this.packageAliasingMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$PackageAliasingMapper == null ? (class$com$thoughtworks$xstream$mapper$PackageAliasingMapper = XStream.class$("com.thoughtworks.xstream.mapper.PackageAliasingMapper")) : class$com$thoughtworks$xstream$mapper$PackageAliasingMapper).getName() + " available");
        }
        this.packageAliasingMapper.addPackageAlias(name, pkgName);
    }

    public void aliasField(String alias, Class definedIn, String fieldName) {
        if (this.fieldAliasingMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$FieldAliasingMapper == null ? (class$com$thoughtworks$xstream$mapper$FieldAliasingMapper = XStream.class$("com.thoughtworks.xstream.mapper.FieldAliasingMapper")) : class$com$thoughtworks$xstream$mapper$FieldAliasingMapper).getName() + " available");
        }
        this.fieldAliasingMapper.addFieldAlias(alias, definedIn, fieldName);
    }

    public void aliasAttribute(String alias, String attributeName) {
        if (this.attributeAliasingMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$AttributeAliasingMapper == null ? (class$com$thoughtworks$xstream$mapper$AttributeAliasingMapper = XStream.class$("com.thoughtworks.xstream.mapper.AttributeAliasingMapper")) : class$com$thoughtworks$xstream$mapper$AttributeAliasingMapper).getName() + " available");
        }
        this.attributeAliasingMapper.addAliasFor(attributeName, alias);
    }

    public void aliasSystemAttribute(String alias, String systemAttributeName) {
        if (this.systemAttributeAliasingMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$SystemAttributeAliasingMapper == null ? (class$com$thoughtworks$xstream$mapper$SystemAttributeAliasingMapper = XStream.class$("com.thoughtworks.xstream.mapper.SystemAttributeAliasingMapper")) : class$com$thoughtworks$xstream$mapper$SystemAttributeAliasingMapper).getName() + " available");
        }
        this.systemAttributeAliasingMapper.addAliasFor(systemAttributeName, alias);
    }

    public void aliasAttribute(Class definedIn, String attributeName, String alias) {
        this.aliasField(alias, definedIn, attributeName);
        this.useAttributeFor(definedIn, attributeName);
    }

    public void useAttributeFor(String fieldName, Class type) {
        if (this.attributeMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$AttributeMapper == null ? (class$com$thoughtworks$xstream$mapper$AttributeMapper = XStream.class$("com.thoughtworks.xstream.mapper.AttributeMapper")) : class$com$thoughtworks$xstream$mapper$AttributeMapper).getName() + " available");
        }
        this.attributeMapper.addAttributeFor(fieldName, type);
    }

    public void useAttributeFor(Class definedIn, String fieldName) {
        if (this.attributeMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$AttributeMapper == null ? (class$com$thoughtworks$xstream$mapper$AttributeMapper = XStream.class$("com.thoughtworks.xstream.mapper.AttributeMapper")) : class$com$thoughtworks$xstream$mapper$AttributeMapper).getName() + " available");
        }
        this.attributeMapper.addAttributeFor(definedIn, fieldName);
    }

    public void useAttributeFor(Class type) {
        if (this.attributeMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$AttributeMapper == null ? (class$com$thoughtworks$xstream$mapper$AttributeMapper = XStream.class$("com.thoughtworks.xstream.mapper.AttributeMapper")) : class$com$thoughtworks$xstream$mapper$AttributeMapper).getName() + " available");
        }
        this.attributeMapper.addAttributeFor(type);
    }

    public void addDefaultImplementation(Class defaultImplementation, Class ofType) {
        if (this.defaultImplementationsMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$DefaultImplementationsMapper == null ? (class$com$thoughtworks$xstream$mapper$DefaultImplementationsMapper = XStream.class$("com.thoughtworks.xstream.mapper.DefaultImplementationsMapper")) : class$com$thoughtworks$xstream$mapper$DefaultImplementationsMapper).getName() + " available");
        }
        this.defaultImplementationsMapper.addDefaultImplementation(defaultImplementation, ofType);
    }

    public void addImmutableType(Class type) {
        this.addImmutableType(type, true);
    }

    public void addImmutableType(Class type, boolean isReferenceable) {
        if (this.immutableTypesMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$ImmutableTypesMapper == null ? (class$com$thoughtworks$xstream$mapper$ImmutableTypesMapper = XStream.class$("com.thoughtworks.xstream.mapper.ImmutableTypesMapper")) : class$com$thoughtworks$xstream$mapper$ImmutableTypesMapper).getName() + " available");
        }
        this.immutableTypesMapper.addImmutableType(type, this.is141Compatible || isReferenceable);
    }

    public void registerConverter(Converter converter) {
        this.registerConverter(converter, 0);
    }

    public void registerConverter(Converter converter, int priority) {
        if (this.converterRegistry != null) {
            this.converterRegistry.registerConverter(converter, priority);
        }
    }

    public void registerConverter(SingleValueConverter converter) {
        this.registerConverter(converter, 0);
    }

    public void registerConverter(SingleValueConverter converter, int priority) {
        if (this.converterRegistry != null) {
            this.converterRegistry.registerConverter(new SingleValueConverterWrapper(converter), priority);
        }
    }

    public void registerLocalConverter(Class definedIn, String fieldName, Converter converter) {
        if (this.localConversionMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$LocalConversionMapper == null ? (class$com$thoughtworks$xstream$mapper$LocalConversionMapper = XStream.class$("com.thoughtworks.xstream.mapper.LocalConversionMapper")) : class$com$thoughtworks$xstream$mapper$LocalConversionMapper).getName() + " available");
        }
        this.localConversionMapper.registerLocalConverter(definedIn, fieldName, converter);
    }

    public void registerLocalConverter(Class definedIn, String fieldName, SingleValueConverter converter) {
        this.registerLocalConverter(definedIn, fieldName, new SingleValueConverterWrapper(converter));
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public ReflectionProvider getReflectionProvider() {
        return this.reflectionProvider;
    }

    public ConverterLookup getConverterLookup() {
        return this.converterLookup;
    }

    public void setMode(int mode) {
        switch (mode) {
            case 1001: {
                this.setMarshallingStrategy(new TreeMarshallingStrategy());
                break;
            }
            case 1002: {
                this.setMarshallingStrategy(new ReferenceByIdMarshallingStrategy());
                break;
            }
            case 1003: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.RELATIVE));
                break;
            }
            case 1004: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.ABSOLUTE));
                break;
            }
            case 1005: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.RELATIVE | ReferenceByXPathMarshallingStrategy.SINGLE_NODE));
                break;
            }
            case 1006: {
                this.setMarshallingStrategy(new ReferenceByXPathMarshallingStrategy(ReferenceByXPathMarshallingStrategy.ABSOLUTE | ReferenceByXPathMarshallingStrategy.SINGLE_NODE));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode : " + mode);
            }
        }
    }

    public void addImplicitCollection(Class ownerType, String fieldName) {
        this.addImplicitCollection(ownerType, fieldName, null, null);
    }

    public void addImplicitCollection(Class ownerType, String fieldName, Class itemType) {
        this.addImplicitCollection(ownerType, fieldName, null, itemType);
    }

    public void addImplicitCollection(Class ownerType, String fieldName, String itemFieldName, Class itemType) {
        this.addImplicitMap(ownerType, fieldName, itemFieldName, itemType, null);
    }

    public void addImplicitArray(Class ownerType, String fieldName) {
        this.addImplicitCollection(ownerType, fieldName);
    }

    public void addImplicitArray(Class ownerType, String fieldName, Class itemType) {
        this.addImplicitCollection(ownerType, fieldName, itemType);
    }

    public void addImplicitArray(Class ownerType, String fieldName, String itemName) {
        this.addImplicitCollection(ownerType, fieldName, itemName, null);
    }

    public void addImplicitMap(Class ownerType, String fieldName, Class itemType, String keyFieldName) {
        this.addImplicitMap(ownerType, fieldName, null, itemType, keyFieldName);
    }

    public void addImplicitMap(Class ownerType, String fieldName, String itemName, Class itemType, String keyFieldName) {
        if (this.implicitCollectionMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$ImplicitCollectionMapper == null ? (class$com$thoughtworks$xstream$mapper$ImplicitCollectionMapper = XStream.class$("com.thoughtworks.xstream.mapper.ImplicitCollectionMapper")) : class$com$thoughtworks$xstream$mapper$ImplicitCollectionMapper).getName() + " available");
        }
        this.implicitCollectionMapper.add(ownerType, fieldName, itemName, itemType, keyFieldName);
    }

    public DataHolder newDataHolder() {
        return new MapBackedDataHolder();
    }

    public ObjectOutputStream createObjectOutputStream(Writer writer) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(writer), "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter writer) throws IOException {
        return this.createObjectOutputStream(writer, "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(Writer writer, String rootNodeName) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(writer), rootNodeName);
    }

    public ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(out), "object-stream");
    }

    public ObjectOutputStream createObjectOutputStream(OutputStream out, String rootNodeName) throws IOException {
        return this.createObjectOutputStream(this.hierarchicalStreamDriver.createWriter(out), rootNodeName);
    }

    public ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter writer, String rootNodeName) throws IOException {
        return this.createObjectOutputStream(writer, rootNodeName, null);
    }

    public ObjectOutputStream createObjectOutputStream(HierarchicalStreamWriter writer, String rootNodeName, final DataHolder dataHolder) throws IOException {
        final StatefulWriter statefulWriter = new StatefulWriter(writer);
        statefulWriter.startNode(rootNodeName, null);
        return new CustomObjectOutputStream(new CustomObjectOutputStream.StreamCallback(){

            public void writeToStream(Object object) {
                XStream.this.marshal(object, statefulWriter, dataHolder);
            }

            public void writeFieldsToStream(Map fields) throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void defaultWriteObject() throws NotActiveException {
                throw new NotActiveException("not in call to writeObject");
            }

            public void flush() {
                statefulWriter.flush();
            }

            public void close() {
                if (statefulWriter.state() != StatefulWriter.STATE_CLOSED) {
                    statefulWriter.endNode();
                    statefulWriter.close();
                }
            }
        });
    }

    public ObjectInputStream createObjectInputStream(Reader xmlReader) throws IOException {
        return this.createObjectInputStream(this.hierarchicalStreamDriver.createReader(xmlReader));
    }

    public ObjectInputStream createObjectInputStream(InputStream in) throws IOException {
        return this.createObjectInputStream(this.hierarchicalStreamDriver.createReader(in));
    }

    public ObjectInputStream createObjectInputStream(HierarchicalStreamReader reader) throws IOException {
        return this.createObjectInputStream(reader, null);
    }

    public ObjectInputStream createObjectInputStream(final HierarchicalStreamReader reader, final DataHolder dataHolder) throws IOException {
        return new CustomObjectInputStream(new CustomObjectInputStream.StreamCallback(){

            public Object readFromStream() throws EOFException {
                if (!reader.hasMoreChildren()) {
                    throw new EOFException();
                }
                reader.moveDown();
                Object result = XStream.this.unmarshal(reader, dataHolder);
                reader.moveUp();
                return result;
            }

            public Map readFieldsFromStream() throws IOException {
                throw new NotActiveException("not in call to readObject");
            }

            public void defaultReadObject() throws NotActiveException {
                throw new NotActiveException("not in call to readObject");
            }

            public void registerValidation(ObjectInputValidation validation, int priority) throws NotActiveException {
                throw new NotActiveException("stream inactive");
            }

            public void close() {
                reader.close();
            }
        }, this.classLoaderReference);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoaderReference.setReference(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoaderReference.getReference();
    }

    public ClassLoaderReference getClassLoaderReference() {
        return this.classLoaderReference;
    }

    public void omitField(Class definedIn, String fieldName) {
        if (this.elementIgnoringMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$ElementIgnoringMapper == null ? (class$com$thoughtworks$xstream$mapper$ElementIgnoringMapper = XStream.class$("com.thoughtworks.xstream.mapper.ElementIgnoringMapper")) : class$com$thoughtworks$xstream$mapper$ElementIgnoringMapper).getName() + " available");
        }
        this.elementIgnoringMapper.omitField(definedIn, fieldName);
    }

    public void ignoreUnknownElements() {
        this.ignoreUnknownElements(IGNORE_ALL);
    }

    public void ignoreUnknownElements(String pattern) {
        this.ignoreUnknownElements(Pattern.compile(pattern));
    }

    public void ignoreUnknownElements(Pattern pattern) {
        if (this.elementIgnoringMapper == null) {
            throw new com.thoughtworks.xstream.InitializationException("No " + (class$com$thoughtworks$xstream$mapper$ElementIgnoringMapper == null ? (class$com$thoughtworks$xstream$mapper$ElementIgnoringMapper = XStream.class$("com.thoughtworks.xstream.mapper.ElementIgnoringMapper")) : class$com$thoughtworks$xstream$mapper$ElementIgnoringMapper).getName() + " available");
        }
        this.elementIgnoringMapper.addElementsToIgnore(pattern);
    }

    public void processAnnotations(Class[] types) {
        if (this.annotationConfiguration == null) {
            throw new com.thoughtworks.xstream.InitializationException("No com.thoughtworks.xstream.mapper.AnnotationMapper available");
        }
        this.annotationConfiguration.processAnnotations(types);
    }

    public void processAnnotations(Class type) {
        this.processAnnotations(new Class[]{type});
    }

    public void autodetectAnnotations(boolean mode) {
        if (this.annotationConfiguration != null) {
            this.annotationConfiguration.autodetectAnnotations(mode);
        }
    }

    public void addPermission(TypePermission permission) {
        if (this.securityMapper != null) {
            this.securityInitialized = true;
            this.securityMapper.addPermission(permission);
        }
    }

    public void allowTypes(String[] names) {
        this.addPermission(new ExplicitTypePermission(names));
    }

    public void allowTypes(Class[] types) {
        this.addPermission(new ExplicitTypePermission(types));
    }

    public void allowTypeHierarchy(Class type) {
        this.addPermission(new TypeHierarchyPermission(type));
    }

    public void allowTypesByRegExp(String[] regexps) {
        this.addPermission(new RegExpTypePermission(regexps));
    }

    public void allowTypesByRegExp(Pattern[] regexps) {
        this.addPermission(new RegExpTypePermission(regexps));
    }

    public void allowTypesByWildcard(String[] patterns) {
        this.addPermission(new WildcardTypePermission(patterns));
    }

    public void denyPermission(TypePermission permission) {
        this.addPermission(new NoPermission(permission));
    }

    public void denyTypes(String[] names) {
        this.denyPermission(new ExplicitTypePermission(names));
    }

    public void denyTypes(Class[] types) {
        this.denyPermission(new ExplicitTypePermission(types));
    }

    public void denyTypeHierarchy(Class type) {
        this.denyPermission(new TypeHierarchyPermission(type));
    }

    public void denyTypesByRegExp(String[] regexps) {
        this.denyPermission(new RegExpTypePermission(regexps));
    }

    public void denyTypesByRegExp(Pattern[] regexps) {
        this.denyPermission(new RegExpTypePermission(regexps));
    }

    public void denyTypesByWildcard(String[] patterns) {
        this.denyPermission(new WildcardTypePermission(patterns));
    }

    private Object readResolve() {
        this.securityWarningGiven = true;
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InternalBlackList
    implements Converter {
        private InternalBlackList() {
        }

        public boolean canConvert(Class type) {
            return type == Void.TYPE || type == (class$java$lang$Void == null ? (class$java$lang$Void = XStream.class$("java.lang.Void")) : class$java$lang$Void) || !XStream.this.securityInitialized && type != null && (type.getName().equals("java.beans.EventHandler") || type.getName().endsWith("$LazyIterator") || type.getName().startsWith("javax.crypto."));
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            throw new ConversionException("Security alert. Marshalling rejected.");
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            throw new ConversionException("Security alert. Unmarshalling rejected.");
        }
    }

    public static class InitializationException
    extends XStreamException {
        public InitializationException(String message, Throwable cause) {
            super(message, cause);
        }

        public InitializationException(String message) {
            super(message);
        }
    }
}

