/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.security.TypeHierarchyPermission;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class XStreamer {
    private static final TypePermission[] PERMISSIONS = new TypePermission[]{new TypeHierarchyPermission(class$com$thoughtworks$xstream$converters$ConverterMatcher == null ? (class$com$thoughtworks$xstream$converters$ConverterMatcher = XStreamer.class$("com.thoughtworks.xstream.converters.ConverterMatcher")) : class$com$thoughtworks$xstream$converters$ConverterMatcher), new TypeHierarchyPermission(class$com$thoughtworks$xstream$mapper$Mapper == null ? (class$com$thoughtworks$xstream$mapper$Mapper = XStreamer.class$("com.thoughtworks.xstream.mapper.Mapper")) : class$com$thoughtworks$xstream$mapper$Mapper), new TypeHierarchyPermission(class$com$thoughtworks$xstream$XStream == null ? (class$com$thoughtworks$xstream$XStream = XStreamer.class$("com.thoughtworks.xstream.XStream")) : class$com$thoughtworks$xstream$XStream), new TypeHierarchyPermission(class$com$thoughtworks$xstream$converters$reflection$ReflectionProvider == null ? (class$com$thoughtworks$xstream$converters$reflection$ReflectionProvider = XStreamer.class$("com.thoughtworks.xstream.converters.reflection.ReflectionProvider")) : class$com$thoughtworks$xstream$converters$reflection$ReflectionProvider), new TypeHierarchyPermission(class$com$thoughtworks$xstream$converters$javabean$JavaBeanProvider == null ? (class$com$thoughtworks$xstream$converters$javabean$JavaBeanProvider = XStreamer.class$("com.thoughtworks.xstream.converters.javabean.JavaBeanProvider")) : class$com$thoughtworks$xstream$converters$javabean$JavaBeanProvider), new TypeHierarchyPermission(class$com$thoughtworks$xstream$converters$reflection$FieldKeySorter == null ? (class$com$thoughtworks$xstream$converters$reflection$FieldKeySorter = XStreamer.class$("com.thoughtworks.xstream.converters.reflection.FieldKeySorter")) : class$com$thoughtworks$xstream$converters$reflection$FieldKeySorter), new TypeHierarchyPermission(class$com$thoughtworks$xstream$converters$ConverterLookup == null ? (class$com$thoughtworks$xstream$converters$ConverterLookup = XStreamer.class$("com.thoughtworks.xstream.converters.ConverterLookup")) : class$com$thoughtworks$xstream$converters$ConverterLookup), new TypeHierarchyPermission(class$com$thoughtworks$xstream$converters$ConverterRegistry == null ? (class$com$thoughtworks$xstream$converters$ConverterRegistry = XStreamer.class$("com.thoughtworks.xstream.converters.ConverterRegistry")) : class$com$thoughtworks$xstream$converters$ConverterRegistry), new TypeHierarchyPermission(class$com$thoughtworks$xstream$io$HierarchicalStreamDriver == null ? (class$com$thoughtworks$xstream$io$HierarchicalStreamDriver = XStreamer.class$("com.thoughtworks.xstream.io.HierarchicalStreamDriver")) : class$com$thoughtworks$xstream$io$HierarchicalStreamDriver), new TypeHierarchyPermission(class$com$thoughtworks$xstream$MarshallingStrategy == null ? (class$com$thoughtworks$xstream$MarshallingStrategy = XStreamer.class$("com.thoughtworks.xstream.MarshallingStrategy")) : class$com$thoughtworks$xstream$MarshallingStrategy), new TypeHierarchyPermission(class$com$thoughtworks$xstream$converters$MarshallingContext == null ? (class$com$thoughtworks$xstream$converters$MarshallingContext = XStreamer.class$("com.thoughtworks.xstream.converters.MarshallingContext")) : class$com$thoughtworks$xstream$converters$MarshallingContext), new TypeHierarchyPermission(class$com$thoughtworks$xstream$converters$UnmarshallingContext == null ? (class$com$thoughtworks$xstream$converters$UnmarshallingContext = XStreamer.class$("com.thoughtworks.xstream.converters.UnmarshallingContext")) : class$com$thoughtworks$xstream$converters$UnmarshallingContext), new TypeHierarchyPermission(class$com$thoughtworks$xstream$io$naming$NameCoder == null ? (class$com$thoughtworks$xstream$io$naming$NameCoder = XStreamer.class$("com.thoughtworks.xstream.io.naming.NameCoder")) : class$com$thoughtworks$xstream$io$naming$NameCoder), new TypeHierarchyPermission(class$com$thoughtworks$xstream$security$TypePermission == null ? (class$com$thoughtworks$xstream$security$TypePermission = XStreamer.class$("com.thoughtworks.xstream.security.TypePermission")) : class$com$thoughtworks$xstream$security$TypePermission), new WildcardTypePermission(new String[]{(class$com$thoughtworks$xstream$core$JVM == null ? (class$com$thoughtworks$xstream$core$JVM = XStreamer.class$("com.thoughtworks.xstream.core.JVM")) : class$com$thoughtworks$xstream$core$JVM).getPackage().getName() + ".**"}), new TypeHierarchyPermission(class$javax$xml$datatype$DatatypeFactory == null ? (class$javax$xml$datatype$DatatypeFactory = XStreamer.class$("javax.xml.datatype.DatatypeFactory")) : class$javax$xml$datatype$DatatypeFactory)};
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$ConverterMatcher;
    static /* synthetic */ Class class$com$thoughtworks$xstream$mapper$Mapper;
    static /* synthetic */ Class class$com$thoughtworks$xstream$XStream;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$reflection$ReflectionProvider;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$javabean$JavaBeanProvider;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$reflection$FieldKeySorter;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$ConverterLookup;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$ConverterRegistry;
    static /* synthetic */ Class class$com$thoughtworks$xstream$io$HierarchicalStreamDriver;
    static /* synthetic */ Class class$com$thoughtworks$xstream$MarshallingStrategy;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$MarshallingContext;
    static /* synthetic */ Class class$com$thoughtworks$xstream$converters$UnmarshallingContext;
    static /* synthetic */ Class class$com$thoughtworks$xstream$io$naming$NameCoder;
    static /* synthetic */ Class class$com$thoughtworks$xstream$security$TypePermission;
    static /* synthetic */ Class class$com$thoughtworks$xstream$core$JVM;
    static /* synthetic */ Class class$javax$xml$datatype$DatatypeFactory;

    public String toXML(XStream xstream, Object obj) throws ObjectStreamException {
        StringWriter writer = new StringWriter();
        try {
            this.toXML(xstream, obj, writer);
        }
        catch (ObjectStreamException e) {
            throw e;
        }
        catch (IOException e) {
            throw new StreamException("Unexpected IO error from a StringWriter", e);
        }
        return ((Object)writer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toXML(XStream xstream, Object obj, Writer out) throws IOException {
        XStream outer = new XStream();
        XStream.setupDefaultSecurity(outer);
        ObjectOutputStream oos = outer.createObjectOutputStream(out);
        try {
            oos.writeObject(xstream);
            oos.flush();
            xstream.toXML(obj, out);
        }
        finally {
            oos.close();
        }
    }

    public Object fromXML(String xml) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(new StringReader(xml));
        }
        catch (ObjectStreamException e) {
            throw e;
        }
        catch (IOException e) {
            throw new StreamException("Unexpected IO error from a StringReader", e);
        }
    }

    public Object fromXML(String xml, TypePermission[] permissions) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(new StringReader(xml), permissions);
        }
        catch (ObjectStreamException e) {
            throw e;
        }
        catch (IOException e) {
            throw new StreamException("Unexpected IO error from a StringReader", e);
        }
    }

    public Object fromXML(HierarchicalStreamDriver driver, String xml) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(driver, new StringReader(xml));
        }
        catch (ObjectStreamException e) {
            throw e;
        }
        catch (IOException e) {
            throw new StreamException("Unexpected IO error from a StringReader", e);
        }
    }

    public Object fromXML(HierarchicalStreamDriver driver, String xml, TypePermission[] permissions) throws ClassNotFoundException, ObjectStreamException {
        try {
            return this.fromXML(driver, new StringReader(xml), permissions);
        }
        catch (ObjectStreamException e) {
            throw e;
        }
        catch (IOException e) {
            throw new StreamException("Unexpected IO error from a StringReader", e);
        }
    }

    public Object fromXML(Reader xml) throws IOException, ClassNotFoundException {
        return this.fromXML((HierarchicalStreamDriver)new XppDriver(), xml);
    }

    public Object fromXML(Reader xml, TypePermission[] permissions) throws IOException, ClassNotFoundException {
        return this.fromXML((HierarchicalStreamDriver)new XppDriver(), xml, permissions);
    }

    public Object fromXML(HierarchicalStreamDriver driver, Reader xml) throws IOException, ClassNotFoundException {
        return this.fromXML(driver, xml, PERMISSIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fromXML(HierarchicalStreamDriver driver, Reader xml, TypePermission[] permissions) throws IOException, ClassNotFoundException {
        XStream outer = new XStream(driver);
        XStream.setupDefaultSecurity(outer);
        for (int i = 0; i < permissions.length; ++i) {
            outer.addPermission(permissions[i]);
        }
        HierarchicalStreamReader reader = driver.createReader(xml);
        ObjectInputStream configIn = outer.createObjectInputStream(reader);
        try {
            Object object;
            XStream configured = (XStream)configIn.readObject();
            ObjectInputStream in = configured.createObjectInputStream(reader);
            try {
                object = in.readObject();
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return object;
        }
        finally {
            configIn.close();
        }
    }

    public static TypePermission[] getDefaultPermissions() {
        return (TypePermission[])PERMISSIONS.clone();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

