/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.collections;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Collection;
import java.util.Iterator;

public class CollectionConverter
extends AbstractCollectionConverter {
    private final Class type;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$LinkedHashSet;

    public CollectionConverter(Mapper mapper) {
        this(mapper, null);
    }

    public CollectionConverter(Mapper mapper, Class type) {
        super(mapper);
        this.type = type;
        if (type != null && !(class$java$util$Collection == null ? (class$java$util$Collection = CollectionConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(type)) {
            throw new IllegalArgumentException(type + " not of type " + (class$java$util$Collection == null ? (class$java$util$Collection = CollectionConverter.class$("java.util.Collection")) : class$java$util$Collection));
        }
    }

    public boolean canConvert(Class type) {
        if (this.type != null) {
            return type.equals(this.type);
        }
        return type.equals(class$java$util$ArrayList == null ? (class$java$util$ArrayList = CollectionConverter.class$("java.util.ArrayList")) : class$java$util$ArrayList) || type.equals(class$java$util$HashSet == null ? (class$java$util$HashSet = CollectionConverter.class$("java.util.HashSet")) : class$java$util$HashSet) || type.equals(class$java$util$LinkedList == null ? (class$java$util$LinkedList = CollectionConverter.class$("java.util.LinkedList")) : class$java$util$LinkedList) || type.equals(class$java$util$Vector == null ? (class$java$util$Vector = CollectionConverter.class$("java.util.Vector")) : class$java$util$Vector) || type.equals(class$java$util$LinkedHashSet == null ? (class$java$util$LinkedHashSet = CollectionConverter.class$("java.util.LinkedHashSet")) : class$java$util$LinkedHashSet);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Collection collection = (Collection)source;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            this.writeCompleteItem(item, context, writer);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Collection collection = (Collection)this.createCollection(context.getRequiredType());
        this.populateCollection(reader, context, collection);
        return collection;
    }

    protected void populateCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection) {
        this.populateCollection(reader, context, collection, collection);
    }

    protected void populateCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection, Collection target) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            this.addCurrentElementToCollection(reader, context, collection, target);
            reader.moveUp();
        }
    }

    protected void addCurrentElementToCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Collection collection, Collection target) {
        Object item = this.readItem(reader, context, collection);
        target.add(item);
    }

    protected Object createCollection(Class type) {
        return super.createCollection(this.type != null ? this.type : type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

