/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.util.Fields;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AbstractAttributedCharacterIteratorAttributeConverter
extends AbstractSingleValueConverter {
    private static final Map instanceMaps;
    private static final Method getName;
    private final Class type;
    private transient Map attributeMap;
    static /* synthetic */ Class class$java$text$AttributedCharacterIterator$Attribute;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$String;

    public AbstractAttributedCharacterIteratorAttributeConverter(Class type) {
        if (!(class$java$text$AttributedCharacterIterator$Attribute == null ? (class$java$text$AttributedCharacterIterator$Attribute = AbstractAttributedCharacterIteratorAttributeConverter.class$("java.text.AttributedCharacterIterator$Attribute")) : class$java$text$AttributedCharacterIterator$Attribute).isAssignableFrom(type)) {
            throw new IllegalArgumentException(type.getName() + " is not a " + (class$java$text$AttributedCharacterIterator$Attribute == null ? (class$java$text$AttributedCharacterIterator$Attribute = AbstractAttributedCharacterIteratorAttributeConverter.class$("java.text.AttributedCharacterIterator$Attribute")) : class$java$text$AttributedCharacterIterator$Attribute).getName());
        }
        this.type = type;
        this.readResolve();
    }

    public boolean canConvert(Class type) {
        return type == this.type && !this.attributeMap.isEmpty();
    }

    public String toString(Object source) {
        return this.getName((AttributedCharacterIterator.Attribute)source);
    }

    private String getName(AttributedCharacterIterator.Attribute attribute) {
        String className;
        String s;
        Exception ex = null;
        if (getName != null) {
            try {
                return (String)getName.invoke((Object)attribute, (Object[])null);
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (InvocationTargetException e) {
                ex = e;
            }
            catch (RuntimeException e) {
                if (!"java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) {
                    throw e;
                }
                ex = e;
            }
        }
        if ((s = attribute.toString()).startsWith(className = attribute.getClass().getName())) {
            return s.substring(className.length() + 1, s.length() - 1);
        }
        ConversionException exception = new ConversionException("Cannot find name of attribute", ex);
        exception.add("attribute-type", className);
        throw exception;
    }

    public Object fromString(String str) {
        if (this.attributeMap.containsKey(str)) {
            return this.attributeMap.get(str);
        }
        ConversionException exception = new ConversionException("Cannot find attribute");
        exception.add("attribute-type", this.type.getName());
        exception.add("attribute-name", str);
        throw exception;
    }

    private Object readResolve() {
        this.attributeMap = (Map)instanceMaps.get(this.type.getName());
        if (this.attributeMap == null) {
            this.attributeMap = new HashMap();
            Field instanceMap = Fields.locate(this.type, class$java$util$Map == null ? (class$java$util$Map = AbstractAttributedCharacterIteratorAttributeConverter.class$("java.util.Map")) : class$java$util$Map, true);
            if (instanceMap != null) {
                try {
                    Map map = (Map)Fields.read(instanceMap, null);
                    if (map != null) {
                        boolean valid = true;
                        Iterator iter = map.entrySet().iterator();
                        while (valid && iter.hasNext()) {
                            Map.Entry entry = iter.next();
                            valid = entry.getKey().getClass() == (class$java$lang$String == null ? AbstractAttributedCharacterIteratorAttributeConverter.class$("java.lang.String") : class$java$lang$String) && entry.getValue().getClass() == this.type;
                        }
                        if (valid) {
                            this.attributeMap.putAll(map);
                        }
                    }
                }
                catch (ObjectAccessException e) {
                    // empty catch block
                }
            }
            if (this.attributeMap.isEmpty()) {
                try {
                    Field[] fields = this.type.getDeclaredFields();
                    for (int i = 0; i < fields.length; ++i) {
                        if (fields[i].getType() == this.type != Modifier.isStatic(fields[i].getModifiers())) continue;
                        AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)Fields.read(fields[i], null);
                        this.attributeMap.put(this.toString(attribute), attribute);
                    }
                }
                catch (SecurityException e) {
                    this.attributeMap.clear();
                }
                catch (ObjectAccessException e) {
                    this.attributeMap.clear();
                }
                catch (NoClassDefFoundError e) {
                    this.attributeMap.clear();
                }
                catch (RuntimeException e) {
                    if (!"java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) {
                        throw e;
                    }
                    this.attributeMap.clear();
                }
            }
            instanceMaps.put(this.type.getName(), this.attributeMap);
        }
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method method;
        block5: {
            instanceMaps = new HashMap();
            method = null;
            try {
                method = (class$java$text$AttributedCharacterIterator$Attribute == null ? (class$java$text$AttributedCharacterIterator$Attribute = AbstractAttributedCharacterIteratorAttributeConverter.class$("java.text.AttributedCharacterIterator$Attribute")) : class$java$text$AttributedCharacterIterator$Attribute).getDeclaredMethod("getName", null);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (RuntimeException e) {
                if ("java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) break block5;
                throw e;
            }
        }
        getName = method;
    }
}

