/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWritingException;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class SunLimitedUnsafeReflectionProvider
extends PureJavaReflectionProvider {
    protected static final Unsafe unsafe;
    protected static final Exception exception;
    static /* synthetic */ Class class$sun$misc$Unsafe;
    static /* synthetic */ Class class$java$lang$Void;

    public SunLimitedUnsafeReflectionProvider() {
    }

    public SunLimitedUnsafeReflectionProvider(FieldDictionary fieldDictionary) {
        super(fieldDictionary);
    }

    public Object newInstance(Class type) {
        if (exception != null) {
            ObjectAccessException ex = new ObjectAccessException("Cannot construct type", exception);
            ex.add("construction-type", type.getName());
            throw ex;
        }
        ErrorWritingException ex = null;
        if (type == Void.TYPE || type == (class$java$lang$Void == null ? (class$java$lang$Void = SunLimitedUnsafeReflectionProvider.class$("java.lang.Void")) : class$java$lang$Void)) {
            ex = new ConversionException("Type void cannot have an instance");
        } else {
            try {
                return unsafe.allocateInstance(type);
            }
            catch (SecurityException e) {
                ex = new ObjectAccessException("Cannot construct type", e);
            }
            catch (InstantiationException e) {
                ex = new ConversionException("Cannot construct type", e);
            }
            catch (IllegalArgumentException e) {
                ex = new ObjectAccessException("Cannot construct type", e);
            }
        }
        ex.add("construction-type", type.getName());
        throw ex;
    }

    protected void validateFieldAccess(Field field) {
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Unsafe u = null;
        Exception ex = null;
        try {
            Field unsafeField = (class$sun$misc$Unsafe == null ? (class$sun$misc$Unsafe = SunLimitedUnsafeReflectionProvider.class$("sun.misc.Unsafe")) : class$sun$misc$Unsafe).getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            u = (Unsafe)unsafeField.get(null);
        }
        catch (SecurityException e) {
            ex = e;
        }
        catch (NoSuchFieldException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (RuntimeException e) {
            if (!"java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) {
                throw e;
            }
            ex = e;
        }
        exception = ex;
        unsafe = u;
    }
}

