/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.core.util.FastField;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ElementIgnoringMapper
extends MapperWrapper {
    protected final Set fieldsToOmit = new HashSet();
    protected final Set unknownElementsToIgnore = new LinkedHashSet();
    static /* synthetic */ Class class$java$lang$Object;

    public ElementIgnoringMapper(Mapper wrapped) {
        super(wrapped);
    }

    public void addElementsToIgnore(Pattern pattern) {
        this.unknownElementsToIgnore.add(pattern);
    }

    public void omitField(Class definedIn, String fieldName) {
        this.fieldsToOmit.add(this.key(definedIn, fieldName));
    }

    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        if (this.fieldsToOmit.contains(this.key(definedIn, fieldName))) {
            return false;
        }
        if (definedIn == (class$java$lang$Object == null ? (class$java$lang$Object = ElementIgnoringMapper.class$("java.lang.Object")) : class$java$lang$Object) && this.isIgnoredElement(fieldName)) {
            return false;
        }
        return super.shouldSerializeMember(definedIn, fieldName);
    }

    public boolean isIgnoredElement(String name) {
        if (!this.unknownElementsToIgnore.isEmpty()) {
            Iterator iter = this.unknownElementsToIgnore.iterator();
            while (iter.hasNext()) {
                Pattern pattern = (Pattern)iter.next();
                if (!pattern.matcher(name).matches()) continue;
                return true;
            }
        }
        return super.isIgnoredElement(name);
    }

    private Object key(Class type, String name) {
        return new FastField(type, name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

