/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrains.buildServer.ExtensionAccessor;
import jetbrains.buildServer.TeamCityExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultExtensionAccessor
implements ExtensionAccessor {
    private final ConcurrentMap<Class, Map<String, ?>> myExtensionPoints = new ConcurrentHashMap();

    @Override
    public synchronized <T extends TeamCityExtension> void registerExtension(@NotNull Class<T> extensionClass, @NonNls @NotNull String sourceId, @NotNull T extension) {
        if (extensionClass == null) {
            DefaultExtensionAccessor.$$$reportNull$$$0(0);
        }
        if (sourceId == null) {
            DefaultExtensionAccessor.$$$reportNull$$$0(1);
        }
        if (extension == null) {
            DefaultExtensionAccessor.$$$reportNull$$$0(2);
        }
        Map<String, T> map = this.getExtensionsByClass(extensionClass);
        HashMap<String, T> newExtensionsMap = new HashMap<String, T>();
        if (map != null) {
            newExtensionsMap.putAll(map);
        }
        if (newExtensionsMap.containsKey(sourceId)) {
            throw new IllegalStateException("Already has extension for class \n" + extensionClass.getName() + " and key " + sourceId + ": \n" + newExtensionsMap.get(sourceId));
        }
        newExtensionsMap.put(sourceId, extension);
        this.storeExtensions(extensionClass, newExtensionsMap);
    }

    @Override
    public synchronized <T extends TeamCityExtension> void unregisterExtension(@NotNull Class<T> extensionClass, @NonNls @NotNull String sourceId) {
        if (extensionClass == null) {
            DefaultExtensionAccessor.$$$reportNull$$$0(3);
        }
        if (sourceId == null) {
            DefaultExtensionAccessor.$$$reportNull$$$0(4);
        }
        Map<String, T> map = this.getExtensionsByClass(extensionClass);
        HashMap<String, T> newExtensionsMap = new HashMap<String, T>();
        if (map != null) {
            newExtensionsMap.putAll(map);
        }
        newExtensionsMap.remove(sourceId);
        this.storeExtensions(extensionClass, newExtensionsMap);
    }

    private <T extends TeamCityExtension> void storeExtensions(@NotNull Class<T> extensionClass, @NotNull Map<String, T> newExtensionsMap) {
        if (extensionClass == null) {
            DefaultExtensionAccessor.$$$reportNull$$$0(5);
        }
        if (newExtensionsMap == null) {
            DefaultExtensionAccessor.$$$reportNull$$$0(6);
        }
        if (newExtensionsMap.isEmpty()) {
            this.myExtensionPoints.remove(extensionClass);
        } else {
            this.myExtensionPoints.put(extensionClass, Collections.unmodifiableMap(newExtensionsMap));
        }
    }

    @Override
    @NotNull
    public <T> Map<String, T> getRegisteredExtensions(@NotNull Class<T> extensionClass) {
        Map<String, T> extensions;
        if (extensionClass == null) {
            DefaultExtensionAccessor.$$$reportNull$$$0(7);
        }
        if ((extensions = this.getExtensionsByClass(extensionClass)) == null) {
            Map map = Collections.emptyMap();
            if (map == null) {
                DefaultExtensionAccessor.$$$reportNull$$$0(8);
            }
            return map;
        }
        Map<String, T> map = extensions;
        if (map == null) {
            DefaultExtensionAccessor.$$$reportNull$$$0(9);
        }
        return map;
    }

    @Nullable
    private <T> Map<String, T> getExtensionsByClass(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            DefaultExtensionAccessor.$$$reportNull$$$0(10);
        }
        return (Map)this.myExtensionPoints.get(extensionClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExtensionsMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/DefaultExtensionAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/DefaultExtensionAccessor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "storeExtensions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRegisteredExtensions";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionsByClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

