/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.SpringAccessor;
import jetbrains.buildServer.SpringBeansFilter;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;

public class DefaultSpringAccessor
implements SpringAccessor {
    @NotNull
    private final ListableBeanFactory myBeanFactory;
    private final ConfigurableListableBeanFactory myConfigurableBeanFactory;
    private final SpringBeansFilter myFilter;
    private final AtomicBoolean myContextClosed;
    protected static final SpringBeansFilter ACCEPT_ALL = new SpringBeansFilter(){

        @Override
        public <T> boolean accept(@NotNull Class<T> extensionClass, @NotNull T bean) {
            if (extensionClass == null) {
                2.$$$reportNull$$$0(0);
            }
            if (bean == null) {
                2.$$$reportNull$$$0(1);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extensionClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bean";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/DefaultSpringAccessor$2";
            objectArray[2] = "accept";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public DefaultSpringAccessor(@NotNull ApplicationContext context) {
        if (context == null) {
            DefaultSpringAccessor.$$$reportNull$$$0(0);
        }
        this(context, ACCEPT_ALL);
    }

    public DefaultSpringAccessor(final @NotNull ApplicationContext context, @NotNull SpringBeansFilter filter) {
        ConfigurableListableBeanFactory t;
        if (context == null) {
            DefaultSpringAccessor.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            DefaultSpringAccessor.$$$reportNull$$$0(2);
        }
        this.myContextClosed = new AtomicBoolean(false);
        this.myFilter = filter;
        if (context instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext cac = (ConfigurableApplicationContext)context;
            cac.addApplicationListener((ApplicationListener)new ApplicationListener<ContextClosedEvent>(){

                public void onApplicationEvent(ContextClosedEvent event) {
                    if (event.getApplicationContext().equals(context)) {
                        DefaultSpringAccessor.this.myContextClosed.set(true);
                    }
                }
            });
            t = cac.getBeanFactory();
        } else {
            t = null;
        }
        this.myBeanFactory = t == null ? context : t;
        this.myConfigurableBeanFactory = t;
    }

    @Override
    @NotNull
    public <T> Collection<T> getSpringBeansOfType(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            DefaultSpringAccessor.$$$reportNull$$$0(3);
        }
        if (this.myContextClosed.get() && !TeamCityProperties.getBooleanOrTrue((String)"teamcity.server.searchBeansInClosedContexts")) {
            List list = Collections.emptyList();
            if (list == null) {
                DefaultSpringAccessor.$$$reportNull$$$0(4);
            }
            return list;
        }
        String[] serviceNames = this.getBeanNames(extensionClass);
        ArrayList<Object> result = new ArrayList<Object>(serviceNames.length);
        for (String name : serviceNames) {
            if (serviceNames.length > 1 && this.myConfigurableBeanFactory != null) {
                try {
                    BeanDefinition bd = this.myConfigurableBeanFactory.getBeanDefinition(name);
                    if (bd instanceof AbstractBeanDefinition && !bd.isAutowireCandidate()) {
                        continue;
                    }
                }
                catch (NoSuchBeanDefinitionException bd) {
                    // empty catch block
                }
            }
            try {
                Object bean = this.myBeanFactory.getBean(name, extensionClass);
                if (!this.myFilter.accept(extensionClass, bean)) continue;
                result.add(bean);
            }
            catch (BeanCreationNotAllowedException e) {
                List list = Collections.emptyList();
                if (list == null) {
                    DefaultSpringAccessor.$$$reportNull$$$0(5);
                }
                return list;
            }
        }
        List<Object> list = result.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(result);
        if (list == null) {
            DefaultSpringAccessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    protected <T> String[] getBeanNames(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            DefaultSpringAccessor.$$$reportNull$$$0(7);
        }
        String[] stringArray = this.myBeanFactory.getBeanNamesForType(extensionClass);
        if (stringArray == null) {
            DefaultSpringAccessor.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/DefaultSpringAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/DefaultSpringAccessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringBeansOfType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpringBeansOfType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBeanNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

