/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.function.Function;
import jetbrains.buildServer.ExtensionAccessor;
import jetbrains.buildServer.ExtensionHolder;
import jetbrains.buildServer.ExtensionsCollection;
import jetbrains.buildServer.ExtensionsProvider;
import jetbrains.buildServer.PluginAwareSpringAccessor;
import jetbrains.buildServer.ServiceLocatorImpl;
import jetbrains.buildServer.SpringAccessor;
import jetbrains.buildServer.StampedExtensionsSupplier;
import jetbrains.buildServer.TeamCityExtension;
import jetbrains.buildServer.util.positioning.PositionAware;
import jetbrains.buildServer.util.positioning.PositionAwareCollection;
import jetbrains.buildServer.util.positioning.PositionConstraint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtendableServiceLocator
extends ServiceLocatorImpl
implements ExtensionHolder {
    private static final Logger LOG = Logger.getInstance((String)ExtendableServiceLocator.class.getName());
    private ExtensionAccessor myAccessor;
    private final AtomicInteger myRegisterEvents = new AtomicInteger();

    @Autowired
    public void setAccessor(@NotNull ExtensionAccessor accessor) {
        if (accessor == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(0);
        }
        this.myAccessor = accessor;
    }

    public ExtensionAccessor getAccessor() {
        return this.myAccessor;
    }

    @Override
    @Autowired
    public void setSpringAccessor(@NotNull SpringAccessor springAccessor) {
        if (springAccessor == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(1);
        }
        if (springAccessor instanceof PluginAwareSpringAccessor) {
            ((PluginAwareSpringAccessor)springAccessor).addOnClearCacheAction(this.myRegisterEvents::incrementAndGet);
        }
        super.setSpringAccessor(springAccessor);
    }

    public <T extends TeamCityExtension> void registerExtension(@NotNull Class<T> extensionClass, @NotNull String sourceId, @NotNull T extension) {
        if (extensionClass == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(2);
        }
        if (sourceId == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(3);
        }
        if (extension == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(4);
        }
        this.checkAccessorSet();
        this.myAccessor.registerExtension(extensionClass, sourceId, extension);
        this.myRegisterEvents.incrementAndGet();
    }

    private void checkAccessorSet() {
        if (this.myAccessor == null) {
            throw new RuntimeException("setAccessor method should be called before");
        }
    }

    public <T extends TeamCityExtension> void unregisterExtension(@NotNull Class<T> extensionClass, @NotNull String sourceId) {
        if (extensionClass == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(5);
        }
        if (sourceId == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(6);
        }
        this.checkAccessorSet();
        this.myAccessor.unregisterExtension(extensionClass, sourceId);
        this.myRegisterEvents.incrementAndGet();
    }

    @NotNull
    private <T extends TeamCityExtension> Collection<T> getExtensionsUnsorted(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(7);
        }
        this.checkAccessorSet();
        Collection<T> registered = this.myAccessor.getRegisteredExtensions(extensionClass).values();
        Collection<T> springBeans = this.getSpringBeansOfType(extensionClass);
        if (registered.isEmpty() && springBeans.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                ExtendableServiceLocator.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (registered.isEmpty() && springBeans.size() == 1) {
            Collection<T> collection = springBeans;
            if (collection == null) {
                ExtendableServiceLocator.$$$reportNull$$$0(9);
            }
            return collection;
        }
        HashSet<T> result = new HashSet<T>(registered.size() + springBeans.size());
        result.addAll(registered);
        result.addAll(springBeans);
        HashSet<T> hashSet = result;
        if (hashSet == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    public <T extends TeamCityExtension> Collection<T> getExtensions(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(11);
        }
        Collection<T> unorderedExtensions = this.getExtensionsUnsorted(extensionClass);
        Collection<T> collection = this.sortOrderAware(unorderedExtensions, PositionConstraint.UNDEFINED);
        if (collection == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    public <T extends TeamCityExtension> ExtensionsCollection<T> getExtensionsCollection(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(13);
        }
        ExtensionsCollection extensionsCollection = () -> (Collection)this.getStampedExtensionsSupplier(extensionClass, storedData -> (Collection)storedData.data).get(null);
        if (extensionsCollection == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(14);
        }
        return extensionsCollection;
    }

    @NotNull
    public <T extends TeamCityExtension, CONTEXT, TARGET> StampedExtensionsSupplier<CONTEXT, TARGET> getStampedExtensionsSupplier(final @NotNull Class<T> extensionClass, final @NotNull Function<StampedExtensionsSupplier.StoredData<CONTEXT, Collection<T>>, TARGET> converter) {
        if (extensionClass == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(15);
        }
        if (converter == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(16);
        }
        StampedExtensionsSupplier stampedExtensionsSupplier = new StampedExtensionsSupplier<CONTEXT, TARGET>(){
            private final AtomicStampedReference<Pair<CONTEXT, TARGET>> myRef = new AtomicStampedReference<Object>(null, 0);

            public TARGET get(@Nullable CONTEXT additionalData) {
                int currentStamp;
                int stamp;
                Collection extensions;
                Pair res;
                Pair ref;
                do {
                    stamp = this.myRef.getStamp();
                    ref = this.myRef.getReference();
                    currentStamp = ExtendableServiceLocator.this.myRegisterEvents.get();
                    if (stamp != currentStamp || ref == null || !Objects.equals(ref.first, additionalData)) continue;
                    return ref.second;
                } while (this.myRef.compareAndSet(ref, res = Pair.create(additionalData, converter.apply(new StampedExtensionsSupplier.StoredData(additionalData, extensions = ExtendableServiceLocator.this.getExtensions(extensionClass)))), stamp, currentStamp));
                return res.second;
            }
        };
        if (stampedExtensionsSupplier == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(17);
        }
        return stampedExtensionsSupplier;
    }

    private <T extends TeamCityExtension> Collection<T> sortOrderAware(@NotNull Collection<T> unorderedExtensions, @NotNull PositionConstraint defaultPositionConstraint) {
        if (unorderedExtensions == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(18);
        }
        if (defaultPositionConstraint == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(19);
        }
        if (unorderedExtensions.size() <= 1) {
            return unorderedExtensions;
        }
        if (!this.requiresSorting(unorderedExtensions)) {
            return unorderedExtensions;
        }
        PositionAwareCollection orderedExtensions = new PositionAwareCollection();
        for (TeamCityExtension extension : unorderedExtensions) {
            if (extension instanceof PositionAware) {
                orderedExtensions.add((Object)extension, (PositionAware)extension);
                continue;
            }
            orderedExtensions.add((Object)extension, extension.getClass().getName(), defaultPositionConstraint);
        }
        return orderedExtensions.getAllSorted();
    }

    private <T extends TeamCityExtension> boolean requiresSorting(Collection<T> unorderedExtensions) {
        for (TeamCityExtension ext : unorderedExtensions) {
            if (!(ext instanceof PositionAware)) continue;
            return true;
        }
        return false;
    }

    public <T extends TeamCityExtension> void foreachExtension(@NotNull Class<T> agentExtensionClass, @NotNull ExtensionsProvider.ExtensionAction<T> action) {
        if (agentExtensionClass == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(20);
        }
        if (action == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(21);
        }
        for (TeamCityExtension extension : this.getExtensions(agentExtensionClass)) {
            try {
                action.action(extension);
            }
            catch (Throwable e) {
                LOG.error("An exception was thrown from the extension: " + extension.getClass().getName(), e);
            }
        }
    }

    @NotNull
    public <T extends TeamCityExtension> Collection<String> getExtensionSources(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(22);
        }
        this.checkAccessorSet();
        Collection<String> collection = Collections.unmodifiableCollection(this.myAccessor.getRegisteredExtensions(extensionClass).keySet());
        if (collection == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @Nullable
    public <T extends TeamCityExtension> T getExtension(@NotNull Class<T> extensionClass, @NotNull String sourceId) {
        if (extensionClass == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(24);
        }
        if (sourceId == null) {
            ExtendableServiceLocator.$$$reportNull$$$0(25);
        }
        this.checkAccessorSet();
        return (T)((TeamCityExtension)this.myAccessor.getRegisteredExtensions(extensionClass).get(sourceId));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springAccessor";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 11: 
            case 13: 
            case 15: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 3: 
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/ExtendableServiceLocator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unorderedExtensions";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPositionConstraint";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentExtensionClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/ExtendableServiceLocator";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionsUnsorted";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionsCollection";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStampedExtensionsSupplier";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setAccessor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSpringAccessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionsUnsorted";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 23: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionsCollection";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStampedExtensionsSupplier";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "sortOrderAware";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "foreachExtension";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionSources";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

