/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer;

import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jetbrains.buildServer.DefaultSpringAccessor;
import jetbrains.buildServer.SpringAccessor;
import jetbrains.buildServer.SpringBeansFilter;
import jetbrains.buildServer.TypeToCollectionMap;
import jetbrains.buildServer.Used;
import jetbrains.buildServer.plugins.PluginManager;
import jetbrains.buildServer.plugins.PluginManagerListenerAdapter;
import jetbrains.buildServer.plugins.bean.PluginInfo;
import jetbrains.buildServer.plugins.spring.PluginSpringContextListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;

public class PluginAwareSpringAccessor
implements SpringAccessor,
ApplicationContextAware,
PluginSpringContextListener {
    private final Map<String, List<SpringAccessor>> myPluginFactories = new ConcurrentHashMap<String, List<SpringAccessor>>();
    private final TypeToCollectionMap myCache;
    private final List<Runnable> myOnClearCacheActions = new CopyOnWriteArrayList<Runnable>();
    @Autowired(required=false)
    @Nullable
    private SpringBeansFilter myFilter;

    public PluginAwareSpringAccessor(PluginManager manager) {
        this();
        manager.getPluginLifecycleEventDispatcher().addListener((EventListener)new PluginManagerListenerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pluginResourcesCleaned(@NotNull PluginInfo pluginInfo) {
                if (pluginInfo == null) {
                    1.$$$reportNull$$$0(0);
                }
                PluginAwareSpringAccessor pluginAwareSpringAccessor = PluginAwareSpringAccessor.this;
                synchronized (pluginAwareSpringAccessor) {
                    PluginAwareSpringAccessor.this.myPluginFactories.remove(pluginInfo.getPluginName());
                    PluginAwareSpringAccessor.this.invalidateCache();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginInfo", "jetbrains/buildServer/PluginAwareSpringAccessor$1", "pluginResourcesCleaned"));
            }
        });
    }

    public PluginAwareSpringAccessor() {
        this.myCache = new TypeToCollectionMap(){

            @Override
            protected <T> Collection<T> compute(Class<T> clazz) {
                return Collections.unmodifiableCollection(PluginAwareSpringAccessor.this.computeSpringBeansOfType(clazz));
            }
        };
    }

    private void registerBeanFactory(@NotNull ApplicationContext applicationContext, @Nullable PluginInfo plugin) {
        if (applicationContext == null) {
            PluginAwareSpringAccessor.$$$reportNull$$$0(0);
        }
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)applicationContext).addApplicationListener((ApplicationListener)new ApplicationListener<ContextClosedEvent>(){

                public void onApplicationEvent(ContextClosedEvent event) {
                    PluginAwareSpringAccessor.this.invalidateCache();
                }
            });
        }
        SpringAccessor bean = null;
        if (plugin != null) {
            try {
                String[] beanNames = applicationContext.getBeanNamesForType(SpringAccessor.class);
                if (beanNames.length == 1 && (bean = (SpringAccessor)applicationContext.getBean(beanNames[0])) == this) {
                    bean = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (bean == null) {
            bean = this.myFilter != null ? new DefaultSpringAccessor(applicationContext, this.myFilter) : new DefaultSpringAccessor(applicationContext);
        }
        this.registerBeanFactory(bean, plugin);
    }

    public synchronized void registerBeanFactory(@NotNull SpringAccessor accessor) {
        if (accessor == null) {
            PluginAwareSpringAccessor.$$$reportNull$$$0(1);
        }
        this.registerBeanFactory(accessor, null);
    }

    public synchronized void registerBeanFactory(@NotNull SpringAccessor accessor, @Nullable PluginInfo pluginInfo) {
        String name;
        List<SpringAccessor> springAccessors;
        if (accessor == null) {
            PluginAwareSpringAccessor.$$$reportNull$$$0(2);
        }
        if ((springAccessors = this.myPluginFactories.get(name = pluginInfo != null ? pluginInfo.getPluginName() : "TeamCity-main")) == null) {
            springAccessors = new CopyOnWriteArrayList<SpringAccessor>();
        }
        springAccessors.add(accessor);
        this.myPluginFactories.put(name, springAccessors);
        this.invalidateCache();
    }

    @Used(value="tests")
    void invalidateCache() {
        this.myCache.clear();
        for (Runnable onClearCacheAction : this.myOnClearCacheActions) {
            onClearCacheAction.run();
        }
    }

    @Override
    @NotNull
    public <T> Collection<T> getSpringBeansOfType(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            PluginAwareSpringAccessor.$$$reportNull$$$0(3);
        }
        Collection<T> collection = this.myCache.get(extensionClass);
        if (collection == null) {
            PluginAwareSpringAccessor.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private <T> Collection<T> computeSpringBeansOfType(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            PluginAwareSpringAccessor.$$$reportNull$$$0(5);
        }
        HashSet<T> components = new HashSet<T>();
        for (List<SpringAccessor> springAccessors : this.myPluginFactories.values()) {
            for (SpringAccessor springAccessor : springAccessors) {
                components.addAll(springAccessor.getSpringBeansOfType(extensionClass));
            }
        }
        return components;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.registerBeanFactory(applicationContext, null);
    }

    @Override
    public void contextCreated(ApplicationContext applicationContext, PluginInfo plugin) {
    }

    @Override
    public void contextLoaded(ApplicationContext applicationContext, PluginInfo plugin) {
        this.registerBeanFactory(applicationContext, plugin);
    }

    @Override
    public void contextFailedToLoad(ApplicationContext applicationContext, PluginInfo plugin, Throwable loadException) {
    }

    public void addOnClearCacheAction(Runnable runnable) {
        this.myOnClearCacheActions.add(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/PluginAwareSpringAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/PluginAwareSpringAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringBeansOfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerBeanFactory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpringBeansOfType";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeSpringBeansOfType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

