/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentServerProtocols {
    public static final Set<String> AVAILABLE_PROTOCOLS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("xml-rpc", "polling")));
    public static final String XML_RPC_ID = "xml-rpc";
    public static final String POLLING_ID = "polling";
    public static final String INTERNAL_PROPERTY_NAME = "teamcity.agent.communicationProtocols";
    private static final String DEFAULT_PROTOCOLS_PROPERTY_VALUE = "polling";

    @NotNull
    public static List<String> getServerSupportedProtocols() {
        List<String> list = AgentServerProtocols.parseProtocols(AgentServerProtocols.getSupportedProtocolsString());
        if (list == null) {
            AgentServerProtocols.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<String> parseProtocols(String internalProperty) {
        List<String> supportedProtocols = AgentServerProtocols.parseInternalProperty(internalProperty);
        if (supportedProtocols.isEmpty()) {
            supportedProtocols.addAll(AVAILABLE_PROTOCOLS);
        }
        List<String> list = supportedProtocols;
        if (list == null) {
            AgentServerProtocols.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static String getSupportedProtocolsString() {
        String string = TeamCityProperties.getProperty((String)INTERNAL_PROPERTY_NAME, (String)"polling");
        if (string == null) {
            AgentServerProtocols.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static List<String> getAgentPreferableProtocols(Map<String, String> agentProperties) {
        String agentsInternalProperty = agentProperties.get(INTERNAL_PROPERTY_NAME);
        List<String> list = AgentServerProtocols.parseInternalProperty(agentsInternalProperty);
        if (list == null) {
            AgentServerProtocols.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<String> parseInternalProperty(@Nullable String internalProperty) {
        if (internalProperty == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                AgentServerProtocols.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String protocolFromProperty : StringUtil.split((String)internalProperty, (boolean)true, (char[])new char[]{','})) {
            String trimmed = protocolFromProperty.trim();
            if (AVAILABLE_PROTOCOLS.contains(trimmed)) {
                result.add(trimmed);
                continue;
            }
            Loggers.AGENT.warn("Unrecognized Server-Agent communication protocol is specified in the internal property: '" + trimmed + "'");
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            AgentServerProtocols.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "jetbrains/buildServer/agentServer/AgentServerProtocols";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerSupportedProtocols";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseProtocols";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedProtocolsString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentPreferableProtocols";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseInternalProperty";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

