/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.agentServer.polling;

import java.io.File;
import java.io.FileNotFoundException;
import jetbrains.buildServer.agentServer.polling.PollingAgentLogger;
import jetbrains.buildServer.util.FileUtil;
import org.jetbrains.annotations.Nullable;

public class PollingProtocolCommon {
    public static final String SESSION_HEADER_NAME = "TeamCity-AgentSessionId";
    public static final String COMMAND_NAME_HEADER_NAME = "TeamCity-AgentCommandName";
    public static final String COMMAND_ID_HEADER_NAME = "TeamCity-AgentCommandId";
    private static final String LOCAL_CHECK_FILE_NAME = "tcLocalAgentCheck";
    private static final long LOCAL_CHECK_FILE_MAX_LENGTH_IN_BYTES = 1024L;

    @Nullable
    public static String writeLocalCheckFile(String data) {
        try {
            byte[] dataBytes = data.getBytes("UTF-8");
            if ((long)dataBytes.length > 1024L) {
                PollingAgentLogger.getLogger().debug("Error while checking whether agent is local: data is too long.");
                return null;
            }
            File file = FileUtil.createTempFile((String)LOCAL_CHECK_FILE_NAME, (String)"tmp");
            FileUtil.writeToFile((File)file, (byte[])dataBytes);
            return file.getAbsolutePath();
        }
        catch (Throwable e) {
            PollingAgentLogger.getLogger().debug("Error while checking whether agent is local", e);
            return null;
        }
    }

    @Nullable
    public static String readLocalCheckFile(String filePath) {
        try {
            if (!filePath.contains(LOCAL_CHECK_FILE_NAME)) {
                PollingAgentLogger.getLogger().debug("Error while checking whether agent is local: unexpected file path '" + filePath + "'");
                return null;
            }
            File file = new File(filePath);
            if (file.length() > 1024L) {
                PollingAgentLogger.getLogger().debug("Error while checking whether agent is local: file is too big.");
                return null;
            }
            return FileUtil.readText((File)file, (String)"UTF-8");
        }
        catch (FileNotFoundException e) {
            PollingAgentLogger.getLogger().debug("Agent local check file was not found", (Throwable)e);
            return null;
        }
        catch (Throwable e) {
            PollingAgentLogger.getLogger().debug("Error while checking whether agent is local", e);
            return null;
        }
    }
}

