/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import com.intellij.openapi.util.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.artifacts.FileProgress;
import jetbrains.buildServer.artifacts.ProgressTrackingURLContentRetriever;
import jetbrains.buildServer.artifacts.URLContentRetriever;
import jetbrains.buildServer.artifacts.impl.DownloadedArtifacts;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.ExceptionUtil;
import jetbrains.buildServer.util.StringUtil;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeURLContentRetriever
implements URLContentRetriever {
    private static final Logger LOG = Logger.getLogger(CompositeURLContentRetriever.class);
    private static final String SHOW_ALL_ERRORS_PROPERTY_KEY = "teamcity.artifacts.showAllErrors";
    @NotNull
    private final List<URLContentRetriever> myUrlContentRetrievers;
    @NotNull
    private final AtomicBoolean isInterrupted;
    @NotNull
    private final DownloadedArtifacts myDownloadedArtifacts;

    public CompositeURLContentRetriever(@NotNull List<URLContentRetriever> urlContentRetrievers, @NotNull DownloadedArtifacts downloadedArtifacts) {
        if (urlContentRetrievers == null) {
            CompositeURLContentRetriever.$$$reportNull$$$0(0);
        }
        if (downloadedArtifacts == null) {
            CompositeURLContentRetriever.$$$reportNull$$$0(1);
        }
        this.myUrlContentRetrievers = urlContentRetrievers;
        this.isInterrupted = new AtomicBoolean(false);
        this.myDownloadedArtifacts = downloadedArtifacts;
    }

    CompositeURLContentRetriever(@NotNull List<URLContentRetriever> urlContentRetrievers) {
        if (urlContentRetrievers == null) {
            CompositeURLContentRetriever.$$$reportNull$$$0(2);
        }
        this.myUrlContentRetrievers = urlContentRetrievers;
        this.isInterrupted = new AtomicBoolean(false);
        this.myDownloadedArtifacts = new DownloadedArtifacts.DisabledTracker();
    }

    @Nullable
    private String performOperation(@NotNull Operation op, String description) throws IOException {
        if (op == null) {
            CompositeURLContentRetriever.$$$reportNull$$$0(3);
        }
        ArrayList<Pair> exceptions = new ArrayList<Pair>();
        String anyRes = null;
        for (URLContentRetriever urlContentRetriever : this.myUrlContentRetrievers) {
            try {
                if (this.isInterrupted.get()) break;
                String res = op.perform(urlContentRetriever);
                if (res == null && !this.isInterrupted.get()) continue;
                anyRes = res;
                break;
            }
            catch (Throwable ex) {
                exceptions.add(Pair.create((Object)urlContentRetriever, (Object)ex));
            }
        }
        if (!exceptions.isEmpty()) {
            if (anyRes == null || this.shouldShowExceptions()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(StringUtil.withPlural((long)exceptions.size(), (String)"exception")).append(" occurred in CompositeURLContentRetriever during ").append(description).append(":");
                for (Pair p : exceptions) {
                    if (exceptions.size() > 1) {
                        stringBuilder.append("\n");
                    } else {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(((URLContentRetriever)p.first).getClass().getName()).append(": ").append(p.second).append(" in ");
                }
                LOG.warn((Object)stringBuilder.toString());
            }
            if (anyRes == null) {
                Pair p = (Pair)exceptions.get(exceptions.size() - 1);
                if (p.second instanceof IOException) {
                    throw (IOException)p.second;
                }
                throw new IOException("Cannot " + description + " via " + p.first + ": " + ((Throwable)p.second).toString() + ", caused by: " + ExceptionUtil.getDisplayMessage((Throwable)((Throwable)p.second)), (Throwable)p.second);
            }
        }
        return anyRes;
    }

    @Nullable
    public String downloadUrlTo(final @NotNull String url, final @NotNull File target) throws IOException {
        if (url == null) {
            CompositeURLContentRetriever.$$$reportNull$$$0(4);
        }
        if (target == null) {
            CompositeURLContentRetriever.$$$reportNull$$$0(5);
        }
        return this.performOperation(new Operation(){

            @Override
            public String perform(@NotNull URLContentRetriever retriever) throws IOException {
                if (retriever == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileProgress downloadProgress = CompositeURLContentRetriever.this.myDownloadedArtifacts.fileDownloadStarted(url, this.getRetrieverId(retriever));
                try {
                    String res = retriever instanceof ProgressTrackingURLContentRetriever ? ((ProgressTrackingURLContentRetriever)retriever).downloadUrlTo(url, target, downloadProgress) : retriever.downloadUrlTo(url, target);
                    if (res == null) {
                        downloadProgress.cantDownloadFile();
                    } else {
                        downloadProgress.fileDownloaded();
                    }
                    return res;
                }
                catch (Throwable e) {
                    downloadProgress.errorOccurred(e);
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new RuntimeException(e);
                }
            }

            private String getRetrieverId(@NotNull URLContentRetriever retriever) {
                if (retriever == null) {
                    1.$$$reportNull$$$0(1);
                }
                return retriever instanceof ProgressTrackingURLContentRetriever ? ((ProgressTrackingURLContentRetriever)retriever).getId() : retriever.getClass().getSimpleName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "retriever";
                objectArray2[1] = "jetbrains/buildServer/artifacts/impl/CompositeURLContentRetriever$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "perform";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getRetrieverId";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, "download file");
    }

    @Nullable
    public String getDigest(final @NotNull String url) throws IOException {
        if (url == null) {
            CompositeURLContentRetriever.$$$reportNull$$$0(6);
        }
        return this.performOperation(new Operation(){

            @Override
            public String perform(@NotNull URLContentRetriever retriever) throws IOException {
                if (retriever == null) {
                    2.$$$reportNull$$$0(0);
                }
                return retriever.getDigest(url);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "retriever", "jetbrains/buildServer/artifacts/impl/CompositeURLContentRetriever$2", "perform"));
            }
        }, "get digest");
    }

    public void interrupt() {
        if (this.isInterrupted.compareAndSet(false, true)) {
            RuntimeException last = null;
            for (URLContentRetriever urlContentRetriever : this.myUrlContentRetrievers) {
                try {
                    urlContentRetriever.interrupt();
                }
                catch (RuntimeException ex) {
                    last = ex;
                }
            }
            if (last != null) {
                throw last;
            }
        }
    }

    private boolean shouldShowExceptions() {
        return TeamCityProperties.getBoolean((String)SHOW_ALL_ERRORS_PROPERTY_KEY);
    }

    @NotNull
    public Collection<URLContentRetriever> getUrlContentRetrievers() {
        List<URLContentRetriever> list = Collections.unmodifiableList(this.myUrlContentRetrievers);
        if (list == null) {
            CompositeURLContentRetriever.$$$reportNull$$$0(7);
        }
        return list;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlContentRetrievers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadedArtifacts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/impl/CompositeURLContentRetriever";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/impl/CompositeURLContentRetriever";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlContentRetrievers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performOperation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "downloadUrlTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDigest";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface Operation {
        public String perform(@NotNull URLContentRetriever var1) throws IOException;
    }
}

