/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import jetbrains.buildServer.artifacts.ResolvingFailedException;
import jetbrains.buildServer.artifacts.rules.ArtifactDepRuleSet;
import jetbrains.buildServer.util.ArchiveExtractorManager;
import jetbrains.buildServer.util.ArchiveFileSelector;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.UnsupportedArchiveTypeException;
import org.jetbrains.annotations.NotNull;

class DependencyArchiveHelper {
    private final ArchiveExtractorManager myArchiveExtractor;

    public DependencyArchiveHelper(ArchiveExtractorManager archiveExtractor) {
        this.myArchiveExtractor = archiveExtractor;
    }

    public void unpackArchiveWithPattern(@NotNull File archive, @NotNull File destinationDir, @NotNull ArtifactDepRuleSet archiveRuleSet, @NotNull BiConsumer<String, File> unpackConsumer, @NotNull BiConsumer<String, File> existingFileConsumer) throws IOException {
        if (archive == null) {
            DependencyArchiveHelper.$$$reportNull$$$0(0);
        }
        if (destinationDir == null) {
            DependencyArchiveHelper.$$$reportNull$$$0(1);
        }
        if (archiveRuleSet == null) {
            DependencyArchiveHelper.$$$reportNull$$$0(2);
        }
        if (unpackConsumer == null) {
            DependencyArchiveHelper.$$$reportNull$$$0(3);
        }
        if (existingFileConsumer == null) {
            DependencyArchiveHelper.$$$reportNull$$$0(4);
        }
        HashMap<File, List<String>> myCopiesMap = new HashMap<File, List<String>>();
        try {
            RuleSetFileSelector selector = new RuleSetFileSelector(archiveRuleSet, destinationDir, myCopiesMap, unpackConsumer, existingFileConsumer);
            this.myArchiveExtractor.extractFiles(archive, (ArchiveFileSelector)selector);
            this.postProcessCopies(myCopiesMap, destinationDir);
        }
        catch (UnsupportedArchiveTypeException e) {
            throw new ResolvingFailedException("Unsupported archive type while extracting artifact \"" + archive.getName() + "\"");
        }
    }

    private void postProcessCopies(@NotNull Map<File, List<String>> copiesMap, @NotNull File destinationDir) throws IOException {
        if (copiesMap == null) {
            DependencyArchiveHelper.$$$reportNull$$$0(5);
        }
        if (destinationDir == null) {
            DependencyArchiveHelper.$$$reportNull$$$0(6);
        }
        for (Map.Entry<File, List<String>> entry : copiesMap.entrySet()) {
            File original = entry.getKey();
            List<String> targets = entry.getValue();
            if (!original.isFile()) continue;
            for (String target : targets) {
                File targetFile = FileUtil.resolvePath((File)destinationDir, (String)target);
                if (targetFile.exists() && !targetFile.delete()) {
                    throw new IOException("Failed to overwrite target file " + targetFile.getCanonicalPath());
                }
                FileUtil.copy((File)original, (File)targetFile);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveRuleSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unpackConsumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingFileConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiesMap";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/artifacts/impl/DependencyArchiveHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "unpackArchiveWithPattern";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessCopies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RuleSetFileSelector
    implements ArchiveFileSelector {
        private final ArtifactDepRuleSet myArchiveRuleSet;
        private final File myDestPath;
        private final Map<File, List<String>> myCopiesMap;
        private final BiConsumer<String, File> myUnpackConsumer;
        private final BiConsumer<String, File> myExistingFileConsumer;

        public RuleSetFileSelector(@NotNull ArtifactDepRuleSet archiveRuleSet, @NotNull File destination, @NotNull Map<File, List<String>> copiesMap, @NotNull BiConsumer<String, File> unpackConsumer, @NotNull BiConsumer<String, File> existingFileConsumer) {
            if (archiveRuleSet == null) {
                RuleSetFileSelector.$$$reportNull$$$0(0);
            }
            if (destination == null) {
                RuleSetFileSelector.$$$reportNull$$$0(1);
            }
            if (copiesMap == null) {
                RuleSetFileSelector.$$$reportNull$$$0(2);
            }
            if (unpackConsumer == null) {
                RuleSetFileSelector.$$$reportNull$$$0(3);
            }
            if (existingFileConsumer == null) {
                RuleSetFileSelector.$$$reportNull$$$0(4);
            }
            this.myArchiveRuleSet = archiveRuleSet;
            this.myUnpackConsumer = unpackConsumer;
            this.myExistingFileConsumer = existingFileConsumer;
            this.myDestPath = destination;
            this.myCopiesMap = copiesMap;
        }

        public File getDestinationFile(@NotNull String archiveEntryName) {
            String normalizedEntryName;
            if (archiveEntryName == null) {
                RuleSetFileSelector.$$$reportNull$$$0(5);
            }
            if (!this.myArchiveRuleSet.shouldInclude(normalizedEntryName = FileUtil.normalizeRelativePath((String)archiveEntryName))) {
                return null;
            }
            List targets = CollectionsUtil.convertCollection(this.myArchiveRuleSet.getTargetPath(normalizedEntryName), source -> {
                if (new File((String)source).isAbsolute()) {
                    return FileUtil.normalizeAbsolutePath((String)source);
                }
                return FileUtil.normalizeRelativePath((String)source);
            });
            if (targets.size() > 0) {
                File targetFile = FileUtil.resolvePath((File)this.myDestPath, (String)((String)targets.get(0)));
                if (targetFile.exists()) {
                    targetFile.delete();
                    this.myExistingFileConsumer.accept(archiveEntryName, targetFile);
                }
                this.myUnpackConsumer.accept(normalizedEntryName, targetFile);
                if (targets.size() > 1) {
                    this.myCopiesMap.put(targetFile, new ArrayList(targets.subList(1, targets.size())));
                }
                return targetFile;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "archiveRuleSet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destination";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copiesMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unpackConsumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingFileConsumer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "archiveEntryName";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/artifacts/impl/DependencyArchiveHelper$RuleSetFileSelector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDestinationFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

