/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import java.io.File;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import jetbrains.buildServer.ExtensionsProvider;
import jetbrains.buildServer.artifacts.ArtifactCacheProvider;
import jetbrains.buildServer.artifacts.ArtifactDependency;
import jetbrains.buildServer.artifacts.ArtifactStorageSettingsProvider;
import jetbrains.buildServer.artifacts.DependencyResolver;
import jetbrains.buildServer.artifacts.DependencyResolverContext;
import jetbrains.buildServer.artifacts.DependencyResolverListener;
import jetbrains.buildServer.artifacts.ResolutionErrors;
import jetbrains.buildServer.artifacts.ResolvingFailedException;
import jetbrains.buildServer.artifacts.ResolvingInterruptedException;
import jetbrains.buildServer.artifacts.impl.ArtifactDependencyTargetDirectoryCleaner;
import jetbrains.buildServer.artifacts.impl.DependencyArchiveHelper;
import jetbrains.buildServer.artifacts.impl.DependencyResolverEventDispatcher;
import jetbrains.buildServer.artifacts.impl.DownloadedArtifacts;
import jetbrains.buildServer.artifacts.impl.DownloadedArtifactsImpl;
import jetbrains.buildServer.artifacts.impl.DownloadedArtifactsProgress;
import jetbrains.buildServer.artifacts.impl.RecoverableResolvingException;
import jetbrains.buildServer.artifacts.impl.ResolverRuntimeConfiguration;
import jetbrains.buildServer.artifacts.impl.SingleDependencyProcessor;
import jetbrains.buildServer.artifacts.rules.ArtifactDepRuleSet;
import jetbrains.buildServer.util.ArchiveExtractorManager;
import jetbrains.buildServer.util.EventDispatcher;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.SystemTimeService;
import jetbrains.buildServer.util.TimeService;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyResolverImpl
implements DependencyResolver {
    private final DependencyArchiveHelper myDependencyArchiveHelper;
    @Nullable
    private final ArtifactCacheProvider myCacheProvider;
    private final ExtensionsProvider myExtensionProvider;
    private volatile boolean myIsInterrupted;
    private volatile SingleDependencyProcessor myCurrentProcessor;
    private final EventDispatcher<DependencyResolverListener> myDependencyResolverListenerEventDispatcher;
    @NotNull
    private final ArtifactStorageSettingsProvider myConfigProvider;
    @NotNull
    private final DownloadedArtifactsProgress myDownloadedArtifactsProgress;
    @NotNull
    private final ArtifactDependencyTargetDirectoryCleaner myArtifactDependencyTargetDirectoryCleaner;
    @NotNull
    private final String myTempDir;
    private static final Logger log = Logger.getLogger(DependencyResolverImpl.class);

    public DependencyResolverImpl(@NotNull ArchiveExtractorManager archiveExtractor, @NotNull ExtensionsProvider extensionsProvider, @Nullable ArtifactCacheProvider cacheProvider, @NotNull ArtifactStorageSettingsProvider configProvider, @NotNull ArtifactDependencyTargetDirectoryCleaner artifactDependencyTargetDirectoryCleaner) {
        if (archiveExtractor == null) {
            DependencyResolverImpl.$$$reportNull$$$0(0);
        }
        if (extensionsProvider == null) {
            DependencyResolverImpl.$$$reportNull$$$0(1);
        }
        if (configProvider == null) {
            DependencyResolverImpl.$$$reportNull$$$0(2);
        }
        if (artifactDependencyTargetDirectoryCleaner == null) {
            DependencyResolverImpl.$$$reportNull$$$0(3);
        }
        this.myCurrentProcessor = null;
        this.myDependencyArchiveHelper = new DependencyArchiveHelper(archiveExtractor);
        this.myCacheProvider = cacheProvider;
        this.myConfigProvider = configProvider;
        this.myDependencyResolverListenerEventDispatcher = new DependencyResolverEventDispatcher();
        this.myExtensionProvider = extensionsProvider;
        this.myDownloadedArtifactsProgress = new DownloadedArtifactsProgress.Disabled();
        this.myArtifactDependencyTargetDirectoryCleaner = artifactDependencyTargetDirectoryCleaner;
        this.myTempDir = System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID().toString();
    }

    public DependencyResolverImpl(@NotNull ArchiveExtractorManager archiveExtractor, @NotNull ExtensionsProvider extensionsProvider, @Nullable ArtifactCacheProvider cacheProvider, @NotNull ArtifactStorageSettingsProvider configProvider, @NotNull DownloadedArtifactsProgress downloadedArtifactsProgress, @NotNull ArtifactDependencyTargetDirectoryCleaner artifactDependencyTargetDirectoryCleaner, @Nullable String tempDir) {
        if (archiveExtractor == null) {
            DependencyResolverImpl.$$$reportNull$$$0(4);
        }
        if (extensionsProvider == null) {
            DependencyResolverImpl.$$$reportNull$$$0(5);
        }
        if (configProvider == null) {
            DependencyResolverImpl.$$$reportNull$$$0(6);
        }
        if (downloadedArtifactsProgress == null) {
            DependencyResolverImpl.$$$reportNull$$$0(7);
        }
        if (artifactDependencyTargetDirectoryCleaner == null) {
            DependencyResolverImpl.$$$reportNull$$$0(8);
        }
        this.myCurrentProcessor = null;
        this.myDependencyArchiveHelper = new DependencyArchiveHelper(archiveExtractor);
        this.myCacheProvider = cacheProvider;
        this.myConfigProvider = configProvider;
        this.myArtifactDependencyTargetDirectoryCleaner = artifactDependencyTargetDirectoryCleaner;
        this.myDependencyResolverListenerEventDispatcher = new DependencyResolverEventDispatcher();
        this.myExtensionProvider = extensionsProvider;
        this.myDownloadedArtifactsProgress = downloadedArtifactsProgress;
        this.myTempDir = tempDir != null ? tempDir : System.getProperty("java.io.tmpdir");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResolutionErrors resolve(@NotNull String buildTypeId, @NotNull File workingDir, @NotNull List<ArtifactDependency> dependencies, @NotNull DependencyResolverContext context) {
        if (buildTypeId == null) {
            DependencyResolverImpl.$$$reportNull$$$0(9);
        }
        if (workingDir == null) {
            DependencyResolverImpl.$$$reportNull$$$0(10);
        }
        if (dependencies == null) {
            DependencyResolverImpl.$$$reportNull$$$0(11);
        }
        if (context == null) {
            DependencyResolverImpl.$$$reportNull$$$0(12);
        }
        ResolverRuntimeConfiguration config = new ResolverRuntimeConfiguration(context, workingDir);
        ResolutionErrors errors = new ResolutionErrors();
        if (dependencies.isEmpty()) {
            ResolutionErrors resolutionErrors = errors;
            if (resolutionErrors == null) {
                DependencyResolverImpl.$$$reportNull$$$0(13);
            }
            return resolutionErrors;
        }
        ((DependencyResolverListener)this.myDependencyResolverListenerEventDispatcher.getMulticaster()).resolvingStarted(dependencies);
        if (this.myArtifactDependencyTargetDirectoryCleaner.isEnabled()) {
            for (ArtifactDependency dep : dependencies) {
                try {
                    if (!dep.isCleanDestinationFolder()) continue;
                    this.cleanupDestinationFolders(dep, workingDir);
                }
                catch (ResolvingFailedException ex) {
                    log.debug((Object)"Error during cleaning checkout directory", (Throwable)ex);
                    ((DependencyResolverListener)this.myDependencyResolverListenerEventDispatcher.getMulticaster()).artifactDownloadFailed(dep, (Throwable)ex);
                    errors.addFailure(dep, ex);
                    ResolutionErrors resolutionErrors = errors;
                    if (resolutionErrors == null) {
                        DependencyResolverImpl.$$$reportNull$$$0(14);
                    }
                    return resolutionErrors;
                }
            }
        } else {
            log.debug((Object)"Cleaning checkout directories is disabled");
        }
        HashMap<ArtifactDependency, DownloadedArtifacts> result = new HashMap<ArtifactDependency, DownloadedArtifacts>();
        this.myDownloadedArtifactsProgress.setDownloadedDependenciesState(result);
        try {
            for (ArtifactDependency dep : dependencies) {
                try (SingleDependencyProcessor.CollisionsDetector collisionsDetector = new SingleDependencyProcessor.CollisionsDetector(this.myTempDir);){
                    DownloadedArtifactsImpl downloadedArtifacts = new DownloadedArtifactsImpl(this.myDownloadedArtifactsProgress, (TimeService)new SystemTimeService());
                    result.put(dep, downloadedArtifacts);
                    this.myCurrentProcessor = new SingleDependencyProcessor((DependencyResolverListener)this.myDependencyResolverListenerEventDispatcher.getMulticaster(), dep, config, this.myDependencyArchiveHelper, this.myExtensionProvider, this.myCacheProvider, this.myConfigProvider, downloadedArtifacts, collisionsDetector);
                    if (this.myIsInterrupted) {
                        throw new ResolvingInterruptedException();
                    }
                    this.myCurrentProcessor.process();
                    this.myCurrentProcessor = null;
                }
                catch (RecoverableResolvingException e) {
                    ((DependencyResolverListener)this.myDependencyResolverListenerEventDispatcher.getMulticaster()).artifactDownloadFailed(dep, (Throwable)((Object)e));
                    errors.addRecoverableFailure(dep, (ResolvingFailedException)e);
                }
                catch (ResolvingFailedException e) {
                    ((DependencyResolverListener)this.myDependencyResolverListenerEventDispatcher.getMulticaster()).artifactDownloadFailed(dep, (Throwable)e);
                    errors.addFailure(dep, e);
                }
                this.myDownloadedArtifactsProgress.setCurrentFileProgress(null);
            }
        }
        catch (ResolvingInterruptedException resolvingInterruptedException) {
        }
        finally {
            if (this.myIsInterrupted) {
                ((DependencyResolverListener)this.myDependencyResolverListenerEventDispatcher.getMulticaster()).resolvingInterrupted();
            } else {
                ((DependencyResolverListener)this.myDependencyResolverListenerEventDispatcher.getMulticaster()).resolvingFinished();
            }
            this.myDownloadedArtifactsProgress.setCurrentFileProgress(null);
            this.myDownloadedArtifactsProgress.setDownloadedDependenciesState(null);
        }
        ResolutionErrors resolutionErrors = errors;
        if (resolutionErrors == null) {
            DependencyResolverImpl.$$$reportNull$$$0(15);
        }
        return resolutionErrors;
    }

    public void interrupt() {
        this.myIsInterrupted = true;
        if (this.myCurrentProcessor != null) {
            this.myCurrentProcessor.interrupt();
        }
    }

    @NotNull
    public static String describeDependency(ArtifactDependency dependency) {
        if (dependency == null) {
            if ("(null)" == null) {
                DependencyResolverImpl.$$$reportNull$$$0(16);
            }
            return "(null)";
        }
        String string = "<" + dependency.getSourceName() + ", " + DependencyResolverImpl.revisionToString(dependency) + ">";
        if (string == null) {
            DependencyResolverImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public static String revisionToString(@NotNull ArtifactDependency dependency) {
        if (dependency == null) {
            DependencyResolverImpl.$$$reportNull$$$0(18);
        }
        String string = dependency.getRevisionRule().getDescription().toLowerCase();
        if (string == null) {
            DependencyResolverImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    private void cleanupDestinationFolders(@NotNull ArtifactDependency dep, @NotNull File workingDir) {
        if (dep == null) {
            DependencyResolverImpl.$$$reportNull$$$0(20);
        }
        if (workingDir == null) {
            DependencyResolverImpl.$$$reportNull$$$0(21);
        }
        ArtifactDepRuleSet sourcePathRules = new ArtifactDepRuleSet(dep.getSourcePaths());
        Set<String> targetPaths = sourcePathRules.getTargetPaths();
        for (String targetPath : targetPaths) {
            File targetDir = FileUtil.resolvePath((File)workingDir, (String)targetPath);
            if (targetDir.exists()) {
                if (targetDir.isDirectory()) {
                    String error = this.myArtifactDependencyTargetDirectoryCleaner.cleanDirectory(targetDir);
                    if (error == null) {
                        ((DependencyResolverListener)this.myDependencyResolverListenerEventDispatcher.getMulticaster()).destinationDirCleaned(targetDir.getAbsolutePath(), true);
                        continue;
                    }
                    throw new ResolvingFailedException("Failed to clean up directory [" + targetDir.getAbsolutePath() + "]: " + error);
                }
                throw new ResolvingFailedException("Failed to clean up destination directory [" + targetDir.getAbsolutePath() + "]: it is not a directory.");
            }
            ((DependencyResolverListener)this.myDependencyResolverListenerEventDispatcher.getMulticaster()).destinationDirCleaned(targetDir.getAbsolutePath(), false);
        }
    }

    public void removeListener(DependencyResolverListener listener) {
        this.myDependencyResolverListenerEventDispatcher.removeListener((EventListener)listener);
    }

    public void addListener(DependencyResolverListener listener) {
        this.myDependencyResolverListenerEventDispatcher.addListener((EventListener)listener);
    }

    public EventDispatcher<DependencyResolverListener> getEventDispatcher() {
        return this.myDependencyResolverListenerEventDispatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveExtractor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsProvider";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configProvider";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactDependencyTargetDirectoryCleaner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadedArtifactsProgress";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypeId";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/impl/DependencyResolverImpl";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/impl/DependencyResolverImpl";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "describeDependency";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "revisionToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "revisionToString";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cleanupDestinationFolders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

