/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import com.intellij.openapi.util.Condition;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import jetbrains.buildServer.artifacts.ArtifactCacheProvider;
import jetbrains.buildServer.artifacts.ArtifactsCacheListener;
import jetbrains.buildServer.artifacts.CacheOptions;
import jetbrains.buildServer.artifacts.DigestCalculator;
import jetbrains.buildServer.artifacts.FileCache;
import jetbrains.buildServer.artifacts.LocalCache;
import jetbrains.buildServer.artifacts.URLContentRetriever;
import jetbrains.buildServer.artifacts.impl.ArtifactsCacheEventDispatcher;
import jetbrains.buildServer.artifacts.impl.HttpCacheImpl;
import jetbrains.buildServer.artifacts.impl.HttpDiskCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryCacheProviderImpl
implements ArtifactCacheProvider {
    private final DigestCalculator myDigestCalculator;
    private final ArtifactsCacheEventDispatcher myCacheMulticaster;
    protected HttpDiskCache myDiskCache;
    protected File myCacheDir;
    protected boolean myIsInitialized;

    public DirectoryCacheProviderImpl(@NotNull DigestCalculator digestCalculator) {
        if (digestCalculator == null) {
            DirectoryCacheProviderImpl.$$$reportNull$$$0(0);
        }
        this.myCacheMulticaster = new ArtifactsCacheEventDispatcher();
        this.myIsInitialized = false;
        this.myDigestCalculator = digestCalculator;
    }

    public DirectoryCacheProviderImpl(@NotNull File dir, @NotNull DigestCalculator digestCalculator) {
        if (dir == null) {
            DirectoryCacheProviderImpl.$$$reportNull$$$0(1);
        }
        if (digestCalculator == null) {
            DirectoryCacheProviderImpl.$$$reportNull$$$0(2);
        }
        this(digestCalculator);
        this.init(dir);
    }

    public void init(@NotNull File cacheDir) {
        if (cacheDir == null) {
            DirectoryCacheProviderImpl.$$$reportNull$$$0(3);
        }
        this.myCacheDir = cacheDir;
        this.myDiskCache = new HttpDiskCache(this.myCacheDir, this.myDigestCalculator, (ArtifactsCacheListener)this.myCacheMulticaster.getMulticaster());
        this.myIsInitialized = true;
        ((ArtifactsCacheListener)this.myCacheMulticaster.getMulticaster()).onCacheInitialized(this);
    }

    @Override
    @Nullable
    public FileCache getHttpCache(@NotNull URLContentRetriever transport) {
        if (transport == null) {
            DirectoryCacheProviderImpl.$$$reportNull$$$0(4);
        }
        if (!this.myIsInitialized) {
            return null;
        }
        return new HttpCacheImpl(this.myDiskCache, transport);
    }

    @Override
    @Nullable
    public LocalCache getLocalCache() {
        if (!this.myIsInitialized) {
            return null;
        }
        return new LocalCache(){

            @Override
            public void putFile(@NotNull String key, @NotNull File file) throws IOException {
                if (key == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                DirectoryCacheProviderImpl.this.myDiskCache.putFile(key, file);
            }

            @Override
            public void putFiles(@NotNull Map<String, File> keyToFileMap) throws IOException {
                if (keyToFileMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                DirectoryCacheProviderImpl.this.myDiskCache.putFiles(keyToFileMap);
            }

            @Override
            public void delete(@NotNull String key) {
                if (key == null) {
                    1.$$$reportNull$$$0(3);
                }
                DirectoryCacheProviderImpl.this.myDiskCache.delete(key);
            }

            @Override
            @NotNull
            public Collection<File> listCache() {
                Collection<File> collection = DirectoryCacheProviderImpl.this.myDiskCache.listCache();
                if (collection == null) {
                    1.$$$reportNull$$$0(4);
                }
                return collection;
            }

            @Override
            @NotNull
            public CacheOptions getCacheOptions() {
                CacheOptions cacheOptions = DirectoryCacheProviderImpl.this.myDiskCache.getCacheOptions();
                if (cacheOptions == null) {
                    1.$$$reportNull$$$0(5);
                }
                return cacheOptions;
            }

            @Override
            public void cleanUpCache() {
                DirectoryCacheProviderImpl.this.myDiskCache.cleanUpCache();
            }

            @Override
            public void cleanUpCache(long curMaxLifeTimeMs, Condition<Void> isInterrupted) {
                DirectoryCacheProviderImpl.this.myDiskCache.cleanUpCache(isInterrupted);
            }

            @Override
            public void cleanUpCache(long itemLifeTimeMillis) {
                DirectoryCacheProviderImpl.this.myDiskCache.cleanUpCache(itemLifeTimeMillis);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "keyToFileMap";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jetbrains/buildServer/artifacts/impl/DirectoryCacheProviderImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "jetbrains/buildServer/artifacts/impl/DirectoryCacheProviderImpl$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listCache";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCacheOptions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "putFile";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "putFiles";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "delete";
                        break;
                    }
                    case 4: 
                    case 5: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    public void addListener(@NotNull ArtifactsCacheListener listener) {
        if (listener == null) {
            DirectoryCacheProviderImpl.$$$reportNull$$$0(5);
        }
        this.myCacheMulticaster.addListener(listener);
    }

    @Override
    public void removeListener(@NotNull ArtifactsCacheListener listener) {
        if (listener == null) {
            DirectoryCacheProviderImpl.$$$reportNull$$$0(6);
        }
        this.myCacheMulticaster.removeListener(listener);
    }

    @Override
    @Nullable
    public File getCacheDir() {
        if (!this.myIsInitialized) {
            return null;
        }
        return this.myCacheDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digestCalculator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transport";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/artifacts/impl/DirectoryCacheProviderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getHttpCache";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

