/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jetbrains.buildServer.artifacts.DownloadingArtifactState;
import jetbrains.buildServer.artifacts.FileProgress;
import jetbrains.buildServer.artifacts.impl.DownloadedArtifacts;
import jetbrains.buildServer.artifacts.impl.DownloadedArtifactsProgress;
import jetbrains.buildServer.util.TimeService;
import org.jetbrains.annotations.NotNull;

public class DownloadedArtifactsImpl
implements DownloadedArtifacts {
    @NotNull
    private final Set<DownloadingArtifactState> myDownloadingArtifactStates;
    @NotNull
    private final DownloadedArtifactsProgress myArtifactsProgress;
    @NotNull
    private final TimeService myTimeService;
    @NotNull
    private final Object myDownloadingArtifactStatesLock;
    private volatile boolean myIsPaused;

    public DownloadedArtifactsImpl(@NotNull DownloadedArtifactsProgress artifactsProgress, @NotNull TimeService timeService) {
        if (artifactsProgress == null) {
            DownloadedArtifactsImpl.$$$reportNull$$$0(0);
        }
        if (timeService == null) {
            DownloadedArtifactsImpl.$$$reportNull$$$0(1);
        }
        this.myDownloadingArtifactStates = new HashSet<DownloadingArtifactState>();
        this.myDownloadingArtifactStatesLock = new Object();
        this.myIsPaused = false;
        this.myArtifactsProgress = artifactsProgress;
        this.myTimeService = timeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DownloadingArtifactState> getDownloadedArtifactInfos() {
        Object object = this.myDownloadingArtifactStatesLock;
        synchronized (object) {
            return new HashSet<DownloadingArtifactState>(this.myDownloadingArtifactStates);
        }
    }

    @Override
    public FileProgress fileDownloadStarted(@NotNull String url, @NotNull String retrieverId) {
        if (url == null) {
            DownloadedArtifactsImpl.$$$reportNull$$$0(2);
        }
        if (retrieverId == null) {
            DownloadedArtifactsImpl.$$$reportNull$$$0(3);
        }
        if (this.myIsPaused) {
            return new FileProgress.Adapter();
        }
        FileProgressImpl fileDownloadProgress = new FileProgressImpl(url, retrieverId, this.myTimeService.now());
        this.myArtifactsProgress.setCurrentFileProgress(fileDownloadProgress);
        return fileDownloadProgress;
    }

    @Override
    public void setPaused(boolean paused) {
        this.myIsPaused = paused;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactsProgress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retrieverId";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/artifacts/impl/DownloadedArtifactsImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDownloadStarted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FileProgressImpl
    implements FileProgress,
    DownloadingArtifactState {
        private volatile long myTransferred;
        private volatile long myExpectedLength;
        private final long myStartTime;
        private volatile long myFinishTime;
        private volatile boolean myIsFailed;
        @NotNull
        private final String myRetrieverId;
        @NotNull
        private final String myUrl;

        private FileProgressImpl(@NotNull String url, String retrieverId, long startTime) {
            if (url == null) {
                FileProgressImpl.$$$reportNull$$$0(0);
            }
            if (retrieverId == null) {
                FileProgressImpl.$$$reportNull$$$0(1);
            }
            this.myTransferred = 0L;
            this.myExpectedLength = -1L;
            this.myFinishTime = -1L;
            this.myIsFailed = false;
            this.myRetrieverId = retrieverId;
            this.myUrl = url;
            this.myStartTime = startTime;
        }

        @NotNull
        public String getUrl() {
            String string = this.myUrl;
            if (string == null) {
                FileProgressImpl.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getRetrieverId() {
            String string = this.myRetrieverId;
            if (string == null) {
                FileProgressImpl.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void transferred(long count) {
            this.myTransferred += count;
        }

        public void setExpectedLength(long expectedLength) {
            this.myExpectedLength = expectedLength;
        }

        public long getFinishTime() {
            return this.myFinishTime;
        }

        public long getStartTime() {
            return this.myStartTime;
        }

        public long getTransferred() {
            return this.myTransferred;
        }

        public boolean isFailed() {
            return this.myIsFailed;
        }

        public boolean isFinished() {
            return this.myFinishTime >= 0L;
        }

        public long getExpectedLength() {
            return this.myExpectedLength;
        }

        public void cantDownloadFile() {
            this.myFinishTime = DownloadedArtifactsImpl.this.myTimeService.now();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDownloaded() {
            this.myFinishTime = DownloadedArtifactsImpl.this.myTimeService.now();
            Object object = DownloadedArtifactsImpl.this.myDownloadingArtifactStatesLock;
            synchronized (object) {
                DownloadedArtifactsImpl.this.myDownloadingArtifactStates.add(this);
            }
        }

        public void errorOccurred(Throwable e) {
            this.myIsFailed = true;
            this.myFinishTime = DownloadedArtifactsImpl.this.myTimeService.now();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileProgressImpl that = (FileProgressImpl)o;
            if (!this.myRetrieverId.equals(that.myRetrieverId)) {
                return false;
            }
            return this.myUrl.equals(that.myUrl);
        }

        public int hashCode() {
            int result = this.myRetrieverId.hashCode();
            result = 31 * result + this.myUrl.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "retrieverId";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/artifacts/impl/DownloadedArtifactsImpl$FileProgressImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/artifacts/impl/DownloadedArtifactsImpl$FileProgressImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRetrieverId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

