/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import jetbrains.buildServer.artifacts.TransportFactoryExtension;
import jetbrains.buildServer.artifacts.URLContentRetriever;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilesystemTransportFactory
implements TransportFactoryExtension {
    @Nullable
    public URLContentRetriever getTransport(@NotNull Map<String, String> parameters) {
        if (parameters == null) {
            FilesystemTransportFactory.$$$reportNull$$$0(0);
        }
        return new FilesystemTransport();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "jetbrains/buildServer/artifacts/impl/FilesystemTransportFactory", "getTransport"));
    }

    public static class FilesystemTransport
    implements URLContentRetriever {
        private static final String FILE_PROTOCOL = "file:";
        private volatile boolean myIsInterrupted;

        @NotNull
        public String downloadUrlTo(@NotNull String url, @NotNull File target) throws IOException {
            if (url == null) {
                FilesystemTransport.$$$reportNull$$$0(0);
            }
            if (target == null) {
                FilesystemTransport.$$$reportNull$$$0(1);
            }
            if (url.startsWith(FILE_PROTOCOL)) {
                String filePathEncoded = this.cutProtocol(url);
                String filePath = StringUtil.decodeURL((String)filePathEncoded);
                File file = new File(filePath);
                FileUtil.copy((File)file, (File)target);
                String string = url + file.lastModified();
                if (string == null) {
                    FilesystemTransport.$$$reportNull$$$0(2);
                }
                return string;
            }
            throw new IOException("Unexpected protocol in url [" + url + "]");
        }

        @NotNull
        public String getDigest(@NotNull String url) throws IOException {
            if (url == null) {
                FilesystemTransport.$$$reportNull$$$0(3);
            }
            if (url.startsWith(FILE_PROTOCOL)) {
                String filePathEncoded = this.cutProtocol(url);
                String filePath = StringUtil.decodeURL((String)filePathEncoded);
                File file = new File(filePath);
                String string = url + file.lastModified();
                if (string == null) {
                    FilesystemTransport.$$$reportNull$$$0(4);
                }
                return string;
            }
            throw new IOException("Unexpected protocol in url [" + url + "]");
        }

        private String cutProtocol(String url) {
            String filePathEncoded = url.substring(FILE_PROTOCOL.length());
            while (filePathEncoded.startsWith("/")) {
                filePathEncoded = filePathEncoded.substring(1);
            }
            if (SystemInfo.isUnix) {
                filePathEncoded = "/" + filePathEncoded;
            }
            return filePathEncoded;
        }

        public void interrupt() {
            this.myIsInterrupted = true;
        }

        public boolean isInterrupted() {
            return this.myIsInterrupted;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/artifacts/impl/FilesystemTransportFactory$FilesystemTransport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/artifacts/impl/FilesystemTransportFactory$FilesystemTransport";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "downloadUrlTo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDigest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "downloadUrlTo";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDigest";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

