/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import com.google.gson.Gson;
import java.io.File;
import java.util.Date;
import jetbrains.buildServer.artifacts.impl.HttpDiskCache;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HttpCacheEntry {
    public static final String CACHED_FILE_INFO_SUFFIX = ".cache_info.json";
    private static final Gson GSON = new Gson();
    private String myUrl;
    private String myFootprint;
    private long myUpdateDate;
    private long myLastUsed;
    private String myRelativeFilePath;
    @NotNull
    private transient File myBaseDir;
    private transient File myFile;
    private transient File myFileInfo;

    @Nullable
    public static HttpCacheEntry createFromSerialized(@NotNull String cacheEntryString, @NotNull File baseDir) {
        if (cacheEntryString == null) {
            HttpCacheEntry.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            HttpCacheEntry.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmptyOrSpaces((String)cacheEntryString)) {
            return null;
        }
        HttpCacheEntry entry = (HttpCacheEntry)GSON.fromJson(cacheEntryString, HttpCacheEntry.class);
        entry.setBaseDir(baseDir);
        return entry;
    }

    public static HttpCacheEntry createFromUrl(@NotNull String url, @NotNull File baseDir) {
        if (url == null) {
            HttpCacheEntry.$$$reportNull$$$0(2);
        }
        if (baseDir == null) {
            HttpCacheEntry.$$$reportNull$$$0(3);
        }
        HttpCacheEntry entry = new HttpCacheEntry(baseDir);
        entry.setUrl(url);
        return entry;
    }

    private HttpCacheEntry(@NotNull File baseDir) {
        if (baseDir == null) {
            HttpCacheEntry.$$$reportNull$$$0(4);
        }
        this.myUrl = "";
        this.myFootprint = "";
        this.myRelativeFilePath = "";
        this.myBaseDir = baseDir;
    }

    @NotNull
    public static String generateFilePath(@NotNull String key) {
        String path;
        int colonIdex;
        if (key == null) {
            HttpCacheEntry.$$$reportNull$$$0(5);
        }
        if ((colonIdex = (path = key).indexOf(":/")) > 0 && (path = path.substring(colonIdex + ":/".length())).startsWith("/")) {
            path = path.substring(1);
        }
        if (StringUtil.isEmpty((String)path)) {
            if ("emptyUrl.dat" == null) {
                HttpCacheEntry.$$$reportNull$$$0(6);
            }
            return "emptyUrl.dat";
        }
        StringBuffer filePath = new StringBuffer();
        for (String dirNameEncoded : path.split("/")) {
            String dirName = StringUtil.decodeURL((String)dirNameEncoded);
            filePath.append(FileUtil.fixDirectoryNameAllowUnicode((String)dirName)).append(File.separatorChar);
        }
        filePath.deleteCharAt(filePath.length() - 1);
        String string = filePath.toString();
        if (string == null) {
            HttpCacheEntry.$$$reportNull$$$0(7);
        }
        return string;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public void setUrl(String srcUrl) {
        this.myUrl = srcUrl;
        this.myRelativeFilePath = HttpCacheEntry.generateFilePath(srcUrl);
        this.myFile = null;
        this.myFileInfo = null;
    }

    @NotNull
    public String getStringValue() {
        String string = GSON.toJson((Object)this);
        if (string == null) {
            HttpCacheEntry.$$$reportNull$$$0(8);
        }
        return string;
    }

    public File getFile() {
        if (this.myFile == null) {
            this.myFile = new File(this.myBaseDir, this.myRelativeFilePath);
        }
        return this.myFile;
    }

    public File getFileInfo() {
        if (this.myFileInfo == null) {
            this.myFileInfo = new File(this.myBaseDir, this.myRelativeFilePath + CACHED_FILE_INFO_SUFFIX);
        }
        return this.myFileInfo;
    }

    public String getFootprint() {
        return this.myFootprint;
    }

    public void setFootprint(String footprint) {
        this.myFootprint = footprint;
    }

    public boolean hasExpired(long expirationTimeMillis) {
        long lifeTime = this.currentTime() - this.myUpdateDate;
        return lifeTime > expirationTimeMillis;
    }

    public Date getUpdateDate() {
        return new Date(this.myUpdateDate);
    }

    public void updateExpiration() {
        this.myUpdateDate = this.currentTime();
    }

    public Date getLastUsedDate() {
        return new Date(this.myLastUsed);
    }

    public void updateLastUsed() {
        this.myLastUsed = this.currentTime();
    }

    private long currentTime() {
        return HttpDiskCache.getTimeService().now();
    }

    public long getDiskLength() {
        return this.getFile().length() + this.getFileInfo().length();
    }

    public void setBaseDir(@NotNull File baseDir) {
        if (baseDir == null) {
            HttpCacheEntry.$$$reportNull$$$0(9);
        }
        this.myBaseDir = baseDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheEntryString";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/impl/HttpCacheEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/impl/HttpCacheEntry";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromSerialized";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFromUrl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateFilePath";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setBaseDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

