/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import jetbrains.buildServer.artifacts.CacheOptions;
import jetbrains.buildServer.serverSide.TeamCityProperties;

public class HttpCacheOptions
implements CacheOptions {
    public static final int DEFAULT_TTL = 1000 * TeamCityProperties.getInteger((String)"teamcity.agent.artifactsCache.ttlSeconds", (int)172800);
    private long myCacheExpirationTime = DEFAULT_TTL;
    private boolean myOverrideCache = false;
    private long myCacheSizeLimit = 0L;

    public HttpCacheOptions() {
    }

    public HttpCacheOptions(int cacheExpirationTimeSeconds, boolean overrideCache, long cacheSizeLimit) {
        this.myCacheExpirationTime = cacheExpirationTimeSeconds * 1000;
        this.myOverrideCache = overrideCache;
        this.myCacheSizeLimit = cacheSizeLimit;
    }

    @Override
    public void setCacheExpirationTime(long millis) {
        this.myCacheExpirationTime = millis;
    }

    @Override
    public void setOverrideCache(boolean override) {
        this.myOverrideCache = override;
    }

    @Override
    public void setCacheSizeLimit(long cacheSizeLimit) {
        this.myCacheSizeLimit = cacheSizeLimit;
    }

    public boolean isOverrideCache() {
        return this.myOverrideCache;
    }

    @Override
    public long getCacheExpirationTime() {
        return this.myCacheExpirationTime;
    }

    public long getCacheSizeLimit() {
        return this.myCacheSizeLimit;
    }
}

