/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Processor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.buildServer.Used;
import jetbrains.buildServer.artifacts.ArtifactsCacheListener;
import jetbrains.buildServer.artifacts.CacheOptions;
import jetbrains.buildServer.artifacts.DigestCalculator;
import jetbrains.buildServer.artifacts.URLContentRetriever;
import jetbrains.buildServer.artifacts.impl.HttpCacheEntry;
import jetbrains.buildServer.artifacts.impl.HttpCacheOptions;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.SystemTimeService;
import jetbrains.buildServer.util.TimeService;
import jetbrains.buildServer.util.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpDiskCache {
    private static final Logger LOG = Logger.getInstance((String)HttpDiskCache.class.getName());
    public static final String CONTENT_FILE_NAME = ".cache_content";
    private final File myCacheDir;
    @NotNull
    private final ArtifactsCacheListener myCacheMulticaster;
    private long myCacheSizeDiff;
    private boolean myCacheSizeIsExact;
    private final HttpCacheOptions myCacheOptions;
    private final DigestCalculator myDigestCalculator;
    private Long myOldestEntryUpdateTime;
    private static TimeService ourTimeService = SystemTimeService.getInstance();

    public HttpDiskCache(@NotNull File cacheDir, @NotNull DigestCalculator calculator, @NotNull ArtifactsCacheListener cacheMulticaster) {
        File cacheContentFile;
        if (cacheDir == null) {
            HttpDiskCache.$$$reportNull$$$0(0);
        }
        if (calculator == null) {
            HttpDiskCache.$$$reportNull$$$0(1);
        }
        if (cacheMulticaster == null) {
            HttpDiskCache.$$$reportNull$$$0(2);
        }
        this.myCacheSizeDiff = 0L;
        this.myCacheSizeIsExact = false;
        this.myCacheOptions = new HttpCacheOptions();
        this.myDigestCalculator = calculator;
        this.myCacheDir = cacheDir;
        this.myCacheMulticaster = cacheMulticaster;
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            LOG.warn("Failed to create cache directory " + cacheDir.getAbsolutePath() + "\nCache won't be available.");
            this.myCacheOptions.setOverrideCache(true);
        }
        if ((cacheContentFile = new File(cacheDir, CONTENT_FILE_NAME)).exists()) {
            this.fillCacheFromSingleFile(cacheContentFile);
        }
    }

    private long getCacheSize() {
        if (!this.myCacheSizeIsExact) {
            this.myCacheSizeDiff = FileUtil.getTotalDirectorySize((File)this.myCacheDir, (boolean)true);
            this.myCacheSizeIsExact = true;
        }
        return this.myCacheSizeDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCacheFromSingleFile(@NotNull File cacheContentFile) {
        if (cacheContentFile == null) {
            HttpDiskCache.$$$reportNull$$$0(3);
        }
        BufferedReader reader = null;
        try {
            String cacheEntryString;
            cacheContentFile.createNewFile();
            reader = new BufferedReader(new FileReader(cacheContentFile));
            while ((cacheEntryString = reader.readLine()) != null) {
                HttpCacheEntry entry;
                if (StringUtil.isEmptyOrSpaces((String)cacheEntryString) || (entry = HttpCacheEntry.createFromSerialized(cacheEntryString, this.myCacheDir)) == null || !entry.getFile().exists()) continue;
                this.save(entry);
                this.myCacheSizeDiff += entry.getDiskLength();
            }
        }
        catch (IOException e) {
            LOG.warnAndDebugDetails("Failed to create or read cache content file [" + cacheContentFile.getAbsolutePath() + "]", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOG.warnAndDebugDetails("Failed to close file stream [" + cacheContentFile.getAbsolutePath() + "]", (Throwable)e);
                }
            }
            if (cacheContentFile.exists()) {
                FileUtil.delete((File)cacheContentFile);
            }
        }
    }

    public synchronized boolean isValid(@NotNull String key, @NotNull URLContentRetriever transport) {
        if (key == null) {
            HttpDiskCache.$$$reportNull$$$0(4);
        }
        if (transport == null) {
            HttpDiskCache.$$$reportNull$$$0(5);
        }
        HttpCacheEntry entry = this.loadFromDisk(key);
        return this.isValidEntry(entry, transport);
    }

    @NotNull
    public synchronized File getFile(@NotNull String key, @NotNull URLContentRetriever transport) throws IOException {
        if (key == null) {
            HttpDiskCache.$$$reportNull$$$0(6);
        }
        if (transport == null) {
            HttpDiskCache.$$$reportNull$$$0(7);
        }
        HttpCacheEntry entry = this.loadFromDisk(key);
        if (this.myCacheOptions.isOverrideCache() || !this.isValidEntry(entry, transport)) {
            if (entry == null) {
                LOG.debug("Http cache miss: new entry [" + key + "]");
                entry = HttpCacheEntry.createFromUrl(key, this.myCacheDir);
            }
            this.retrieveEntry(entry, transport);
        } else {
            LOG.debug("Http cache hit [" + key + "]");
        }
        entry.updateLastUsed();
        this.save(entry);
        File file = entry.getFile();
        if (file == null) {
            HttpDiskCache.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public CacheOptions getCacheOptions() {
        HttpCacheOptions httpCacheOptions = this.myCacheOptions;
        if (httpCacheOptions == null) {
            HttpDiskCache.$$$reportNull$$$0(9);
        }
        return httpCacheOptions;
    }

    public synchronized long delete(@NotNull String key) {
        HttpCacheEntry entry;
        if (key == null) {
            HttpDiskCache.$$$reportNull$$$0(10);
        }
        if ((entry = this.loadFromDisk(key)) != null) {
            File file = entry.getFile();
            File infoFile = entry.getFileInfo();
            this.myCacheMulticaster.onBeforeDelete(file);
            long length = entry.getDiskLength();
            FileUtil.delete((File)file);
            FileUtil.delete((File)infoFile);
            File directory = file.getParentFile();
            while (!this.myCacheDir.equals(directory) && directory.delete()) {
                directory = directory.getParentFile();
            }
            this.myCacheSizeDiff -= length;
            LOG.debug("Removed cache entry [" + key + "] : " + length + " bytes. Deleted files: " + file + ", " + infoFile);
            this.myCacheMulticaster.onAfterDelete(file);
            return length;
        }
        LOG.debug("Failed to remove entry [" + key + "] - no such entry");
        return 0L;
    }

    private boolean isValidEntry(@Nullable HttpCacheEntry entry, @NotNull URLContentRetriever transport) {
        if (transport == null) {
            HttpDiskCache.$$$reportNull$$$0(11);
        }
        if (null == entry) {
            return false;
        }
        try {
            String key = entry.getUrl();
            if (entry.hasExpired(this.myCacheOptions.getCacheExpirationTime())) {
                LOG.debug("Http cache entry [" + key + "] has expired.");
                return false;
            }
            String value = transport.getDigest(entry.getUrl());
            if (value == null || !value.equals(entry.getFootprint())) {
                LOG.debug("Http cache entry [" + key + "] has new signature on server.");
                return false;
            }
            File cacheFile = entry.getFile();
            if (!cacheFile.exists() || !cacheFile.canRead()) {
                LOG.debug("Http cache entry [" + key + "] has invalid or non-existing file on the disk.");
                return false;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to validate cache entry. ", (Throwable)e);
            return false;
        }
        return true;
    }

    public synchronized void cleanUpCache() {
        this.cleanUpCache(this.myCacheOptions.getCacheExpirationTime());
    }

    public synchronized void cleanUpCache(long itemLifeTimeMillis) {
        this.cleanUpCache(itemLifeTimeMillis, (Condition<Void>)Condition.FALSE);
    }

    public synchronized void cleanUpCache(Condition<Void> isInterrupted) {
        this.cleanUpCache(this.myCacheOptions.getCacheExpirationTime(), isInterrupted);
    }

    public synchronized void cleanUpCache(long itemLifeTimeMillis, Condition<Void> isInterrupted) {
        LOG.info("Cleaning up items with life time in cache greater than " + itemLifeTimeMillis / 1000L + " seconds");
        int numRemoved = this.cleanUpExpiredItems(itemLifeTimeMillis, isInterrupted);
        LOG.info("Finished cleaning up expired items, " + numRemoved + " items removed");
        if (isInterrupted.value(null)) {
            return;
        }
        long cacheSizeLimit = this.myCacheOptions.getCacheSizeLimit();
        if (cacheSizeLimit > 0L) {
            LOG.info("Cleaning up cache to fit size limit: " + StringUtil.formatFileSize((long)cacheSizeLimit));
            this.assureCacheSize(cacheSizeLimit, isInterrupted);
        }
    }

    private void assureCacheSize(long cacheSizeLimit, Condition<Void> isInterrupted) {
        long cacheSizeOverflow = this.getCacheSize() - cacheSizeLimit;
        if (cacheSizeLimit > 0L && cacheSizeOverflow > 0L) {
            Collection<HttpCacheEntry> entries = this.collectEntriesToDelete(cacheSizeOverflow, isInterrupted);
            HashSet<File> touchedDirs = new HashSet<File>();
            for (HttpCacheEntry entry : entries) {
                if (isInterrupted.value(null)) {
                    return;
                }
                touchedDirs.add(entry.getFile().getParentFile());
                this.delete(entry.getUrl());
            }
            this.removeEmptyDirs(touchedDirs, isInterrupted);
        }
    }

    private int cleanUpExpiredItems(final long expirationTime, final Condition<Void> isInterrupted) {
        final int[] numRemoved = new int[]{0};
        if (expirationTime > 0L) {
            long oldestEntryTtl;
            if (this.myOldestEntryUpdateTime != null && expirationTime > (oldestEntryTtl = ourTimeService.now() - this.myOldestEntryUpdateTime)) {
                return 0;
            }
            final long[] oldestEntryUpdateTime = new long[]{-1L};
            final HashSet<File> touchedDirs = new HashSet<File>();
            Collection<File> orphanedFiles = this.doProcessFiles(new Processor<HttpCacheEntry>(){

                public boolean process(HttpCacheEntry entry) {
                    if (entry.hasExpired(expirationTime)) {
                        LOG.debug("Removing expired entry [" + entry.getFile() + "]");
                        touchedDirs.add(entry.getFile().getParentFile());
                        HttpDiskCache.this.delete(entry.getUrl());
                        numRemoved[0] = numRemoved[0] + 1;
                    } else {
                        oldestEntryUpdateTime[0] = oldestEntryUpdateTime[0] > 0L ? Math.min(oldestEntryUpdateTime[0], entry.getUpdateDate().getTime()) : entry.getUpdateDate().getTime();
                    }
                    return !isInterrupted.value(null);
                }
            });
            if (oldestEntryUpdateTime[0] > 0L) {
                this.myOldestEntryUpdateTime = oldestEntryUpdateTime[0];
            }
            for (File file : orphanedFiles) {
                LOG.debug("Removing orphaned file [" + file + "]");
                touchedDirs.add(file.getParentFile());
                FileUtil.delete((File)file);
                numRemoved[0] = numRemoved[0] + 1;
                if (!isInterrupted.value(null)) continue;
                return numRemoved[0];
            }
            this.removeEmptyDirs(touchedDirs, isInterrupted);
        }
        return numRemoved[0];
    }

    private void removeEmptyDirs(@NotNull Set<File> touchedDirs, Condition<Void> isInterrupted) {
        if (touchedDirs == null) {
            HttpDiskCache.$$$reportNull$$$0(12);
        }
        HashSet<File> touchedParents = new HashSet<File>();
        for (File dir : touchedDirs) {
            if (isInterrupted.value(null)) {
                return;
            }
            if (this.myCacheDir.equals(dir)) continue;
            File parent = dir.getParentFile();
            if (parent.equals(this.myCacheDir)) {
                parent = null;
            }
            if (!dir.isDirectory() || !dir.delete() || parent == null) continue;
            touchedParents.add(parent);
        }
        if (!touchedParents.isEmpty()) {
            this.removeEmptyDirs(touchedParents, isInterrupted);
        }
    }

    private Collection<HttpCacheEntry> collectEntriesToDelete(final long requiredShrinkSize, final Condition<Void> isInterrupted) {
        final AtomicLong collectedSize = new AtomicLong(0L);
        final TreeSet<HttpCacheEntry> entriesSet = new TreeSet<HttpCacheEntry>(new Comparator<HttpCacheEntry>(){

            @Override
            public int compare(@NotNull HttpCacheEntry o1, @NotNull HttpCacheEntry o2) {
                if (o1 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (o2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (o1.equals(o2) || o1.getUrl().equals(o2.getUrl())) {
                    return 0;
                }
                int timeComparison = Util.compare((long)o1.getLastUsedDate().getTime(), (long)o2.getLastUsedDate().getTime());
                if (timeComparison == 0) {
                    return o1.getUrl().compareTo(o2.getUrl());
                }
                return timeComparison;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "o1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "o2";
                        break;
                    }
                }
                objectArray[1] = "jetbrains/buildServer/artifacts/impl/HttpDiskCache$2";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.processCacheEntries(new Processor<HttpCacheEntry>(){

            public boolean process(HttpCacheEntry entry) {
                if (isInterrupted.value(null)) {
                    return false;
                }
                long space = entry.getDiskLength();
                if (collectedSize.get() < requiredShrinkSize) {
                    entriesSet.add(entry);
                    collectedSize.addAndGet(space);
                } else if (entriesSet.ceiling(entry) != null) {
                    entriesSet.add(entry);
                    collectedSize.addAndGet(space);
                    while (collectedSize.get() - ((HttpCacheEntry)entriesSet.last()).getDiskLength() > requiredShrinkSize) {
                        HttpCacheEntry droppedEntry = (HttpCacheEntry)entriesSet.pollLast();
                        collectedSize.addAndGet(-1L * droppedEntry.getDiskLength());
                    }
                }
                return true;
            }
        });
        return entriesSet;
    }

    public synchronized void processCacheEntries(@NotNull Processor<HttpCacheEntry> processor) {
        if (processor == null) {
            HttpDiskCache.$$$reportNull$$$0(13);
        }
        this.doProcessFiles(processor);
    }

    @NotNull
    private Collection<File> doProcessFiles(final @NotNull Processor<HttpCacheEntry> processor) {
        if (processor == null) {
            HttpDiskCache.$$$reportNull$$$0(14);
        }
        final HashSet<File> orphanedFiles = new HashSet<File>();
        FileUtil.processFilesRecursively((File)this.myCacheDir, (Processor)new Processor<File>(){

            public boolean process(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (!HttpDiskCache.this.isMetadataFile(file)) {
                    File metaFile = new File(file.getParentFile(), file.getName() + ".cache_info.json");
                    if (!metaFile.isFile()) {
                        LOG.debug("Found orphaned file '" + file + "': metadata file '" + metaFile + "' doesn't exist");
                        orphanedFiles.add(file);
                    }
                    return true;
                }
                File metaFile = file;
                try {
                    String cacheEntryString = FileUtil.readText((File)metaFile);
                    HttpCacheEntry entry = HttpCacheEntry.createFromSerialized(cacheEntryString, HttpDiskCache.this.myCacheDir);
                    if (entry == null) {
                        LOG.debug("Found orphaned file '" + file + "': metadata file '" + metaFile + "' is empty.");
                        orphanedFiles.add(metaFile);
                        orphanedFiles.add(file);
                        return true;
                    }
                    if (entry.getFile().exists()) {
                        return processor.process((Object)entry);
                    }
                    LOG.debug("Found orphaned file '" + entry.getFile() + "': entry file '" + entry.getFile() + "' doesn't exist.");
                    orphanedFiles.add(entry.getFile());
                }
                catch (IOException e) {
                    LOG.warn("Failed to read http cache entry");
                }
                return true;
            }
        });
        HashSet<File> hashSet = orphanedFiles;
        if (hashSet == null) {
            HttpDiskCache.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    private boolean isMetadataFile(@NotNull File file) {
        if (file == null) {
            HttpDiskCache.$$$reportNull$$$0(16);
        }
        return file.getName().endsWith(".cache_info.json");
    }

    private void retrieveEntry(@NotNull HttpCacheEntry entry, @NotNull URLContentRetriever transport) throws IOException {
        String footPrint;
        if (entry == null) {
            HttpDiskCache.$$$reportNull$$$0(17);
        }
        if (transport == null) {
            HttpDiskCache.$$$reportNull$$$0(18);
        }
        String url = entry.getUrl();
        File cacheFile = entry.getFile();
        this.myCacheMulticaster.onBeforeAddOrUpdate(cacheFile);
        try {
            footPrint = transport.downloadUrlTo(url, cacheFile);
        }
        catch (Throwable e) {
            FileUtil.delete((File)cacheFile);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        entry.setFootprint(footPrint);
        entry.updateExpiration();
        this.myCacheSizeDiff += cacheFile.length();
        this.myCacheMulticaster.onAfterAddOrUpdate(cacheFile);
        LOG.debug("Http disk cache - content fetched from [" + url + "]");
    }

    private HttpCacheEntry loadFromDisk(@NotNull String key) {
        File cacheFileInfo;
        if (key == null) {
            HttpDiskCache.$$$reportNull$$$0(19);
        }
        if ((cacheFileInfo = HttpCacheEntry.createFromUrl(key, this.myCacheDir).getFileInfo()).exists()) {
            try {
                String serializedEntry = FileUtil.readText((File)cacheFileInfo);
                HttpCacheEntry entry = HttpCacheEntry.createFromSerialized(serializedEntry, this.myCacheDir);
                if (entry == null) {
                    return null;
                }
                if (entry.getFile().exists()) {
                    return entry;
                }
            }
            catch (IOException e) {
                LOG.warnAndDebugDetails("Error while loading cached entry from disk", (Throwable)e);
            }
        }
        return null;
    }

    private void save(HttpCacheEntry entry) {
        try {
            FileUtil.writeFile((File)entry.getFileInfo(), (String)entry.getStringValue(), (String)"UTF-8");
        }
        catch (IOException e) {
            String message = "Error writing [" + entry.getFileInfo().getName() + "] to disk. Cache entry will not be saved";
            LOG.warnAndDebugDetails(message, (Throwable)e);
        }
    }

    public synchronized void putFile(@NotNull String key, @NotNull File file) throws IOException {
        HttpCacheEntry entry;
        if (key == null) {
            HttpDiskCache.$$$reportNull$$$0(20);
        }
        if (file == null) {
            HttpDiskCache.$$$reportNull$$$0(21);
        }
        if ((entry = this.loadFromDisk(key)) == null) {
            LOG.debug("Http cache put: new entry [" + key + "]");
            entry = HttpCacheEntry.createFromUrl(key, this.myCacheDir);
        } else {
            LOG.debug("Http cache put: overwrite entty [" + key + "]");
        }
        File cacheFile = entry.getFile();
        FileUtil.createParentDirs((File)cacheFile);
        if (cacheFile.exists()) {
            FileUtil.delete((File)cacheFile);
        }
        cacheFile.createNewFile();
        this.myCacheMulticaster.onBeforeAddOrUpdate(cacheFile);
        try {
            if (!this.tryToEnsureDiskSpace(file.length(), FileUtil.getFreeSpace((File)cacheFile))) {
                throw new IOException("Could not allocate enough disk space to put [" + file.getAbsolutePath() + "] into cache");
            }
            FileUtil.copy((File)file, (File)cacheFile);
        }
        catch (IOException e) {
            FileUtil.delete((File)cacheFile);
            throw e;
        }
        entry.setFootprint(this.myDigestCalculator.getDigest(cacheFile));
        entry.updateExpiration();
        this.save(entry);
        this.myCacheSizeDiff += entry.getDiskLength();
        this.myCacheMulticaster.onAfterAddOrUpdate(cacheFile);
        LOG.debug("Http disk cache - cached file from [" + file.getAbsolutePath() + "] under key [" + key + "]");
    }

    public synchronized void putFiles(@NotNull Map<String, File> keyToFile) throws IOException {
        if (keyToFile == null) {
            HttpDiskCache.$$$reportNull$$$0(22);
        }
        long totalSize = 0L;
        for (File file : keyToFile.values()) {
            totalSize += file.length();
        }
        Long availableSpace = FileUtil.getFreeSpace((File)this.myCacheDir);
        if (!this.tryToEnsureDiskSpace(totalSize, availableSpace) && availableSpace != null) {
            LOG.info("Not enough space to place all files to cache: " + FileUtil.getFreeSpace((File)this.myCacheDir) + " bytes available of " + totalSize + " required. Will put as many files as possible");
        }
        for (Map.Entry<String, File> keyFileEntry : keyToFile.entrySet()) {
            String key = keyFileEntry.getKey();
            File source = keyFileEntry.getValue();
            HttpCacheEntry entry = HttpCacheEntry.createFromUrl(key, this.myCacheDir);
            File target = entry.getFile();
            this.myCacheMulticaster.onBeforeAddOrUpdate(target);
            try {
                FileUtil.copy((File)source, (File)target);
                entry.setFootprint(this.myDigestCalculator.getDigest(target));
                entry.updateExpiration();
                this.save(entry);
                this.myCacheSizeDiff += entry.getDiskLength();
                this.myCacheMulticaster.onAfterAddOrUpdate(target);
            }
            catch (IOException e) {
                LOG.warnAndDebugDetails("Error copying [" + source.getCanonicalPath() + "] to [" + target.getCanonicalPath() + "]", (Throwable)e);
            }
        }
    }

    boolean tryToEnsureDiskSpace(long targetLength, @Nullable Long availableSpace) {
        if (availableSpace == null) {
            return false;
        }
        long currentAvailableSpace = availableSpace;
        if (targetLength > currentAvailableSpace && (this.myCacheSizeDiff > targetLength || this.getCacheSize() > targetLength)) {
            Collection<HttpCacheEntry> entries = this.collectEntriesToDelete(targetLength - availableSpace, (Condition<Void>)((Condition)arg -> false));
            for (HttpCacheEntry entry : entries) {
                currentAvailableSpace += this.delete(entry.getUrl());
            }
        }
        return currentAvailableSpace > targetLength;
    }

    @NotNull
    public synchronized Collection<File> listCache() {
        final ArrayList<File> result = new ArrayList<File>();
        this.processCacheEntries(new Processor<HttpCacheEntry>(){

            public boolean process(HttpCacheEntry cacheEntry) {
                result.add(cacheEntry.getFile());
                return true;
            }
        });
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            HttpDiskCache.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @Used(value="tests")
    public static void setTimeService(@NotNull TimeService timeService) {
        if (timeService == null) {
            HttpDiskCache.$$$reportNull$$$0(24);
        }
        ourTimeService = timeService;
    }

    @NotNull
    static TimeService getTimeService() {
        TimeService timeService = ourTimeService;
        if (timeService == null) {
            HttpDiskCache.$$$reportNull$$$0(25);
        }
        return timeService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calculator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheMulticaster";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheContentFile";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 7: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transport";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/impl/HttpDiskCache";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "touchedDirs";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyToFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/impl/HttpDiskCache";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheOptions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "doProcessFiles";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "listCache";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fillCacheFromSingleFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 23: 
            case 25: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValidEntry";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptyDirs";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processCacheEntries";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doProcessFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isMetadataFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "retrieveEntry";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDisk";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "putFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "putFiles";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setTimeService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 15: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

