/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.buildServer.artifacts.FileProgress;
import jetbrains.buildServer.artifacts.ProgressTrackingURLContentRetriever;
import jetbrains.buildServer.artifacts.RecoverableIOException;
import jetbrains.buildServer.artifacts.URLContentRetriever;
import jetbrains.buildServer.http.HttpUserAgent;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.RedirectException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpTransport
implements URLContentRetriever,
ProgressTrackingURLContentRetriever {
    public static final String ILLEGAL_STATUS = "Illegal status";
    public static final String ILLEGAL_STATUS_CLEANUP = "Server returned status 503. Is cleanup in progress?";
    public static final String CONNECTION_REFUSED = "Connection refused";
    @NotNull
    private final HttpClient myClient;
    @NotNull
    private final String myServerUrl;
    private final int myMaxRedirects;
    private volatile boolean myIsInterrupted;
    private final AtomicReference<HttpMethod> myCurrentRequest;

    public HttpTransport(@NotNull HttpClient client, @NotNull String serverUrl) {
        if (client == null) {
            HttpTransport.$$$reportNull$$$0(0);
        }
        if (serverUrl == null) {
            HttpTransport.$$$reportNull$$$0(1);
        }
        this.myCurrentRequest = new AtomicReference();
        this.myClient = client;
        this.myServerUrl = serverUrl;
        this.myMaxRedirects = this.myClient.getParams().getIntParameter("http.protocol.max-redirects", 10);
    }

    @Nullable
    public String downloadUrlTo(@NotNull String srcUrl, @NotNull File target) throws IOException {
        if (srcUrl == null) {
            HttpTransport.$$$reportNull$$$0(2);
        }
        if (target == null) {
            HttpTransport.$$$reportNull$$$0(3);
        }
        return this.downloadUrlTo(srcUrl, target, (FileProgress)new FileProgress.Adapter());
    }

    /*
     * Loose catch block
     */
    @Nullable
    public String downloadUrlTo(@NotNull String srcUrl, @NotNull File target, @NotNull FileProgress fileDownloadProgress) throws IOException {
        GetMethod request;
        FileOutputStream writer;
        InputStream srcStream;
        block18: {
            block17: {
                if (srcUrl == null) {
                    HttpTransport.$$$reportNull$$$0(4);
                }
                if (target == null) {
                    HttpTransport.$$$reportNull$$$0(5);
                }
                if (fileDownloadProgress == null) {
                    HttpTransport.$$$reportNull$$$0(6);
                }
                if (this.myIsInterrupted) {
                    return null;
                }
                srcStream = null;
                writer = null;
                request = this.sendRequest(srcUrl, 0);
                if (!this.myIsInterrupted && request != null) break block17;
                String string = null;
                FileUtil.close(srcStream);
                FileUtil.close(writer);
                this.releaseConnection();
                return string;
            }
            try {
                srcStream = request.getResponseBodyAsStream();
            }
            catch (IOException e) {
                throw new IOException("Failed to download [" + srcUrl + "]: " + e.toString(), e);
            }
            long responseContentLength = request.getResponseContentLength();
            if (responseContentLength >= 0L) {
                fileDownloadProgress.setExpectedLength(responseContentLength);
            }
            try {
                target.getParentFile().mkdirs();
                target.createNewFile();
                writer = new FileOutputStream(target);
            }
            catch (IOException e) {
                throw new IOException("Error creating file '" + target.getAbsolutePath() + "': " + e.toString(), e);
            }
            long downloaded = HttpTransport.copyStreamContent(srcStream, writer, fileDownloadProgress);
            writer.flush();
            if (responseContentLength >= 0L && responseContentLength != downloaded && !TeamCityProperties.getBoolean((String)"teamcity.httpTransport.bypassResponseContentLengthCheck")) {
                throw new IOException("Expected content length doesn't match downloaded file size. Expected: " + responseContentLength + "; downloaded: " + downloaded);
            }
            if (!this.myIsInterrupted) break block18;
            String string = null;
            FileUtil.close((Closeable)srcStream);
            FileUtil.close((Closeable)writer);
            this.releaseConnection();
            return string;
        }
        String string = this.processMetaData((HttpMethod)request);
        FileUtil.close((Closeable)srcStream);
        FileUtil.close((Closeable)writer);
        this.releaseConnection();
        return string;
        {
            catch (IOException e) {
                try {
                    throw new IOException("Failed to download [" + srcUrl + "] into file '" + target.getAbsolutePath() + "': " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    FileUtil.close(srcStream);
                    FileUtil.close(writer);
                    this.releaseConnection();
                    throw throwable;
                }
            }
        }
    }

    public String getId() {
        return "HTTP transport";
    }

    private static long copyStreamContent(InputStream inputStream, OutputStream outputStream, FileProgress fileDownloadProgress) throws IOException {
        int count;
        byte[] buffer = new byte[10240];
        long total = 0L;
        while ((count = inputStream.read(buffer)) > 0) {
            total += (long)count;
            outputStream.write(buffer, 0, count);
            fileDownloadProgress.transferred((long)count);
        }
        return total;
    }

    private GetMethod sendRequest(@NotNull String srcUrl, int redirectLevel) throws IOException {
        int statusCode;
        if (srcUrl == null) {
            HttpTransport.$$$reportNull$$$0(7);
        }
        GetMethod request = new GetMethod(srcUrl);
        ((GetMethod)HttpUserAgent.addHeader((HttpMethod)request)).setFollowRedirects(false);
        this.myCurrentRequest.set((HttpMethod)request);
        int n = statusCode = srcUrl.startsWith(this.myServerUrl) ? this.myClient.executeMethod((HttpMethod)request) : this.myClient.executeMethod(null, (HttpMethod)request, new HttpState());
        if (this.isRedirectNeeded(statusCode)) {
            if (this.myIsInterrupted) {
                return null;
            }
            if (redirectLevel >= this.myMaxRedirects) {
                throw new RedirectException("Maximum redirects (" + this.myMaxRedirects + ") exceeded");
            }
            Header location = request.getResponseHeader("Location");
            if (location == null) {
                throw new IOException("Status code " + statusCode + " requires redirect, but no \"Location\" header provided");
            }
            this.releaseConnection();
            return this.sendRequest(this.getNormalizedRelativeLocation(request, location), redirectLevel + 1);
        }
        if (statusCode == 200) {
            return request;
        }
        if (statusCode == 503) {
            throw new RecoverableIOException("Server returned status 503. Is cleanup in progress? - url [" + srcUrl + ": " + request.getStatusText());
        }
        if (statusCode == 502) {
            throw new RecoverableIOException("Illegal status [" + statusCode + "] while downloading " + srcUrl + ": " + request.getStatusText());
        }
        throw new IOException("Illegal status [" + statusCode + "] while downloading " + srcUrl + ": " + request.getStatusText());
    }

    @NotNull
    private String getNormalizedRelativeLocation(@NotNull GetMethod request, @NotNull Header location) throws URIException {
        String locationValue;
        URI uri;
        if (request == null) {
            HttpTransport.$$$reportNull$$$0(8);
        }
        if (location == null) {
            HttpTransport.$$$reportNull$$$0(9);
        }
        if ((uri = new URI(locationValue = location.getValue(), true)).getHost() == null) {
            String string = request.getHostConfiguration().getHostURL() + (locationValue.startsWith("/") ? locationValue : "/" + locationValue);
            if (string == null) {
                HttpTransport.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = locationValue;
        if (string == null) {
            HttpTransport.$$$reportNull$$$0(11);
        }
        return string;
    }

    private boolean isRedirectNeeded(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getDigest(@NotNull String srcUrl) throws IOException {
        if (srcUrl == null) {
            HttpTransport.$$$reportNull$$$0(12);
        }
        HeadMethod getMethod = new HeadMethod(srcUrl);
        try {
            this.myClient.executeMethod((HttpMethod)getMethod);
            if (this.myIsInterrupted) {
                String string = null;
                return string;
            }
            String string = this.processMetaData((HttpMethod)getMethod);
            return string;
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    public void interrupt() {
        this.myIsInterrupted = true;
        HttpMethod currentRequest = this.myCurrentRequest.getAndSet(null);
        if (currentRequest != null) {
            currentRequest.abort();
        }
    }

    public void releaseConnection() {
        HttpMethod currentRequest = this.myCurrentRequest.getAndSet(null);
        if (currentRequest != null) {
            currentRequest.releaseConnection();
        }
    }

    @NotNull
    private String processMetaData(HttpMethod method) {
        Header etagHeader = method.getResponseHeader("Etag");
        if (etagHeader != null) {
            String val = etagHeader.getValue();
            if (val.startsWith("\"") && val.endsWith("\"") && val.length() > 2) {
                String string = val.substring(1, val.length() - 1);
                if (string == null) {
                    HttpTransport.$$$reportNull$$$0(13);
                }
                return string;
            }
            String string = etagHeader.getValue();
            if (string == null) {
                HttpTransport.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = StringUtil.join((String)"|", this.extractHeaders(method, "Last-Modified", "Content-Length"));
        if (string == null) {
            HttpTransport.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private List<String> extractHeaders(@NotNull HttpMethod method, String ... headers) {
        if (method == null) {
            HttpTransport.$$$reportNull$$$0(16);
        }
        if (headers == null) {
            HttpTransport.$$$reportNull$$$0(17);
        }
        ArrayList<String> values = new ArrayList<String>(headers.length);
        for (String headerName : headers) {
            Header header = method.getResponseHeader(headerName);
            values.add(header == null ? "" : header.getValue());
        }
        ArrayList<String> arrayList = values;
        if (arrayList == null) {
            HttpTransport.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverUrl";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcUrl";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDownloadProgress";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/impl/HttpTransport";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/impl/HttpTransport";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedRelativeLocation";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "processMetaData";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHeaders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "downloadUrlTo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sendRequest";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedRelativeLocation";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDigest";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractHeaders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

