/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import java.io.File;
import java.io.IOException;
import jetbrains.buildServer.artifacts.RecoverableIOException;
import jetbrains.buildServer.artifacts.ResolvingFailedException;
import jetbrains.buildServer.artifacts.URLContentRetriever;
import jetbrains.buildServer.artifacts.impl.ContentFetcher;
import jetbrains.buildServer.artifacts.impl.RecoverableResolvingException;
import jetbrains.buildServer.util.FileUtil;
import org.jetbrains.annotations.NotNull;

public class RecoverableContentFetcher
implements ContentFetcher {
    private final URLContentRetriever myTransport;

    public RecoverableContentFetcher(@NotNull URLContentRetriever transport) {
        if (transport == null) {
            RecoverableContentFetcher.$$$reportNull$$$0(0);
        }
        this.myTransport = transport;
    }

    @Override
    public void fetchContentToFile(@NotNull File destination, @NotNull String artifactUrl) throws ResolvingFailedException {
        if (destination == null) {
            RecoverableContentFetcher.$$$reportNull$$$0(1);
        }
        if (artifactUrl == null) {
            RecoverableContentFetcher.$$$reportNull$$$0(2);
        }
        try {
            this.myTransport.downloadUrlTo(artifactUrl, destination);
        }
        catch (IOException e) {
            FileUtil.delete((File)destination);
            throw this.wrapWithResolvingFailed(e);
        }
    }

    @Override
    public void interrupt() {
        this.myTransport.interrupt();
    }

    protected ResolvingFailedException wrapWithResolvingFailed(IOException e) {
        String message = e.getMessage();
        if (this.isRecoverable(e)) {
            return new RecoverableResolvingException(message, e);
        }
        return new ResolvingFailedException(message, (Throwable)e);
    }

    private boolean isRecoverable(IOException exception) {
        for (Throwable e = exception; e != null; e = e.getCause()) {
            if (e instanceof RecoverableIOException) {
                return true;
            }
            String message = e.getMessage();
            if (message == null) continue;
            if (message.startsWith("Connection refused")) {
                return false;
            }
            if (!e.getClass().getName().startsWith("java.net.") && !message.startsWith("Server returned status 503. Is cleanup in progress?")) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transport";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactUrl";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/artifacts/impl/RecoverableContentFetcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchContentToFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

