/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import com.intellij.openapi.util.Pair;
import gnu.trove.set.hash.TLongHashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import jetbrains.buildServer.ExtensionsProvider;
import jetbrains.buildServer.artifacts.ArtifactAccessor;
import jetbrains.buildServer.artifacts.ArtifactCacheProvider;
import jetbrains.buildServer.artifacts.ArtifactDependency;
import jetbrains.buildServer.artifacts.ArtifactDependencyTargetDirRestrictor;
import jetbrains.buildServer.artifacts.ArtifactStorageSettingsProvider;
import jetbrains.buildServer.artifacts.DependencyResolverListener;
import jetbrains.buildServer.artifacts.ResolvingFailedException;
import jetbrains.buildServer.artifacts.ResolvingInterruptedException;
import jetbrains.buildServer.artifacts.RevisionRule;
import jetbrains.buildServer.artifacts.impl.DependencyArchiveHelper;
import jetbrains.buildServer.artifacts.impl.DependencyResolverImpl;
import jetbrains.buildServer.artifacts.impl.DownloadedArtifactsImpl;
import jetbrains.buildServer.artifacts.impl.ResolverRuntimeConfiguration;
import jetbrains.buildServer.artifacts.impl.SourcePathAwareResolvingFailedException;
import jetbrains.buildServer.artifacts.impl.TransportFactoriesFacade;
import jetbrains.buildServer.artifacts.rules.ArtifactDepRuleSet;
import jetbrains.buildServer.artifacts.rules.ArtifactDependencyFileRule;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.vcs.FileRule;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleDependencyProcessor {
    private static final String ARCH_TMP_FILE_SUFFIX = "arch_temp";
    @NotNull
    private final DependencyResolverListener myListener;
    @NotNull
    private final ArtifactDependency myDep;
    @NotNull
    private final ResolverRuntimeConfiguration myConfig;
    @NotNull
    private final DependencyArchiveHelper myArchiveHelper;
    @NotNull
    private final ArtifactAccessor myArtifactAccessor;
    @NotNull
    private final ExtensionsProvider myExtensionsProvider;
    @NotNull
    private final CollisionsDetector myCollisionsDetector;
    private static final Logger log = Logger.getLogger(SingleDependencyProcessor.class);
    private volatile boolean myIsInterrupted;

    public SingleDependencyProcessor(@NotNull DependencyResolverListener listener, @NotNull ArtifactDependency dep, @NotNull ResolverRuntimeConfiguration config, @NotNull DependencyArchiveHelper dependencyArchiveHelper, @NotNull ExtensionsProvider extensionsProvider, @Nullable ArtifactCacheProvider cacheProvider, @NotNull ArtifactStorageSettingsProvider configProvider, @NotNull DownloadedArtifactsImpl downloadedArtifacts, @NotNull CollisionsDetector collisionsDetector) {
        if (listener == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(0);
        }
        if (dep == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(1);
        }
        if (config == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(2);
        }
        if (dependencyArchiveHelper == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(3);
        }
        if (extensionsProvider == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(4);
        }
        if (configProvider == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(5);
        }
        if (downloadedArtifacts == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(6);
        }
        if (collisionsDetector == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(7);
        }
        this.myListener = listener;
        this.myDep = dep;
        this.myConfig = config;
        this.myArchiveHelper = dependencyArchiveHelper;
        this.myExtensionsProvider = extensionsProvider;
        this.myArtifactAccessor = new TransportFactoriesFacade(extensionsProvider, config, cacheProvider, configProvider, downloadedArtifacts).getArtifactAccessor();
        this.myCollisionsDetector = collisionsDetector;
    }

    public void process() {
        this.initDestinationPath();
        this.checkIsInterrupted();
        String sourcePathRulesStr = this.myDep.getSourcePaths();
        ArtifactDepRuleSet sourcePathRules = new ArtifactDepRuleSet(sourcePathRulesStr);
        this.checkForIllegalRules(sourcePathRules);
        this.myListener.artifactPatternProcessingStarted(DependencyResolverImpl.describeDependency(this.myDep), sourcePathRulesStr);
        Collection<String> availableArtifactsMap = this.listAvailableArtifacts(this.myDep);
        Map<String, ArtifactTargets> matchedPathsMap = this.selectMatchingArtifacts(sourcePathRules, availableArtifactsMap);
        this.checkAllRequiredPathsMatched(sourcePathRules, matchedPathsMap);
        this.checkIsInterrupted();
        int filesCount = this.downloadArtifacts(matchedPathsMap);
        this.myListener.artifactPatternProcessed(DependencyResolverImpl.describeDependency(this.myDep), sourcePathRulesStr, filesCount);
    }

    private void checkForIllegalRules(@NotNull ArtifactDepRuleSet sourcePathRules) throws SourcePathAwareResolvingFailedException {
        if (sourcePathRules == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(8);
        }
        HashMap<String, String> res = new HashMap<String, String>();
        for (ArtifactDependencyFileRule rule : sourcePathRules.getIncludeRules()) {
            File targetFile = new File(rule.getTo());
            try {
                String to = (targetFile.isAbsolute() ? targetFile : new File(this.myConfig.getWorkingDir(), rule.getTo())).getCanonicalPath();
                for (ArtifactDependencyTargetDirRestrictor restrictor : this.myExtensionsProvider.getExtensions(ArtifactDependencyTargetDirRestrictor.class)) {
                    String restricted = restrictor.tryGetRestrictedReason(this.myConfig, to);
                    if (restricted == null) continue;
                    res.put(rule.toString(), restricted);
                }
            }
            catch (IOException e) {
                res.put(rule.toString(), "Cannot download artifacts: " + e.getMessage());
            }
        }
        if (!res.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String reason : new HashSet(res.values())) {
                sb.append(reason).append("; ");
            }
            throw new SourcePathAwareResolvingFailedException(sb.substring(0, sb.length() - 2), new ArrayList<String>(res.keySet()));
        }
    }

    @NotNull
    private Map<String, ArtifactTargets> selectMatchingArtifacts(ArtifactDepRuleSet sourcePathRules, Collection<String> sourcePaths) {
        Map<String, ArtifactTargets> matchedPathsMap;
        Map<String, ArtifactTargets> map = matchedPathsMap = this.getMatchingPaths(sourcePathRules, sourcePaths);
        if (map == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(9);
        }
        return map;
    }

    private int downloadArtifacts(Map<String, ArtifactTargets> matchedPathsMap) {
        int filesCount = 0;
        Map<String, File> sourceToFile = this.createSourceToFileMap(matchedPathsMap);
        this.checkIsInterrupted();
        this.myListener.artifactDownloadStarted(this.myDep, sourceToFile);
        this.myArtifactAccessor.downloadArtifacts(this.myDep.getSourceExternalId(), this.myDep.getRevisionRule().getRevision(), this.myDep.getRevisionRule().getBranch(), sourceToFile);
        this.copyFilesIfNeeded(sourceToFile, matchedPathsMap);
        for (Map.Entry<String, ArtifactTargets> entry : matchedPathsMap.entrySet()) {
            filesCount += this.processArtifact(entry.getKey(), entry.getValue());
        }
        return filesCount;
    }

    private void copyFilesIfNeeded(Map<String, File> sourceToFile, Map<String, ArtifactTargets> sourceToTargetsMap) {
        for (Map.Entry<String, File> entry : sourceToFile.entrySet()) {
            File downloadedFile = entry.getValue();
            ArtifactTargets targets = sourceToTargetsMap.get(entry.getKey());
            if (targets == null || targets.getTargetFiles().size() <= 1) continue;
            for (File file : targets.getTargetFiles()) {
                if (file.equals(downloadedFile)) continue;
                try {
                    FileUtil.copy((File)downloadedFile, (File)file);
                }
                catch (IOException e) {
                    throw new SourcePathAwareResolvingFailedException("Failed to copy file to [" + file.getAbsolutePath() + "]", (Throwable)e, entry.getKey());
                }
            }
        }
    }

    @NotNull
    private Map<String, File> createSourceToFileMap(Map<String, ArtifactTargets> sourceToTargetsMap) {
        HashMap<String, File> result = new HashMap<String, File>(sourceToTargetsMap.size());
        for (Map.Entry<String, ArtifactTargets> entry : sourceToTargetsMap.entrySet()) {
            ArtifactTargets artifactTargets = entry.getValue();
            List<File> targetFiles = artifactTargets.getTargetFiles();
            if (targetFiles.size() == 0 && artifactTargets.getArchiveRuleSet() != null) {
                try {
                    targetFiles.add(File.createTempFile("dep", ARCH_TMP_FILE_SUFFIX));
                }
                catch (IOException e) {
                    throw new SourcePathAwareResolvingFailedException("failed to create temp file to unpack dependency " + DependencyResolverImpl.describeDependency(this.myDep), e.getCause(), entry.getKey());
                }
            }
            if (targetFiles.size() <= 0) continue;
            result.put(entry.getKey(), targetFiles.get(0));
        }
        HashMap<String, File> hashMap = result;
        if (hashMap == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    private void checkAllRequiredPathsMatched(@NotNull ArtifactDepRuleSet sourcePathRules, @NotNull Map<String, ArtifactTargets> matchedPathsMap) {
        ArrayList<String> matchedPaths;
        List<String> unsatisfiedPatterns;
        if (sourcePathRules == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(11);
        }
        if (matchedPathsMap == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(12);
        }
        if ((unsatisfiedPatterns = this.findUnsatisfiedPatterns(sourcePathRules, matchedPaths = new ArrayList<String>(matchedPathsMap.keySet()))).size() > 0) {
            throw new SourcePathAwareResolvingFailedException("No files matched for patterns \"" + StringUtil.join((String)",", unsatisfiedPatterns) + "\" from " + DependencyResolverImpl.describeDependency(this.myDep), unsatisfiedPatterns);
        }
    }

    @NotNull
    private Map<String, ArtifactTargets> getMatchingPaths(@NotNull ArtifactDepRuleSet sourcePathRules, @NotNull Collection<String> availablePaths) {
        if (sourcePathRules == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(13);
        }
        if (availablePaths == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(14);
        }
        LinkedHashMap<String, ArtifactTargets> result = new LinkedHashMap<String, ArtifactTargets>();
        for (String candidate : availablePaths) {
            String escapedCandidate = candidate.replace('\\', '/');
            if (!sourcePathRules.shouldInclude(escapedCandidate)) continue;
            List<String> targetPaths = sourcePathRules.getTargetPath(escapedCandidate);
            ArtifactDepRuleSet archiveRuleSet = sourcePathRules.findArchiveRuleSet(escapedCandidate);
            result.put(candidate, new ArtifactTargets(targetPaths, archiveRuleSet, this.myConfig.getWorkingDir()));
        }
        LinkedHashMap<String, ArtifactTargets> linkedHashMap = result;
        if (linkedHashMap == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(15);
        }
        return linkedHashMap;
    }

    private void initDestinationPath() {
        try {
            ArtifactDepRuleSet artifactRules = new ArtifactDepRuleSet(this.myDep.getSourcePaths());
            for (String target : artifactRules.getTargetPaths()) {
                File destPath = FileUtil.resolvePath((File)this.myConfig.getWorkingDir(), (String)target);
                FileUtil.createDir((File)destPath);
            }
        }
        catch (IOException e) {
            throw new ResolvingFailedException("Failed to create destination: " + e.getMessage(), (Throwable)e);
        }
    }

    private int processArtifact(@NotNull String artifactSourcePath, @NotNull ArtifactTargets artifactTargets) {
        int filesCount;
        block23: {
            if (artifactSourcePath == null) {
                SingleDependencyProcessor.$$$reportNull$$$0(16);
            }
            if (artifactTargets == null) {
                SingleDependencyProcessor.$$$reportNull$$$0(17);
            }
            List<File> targetFiles = artifactTargets.getTargetFiles();
            ArtifactDepRuleSet archiveRuleSet = artifactTargets.getArchiveRuleSet();
            filesCount = 0;
            if (targetFiles.size() == 0 && archiveRuleSet == null) {
                log.debug((Object)("No target paths for [" + artifactSourcePath + "] included using pattern [" + this.myDep.getSourcePaths() + "]"));
                return filesCount;
            }
            if (targetFiles.size() > 0) {
                this.checkCollisionsInUnpackedTargetFiles(artifactSourcePath, targetFiles);
                ++filesCount;
            }
            if (archiveRuleSet != null) {
                File archive = null;
                try (PersistentCollisionsWriter persistentCollisionsWriter = this.myCollisionsDetector.openUnpack(artifactSourcePath);){
                    archive = targetFiles.get(0);
                    this.checkIsInterrupted();
                    HashSet<ArtifactDependencyFileRule<ArtifactDepRuleSet>> unsatisfiedRules = new HashSet<ArtifactDependencyFileRule<ArtifactDepRuleSet>>(archiveRuleSet.getIncludeRules());
                    AtomicInteger unpackedFilesCount = new AtomicInteger();
                    AtomicInteger collisionsDetectedCount = new AtomicInteger();
                    this.myArchiveHelper.unpackArchiveWithPattern(archive, this.myConfig.getWorkingDir(), archiveRuleSet, (archiveEntryName, target) -> this.processUnpackedFile(artifactSourcePath, persistentCollisionsWriter, (Set<ArtifactDependencyFileRule<ArtifactDepRuleSet>>)unsatisfiedRules, unpackedFilesCount, (String)archiveEntryName, (File)target), (archiveEntryName, existingFile) -> this.processPotentialCollision(artifactSourcePath, collisionsDetectedCount, (String)archiveEntryName, (File)existingFile));
                    this.failIfPatternsUnsatisfied(artifactSourcePath, unsatisfiedRules);
                    filesCount += unpackedFilesCount.get();
                    this.myListener.artifactDownloadedAndUnpacked(this.myDep, artifactSourcePath, StringUtil.join((String)",", artifactTargets.getRelativePaths()), unpackedFilesCount.get());
                    break block23;
                }
                catch (IOException e) {
                    String message = e.getClass().getName() + " while unpacking archive " + artifactSourcePath + ": " + e.toString();
                    throw new SourcePathAwareResolvingFailedException(message, (Throwable)e, artifactSourcePath);
                }
                finally {
                    if (archive != null && archive.getName().endsWith(ARCH_TMP_FILE_SUFFIX)) {
                        FileUtil.delete((File)archive);
                    }
                }
            }
            this.myListener.artifactDownloaded(this.myDep, artifactSourcePath, StringUtil.join((String)",", artifactTargets.getRelativePaths()));
        }
        return filesCount;
    }

    private void failIfPatternsUnsatisfied(@NotNull String artifactSourcePath, Set<ArtifactDependencyFileRule<ArtifactDepRuleSet>> unsatisfiedRules) {
        List unsatisfiedArchivePatterns;
        if (artifactSourcePath == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(18);
        }
        if ((unsatisfiedArchivePatterns = CollectionsUtil.convertCollection(unsatisfiedRules, FileRule::getFrom)).size() > 0) {
            String message = "No files matched for extraction patterns [" + StringUtil.join((String)", ", (Iterable)unsatisfiedArchivePatterns) + "] while unpacking [" + artifactSourcePath + "] from " + DependencyResolverImpl.describeDependency(this.myDep);
            throw new SourcePathAwareResolvingFailedException(message, unsatisfiedArchivePatterns);
        }
    }

    private void processPotentialCollision(@NotNull String artifactSourcePath, AtomicInteger collisionsDetectedCount, String archiveEntryName, File existingFile) {
        String relativeCollision;
        if (artifactSourcePath == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(19);
        }
        if (!this.myCollisionsDetector.canContainCollision(relativeCollision = this.relativizeCollision(existingFile))) {
            return;
        }
        if (collisionsDetectedCount.get() > TeamCityProperties.getInteger((String)"teamcity.agent.maxAccuratelyDetectedCollisionsCount", (int)10)) {
            this.myListener.artifactDestinationCollision(relativeCollision, Collections.singletonList("possible collision in " + archiveEntryName + "!" + archiveEntryName + " (too many collisions detected)"));
        } else {
            collisionsDetectedCount.incrementAndGet();
            Pair<String, String> collision = this.myCollisionsDetector.findCollision(this.relativizeCollision(existingFile));
            if (collision != null) {
                this.myListener.artifactDestinationCollision((String)collision.second, Arrays.asList((String)collision.first, artifactSourcePath + "!" + archiveEntryName));
            }
        }
    }

    private void processUnpackedFile(@NotNull String artifactSourcePath, PersistentCollisionsWriter persistentCollisionsWriter, Set<ArtifactDependencyFileRule<ArtifactDepRuleSet>> unsatisfiedRules, AtomicInteger unpackedFilesCount, String archiveEntryName, File target) {
        if (artifactSourcePath == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(20);
        }
        unsatisfiedRules.removeIf(artifactDepRuleSetArtifactDependencyFileRule -> artifactDepRuleSetArtifactDependencyFileRule.getMatchedHead(archiveEntryName) != null);
        persistentCollisionsWriter.markUnpacked(artifactSourcePath + "!" + archiveEntryName, this.relativizeCollision(target));
        unpackedFilesCount.incrementAndGet();
    }

    private void checkCollisionsInUnpackedTargetFiles(@NotNull String artifactSourcePath, List<File> targetFiles) {
        if (artifactSourcePath == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(21);
        }
        for (File targetFile : targetFiles) {
            Pair<String, String> collision = this.myCollisionsDetector.findCollisionNonArchived(this.relativizeCollision(targetFile));
            if (collision != null) {
                this.myListener.artifactDestinationCollision((String)collision.second, Arrays.asList((String)collision.first, artifactSourcePath));
            }
            this.myCollisionsDetector.markCopied(artifactSourcePath, this.relativizeCollision(targetFile));
        }
    }

    private String relativizeCollision(@NotNull File destination) {
        File workingDir;
        String relativePath;
        if (destination == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(22);
        }
        if (destination.isAbsolute() && (relativePath = FileUtil.getRelativePath((File)(workingDir = this.myConfig.getWorkingDir()), (File)destination)) != null) {
            return relativePath;
        }
        return destination.getPath();
    }

    @NotNull
    private List<String> findUnsatisfiedPatterns(ArtifactDepRuleSet ruleSet, Collection<String> paths) {
        HashSet<ArtifactDependencyFileRule> unsatisfiedRules = new HashSet<ArtifactDependencyFileRule>(ruleSet.getIncludeRules());
        for (String path : paths) {
            unsatisfiedRules.removeIf(artifactDepRuleSetArtifactDependencyFileRule -> artifactDepRuleSetArtifactDependencyFileRule.getMatchedHead(path) != null);
        }
        List list = CollectionsUtil.convertCollection(unsatisfiedRules, FileRule::getFrom);
        if (list == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(23);
        }
        return list;
    }

    public void interrupt() {
        this.myIsInterrupted = true;
        this.myArtifactAccessor.interrupt();
    }

    private void checkIsInterrupted() {
        if (this.myIsInterrupted) {
            throw new ResolvingInterruptedException();
        }
    }

    @NotNull
    private Collection<String> listAvailableArtifacts(@NotNull ArtifactDependency dependency) {
        if (dependency == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(24);
        }
        List<String> result = Collections.emptyList();
        try {
            RevisionRule revRule = dependency.getRevisionRule();
            Collection<String> sourcePathList = this.myArtifactAccessor.getArtifactSourcePathList(dependency.getSourceExternalId(), revRule.getRevision(), revRule.getBranch());
            if (!sourcePathList.isEmpty()) {
                result = sourcePathList;
            }
        }
        catch (RuntimeException e) {
            Loggers.AGENT.infoAndDebugDetails("Skipping artifacts list from [" + this.myArtifactAccessor.getClass().getName() + "]: " + e.getMessage(), (Throwable)e);
            if (e instanceof ResolvingFailedException) {
                throw e;
            }
            throw new ResolvingFailedException("Failed to get source paths list for " + dependency.getSourceName(), (Throwable)e);
        }
        List<String> list = result;
        if (list == null) {
            SingleDependencyProcessor.$$$reportNull$$$0(25);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dep";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyArchiveHelper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadedArtifacts";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collisionsDetector";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePathRules";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/impl/SingleDependencyProcessor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedPathsMap";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availablePaths";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactSourcePath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactTargets";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/impl/SingleDependencyProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "selectMatchingArtifacts";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createSourceToFileMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingPaths";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findUnsatisfiedPatterns";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "listAvailableArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkForIllegalRules";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 23: 
            case 25: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkAllRequiredPathsMatched";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingPaths";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processArtifact";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "failIfPatternsUnsatisfied";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processPotentialCollision";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processUnpackedFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkCollisionsInUnpackedTargetFiles";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "relativizeCollision";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "listAvailableArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FilePersistentCollisionsWriter
    implements PersistentCollisionsWriter {
        @Nullable
        private BufferedWriter myFileWriter;
        private boolean myErrorOccurred;
        @NotNull
        private final CollisionsDetector myCollisionsDetector;
        private final Path myFile;

        public FilePersistentCollisionsWriter(@NotNull Path file, @NotNull CollisionsDetector collisionsDetector) {
            if (file == null) {
                FilePersistentCollisionsWriter.$$$reportNull$$$0(0);
            }
            if (collisionsDetector == null) {
                FilePersistentCollisionsWriter.$$$reportNull$$$0(1);
            }
            this.myFileWriter = null;
            this.myErrorOccurred = false;
            this.myFile = file;
            this.myCollisionsDetector = collisionsDetector;
        }

        @Override
        public void markUnpacked(@NotNull String source, @NotNull String relativeCollision) {
            if (source == null) {
                FilePersistentCollisionsWriter.$$$reportNull$$$0(2);
            }
            if (relativeCollision == null) {
                FilePersistentCollisionsWriter.$$$reportNull$$$0(3);
            }
            if (this.myErrorOccurred) {
                return;
            }
            if (this.myFileWriter == null) {
                try {
                    Files.createDirectories(this.myFile.getParent(), new FileAttribute[0]);
                    this.myFileWriter = Files.newBufferedWriter(this.myFile, new OpenOption[0]);
                    return;
                }
                catch (IOException e) {
                    this.myErrorOccurred = true;
                    log.warn((Object)("Exception occured when saving collisions map for '" + relativeCollision + "' in '" + this.myFile + "'"));
                    log.debug((Object)e.getMessage(), (Throwable)e);
                    return;
                }
            }
            try {
                this.myFileWriter.write(this.myCollisionsDetector.composeLine(source, relativeCollision));
                this.myFileWriter.write("\n");
            }
            catch (IOException e) {
                log.warn((Object)("Exception occured when saving collisions map for '" + relativeCollision + "' in '" + this.myFile + "'"));
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.myFileWriter != null) {
                this.myFileWriter.close();
            }
            this.myCollisionsDetector.myCurrentlyOpenedSource = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collisionsDetector";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativeCollision";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/artifacts/impl/SingleDependencyProcessor$FilePersistentCollisionsWriter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markUnpacked";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class InMemoryCachePersistentCollisionsWriter
    implements PersistentCollisionsWriter {
        @NotNull
        private final Map<String, String> mySharedCollisionsMap;
        @NotNull
        private final PersistentCollisionsWriter myDelegate;
        @NotNull
        private final TLongHashSet myCollisionCandidateStorage;

        public InMemoryCachePersistentCollisionsWriter(@NotNull Map<String, String> sharedCollisionsMap, @NotNull PersistentCollisionsWriter delegate, @NotNull TLongHashSet collisionCandidateStorage) {
            if (sharedCollisionsMap == null) {
                InMemoryCachePersistentCollisionsWriter.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                InMemoryCachePersistentCollisionsWriter.$$$reportNull$$$0(1);
            }
            if (collisionCandidateStorage == null) {
                InMemoryCachePersistentCollisionsWriter.$$$reportNull$$$0(2);
            }
            this.mySharedCollisionsMap = sharedCollisionsMap;
            this.myDelegate = delegate;
            this.myCollisionCandidateStorage = collisionCandidateStorage;
        }

        @Override
        public void markUnpacked(@NotNull String source, @NotNull String relativeCollision) {
            if (source == null) {
                InMemoryCachePersistentCollisionsWriter.$$$reportNull$$$0(3);
            }
            if (relativeCollision == null) {
                InMemoryCachePersistentCollisionsWriter.$$$reportNull$$$0(4);
            }
            this.myCollisionCandidateStorage.add((long)relativeCollision.hashCode());
            if ((long)this.mySharedCollisionsMap.size() < TeamCityProperties.getLong((String)"teamcity.agent.maxInMemoryCollisionMapSize", (long)50000L)) {
                this.mySharedCollisionsMap.put(relativeCollision, source);
            } else {
                this.myDelegate.markUnpacked(source, relativeCollision);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.myDelegate.close();
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw e;
                }
                throw new IOException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sharedCollisionsMap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collisionCandidateStorage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativeCollision";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/artifacts/impl/SingleDependencyProcessor$InMemoryCachePersistentCollisionsWriter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markUnpacked";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface PersistentCollisionsWriter
    extends AutoCloseable {
        public void markUnpacked(@NotNull String var1, @NotNull String var2);

        @Override
        public void close() throws IOException;
    }

    public static class CollisionsDetector
    implements AutoCloseable {
        @NotNull
        private final Path myTempDirectoryPath;
        @Nullable
        private String myCurrentlyOpenedSource;
        @NotNull
        private final Map<String, String> mySharedCollisionsMap;
        @NotNull
        private final Map<String, String> mySourceDumpsMapping;
        @NotNull
        private final TLongHashSet myCollisionCandidateStorage;

        public CollisionsDetector(@NotNull String tempDir) {
            if (tempDir == null) {
                CollisionsDetector.$$$reportNull$$$0(0);
            }
            this.myCurrentlyOpenedSource = null;
            this.mySharedCollisionsMap = new HashMap<String, String>();
            this.mySourceDumpsMapping = new HashMap<String, String>();
            this.myCollisionCandidateStorage = new TLongHashSet();
            this.myTempDirectoryPath = new File(tempDir).toPath().resolve("collisions");
        }

        public PersistentCollisionsWriter openUnpack(@NotNull String source) {
            if (source == null) {
                CollisionsDetector.$$$reportNull$$$0(1);
            }
            this.myCurrentlyOpenedSource = this.mySourceDumpsMapping.computeIfAbsent(source, k -> UUID.randomUUID().toString());
            return new InMemoryCachePersistentCollisionsWriter(this.mySharedCollisionsMap, new FilePersistentCollisionsWriter(this.myTempDirectoryPath.resolve(this.myCurrentlyOpenedSource), this), this.myCollisionCandidateStorage);
        }

        public void markCopied(@NotNull String source, @NotNull String relativeLocation) {
            if (source == null) {
                CollisionsDetector.$$$reportNull$$$0(2);
            }
            if (relativeLocation == null) {
                CollisionsDetector.$$$reportNull$$$0(3);
            }
            this.mySharedCollisionsMap.put(relativeLocation, source);
        }

        public boolean canContainCollision(@NotNull String relativeCollision) {
            if (relativeCollision == null) {
                CollisionsDetector.$$$reportNull$$$0(4);
            }
            return this.myCollisionCandidateStorage.contains((long)relativeCollision.hashCode());
        }

        @Nullable
        public Pair<String, String> findCollisionNonArchived(@NotNull String relativeCollision) {
            String cachedCollisionSource;
            if (relativeCollision == null) {
                CollisionsDetector.$$$reportNull$$$0(5);
            }
            if ((cachedCollisionSource = this.mySharedCollisionsMap.get(relativeCollision)) != null) {
                return Pair.create((Object)cachedCollisionSource, (Object)relativeCollision);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        public Pair<String, String> findCollision(@NotNull String relativeCollision) {
            Pair<String, String> collisionNonArchived;
            if (relativeCollision == null) {
                CollisionsDetector.$$$reportNull$$$0(6);
            }
            if ((collisionNonArchived = this.findCollisionNonArchived(relativeCollision)) != null) {
                return collisionNonArchived;
            }
            if (!Files.exists(this.myTempDirectoryPath, new LinkOption[0])) {
                return null;
            }
            try (Stream<Path> walk = Files.walk(this.myTempDirectoryPath, new FileVisitOption[0]);){
                Pair pair = walk.filter(p -> !p.equals(this.myTempDirectoryPath) && (this.myCurrentlyOpenedSource == null || !p.endsWith(this.myCurrentlyOpenedSource))).map(p -> {
                    try (Stream<String> lines = Files.lines(p);){
                        Pair pair = lines.filter(s -> s.startsWith(relativeCollision)).findFirst().map(this::parse).orElse(null);
                        return pair;
                    }
                    catch (IOException e) {
                        log.warn((Object)("Exception occured when checking possible collision '" + relativeCollision + "' in '" + p + "'"));
                        log.debug((Object)e.getMessage(), (Throwable)e);
                        return null;
                    }
                }).filter(Objects::nonNull).findFirst().orElse(null);
                return pair;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String composeLine(@NotNull String source, @NotNull String target) {
            if (source == null) {
                CollisionsDetector.$$$reportNull$$$0(7);
            }
            if (target == null) {
                CollisionsDetector.$$$reportNull$$$0(8);
            }
            return target + " => " + source;
        }

        @Nullable
        private Pair<String, String> parse(@NotNull String line) {
            String[] split;
            if (line == null) {
                CollisionsDetector.$$$reportNull$$$0(9);
            }
            if ((split = line.split(" => ")).length == 2) {
                return Pair.create((Object)split[1], (Object)split[0]);
            }
            return null;
        }

        @Override
        public void close() {
            try {
                Files.walkFileTree(this.myTempDirectoryPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.TERMINATE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
                Files.delete(this.myTempDirectoryPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tempDir";
                    break;
                }
                case 1: 
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativeLocation";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relativeCollision";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/artifacts/impl/SingleDependencyProcessor$CollisionsDetector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "openUnpack";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markCopied";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canContainCollision";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findCollisionNonArchived";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findCollision";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "composeLine";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ArtifactTargets {
        private final Collection<String> myArtifactTargetPaths;
        private final ArtifactDepRuleSet myArchiveRuleSet;
        private List<File> myTargetFiles;
        private String myAllDestinationsString;

        public ArtifactTargets(@NotNull Collection<String> artifactTargetPaths, @Nullable ArtifactDepRuleSet archiveRuleSet, @NotNull File baseDir) {
            if (artifactTargetPaths == null) {
                ArtifactTargets.$$$reportNull$$$0(0);
            }
            if (baseDir == null) {
                ArtifactTargets.$$$reportNull$$$0(1);
            }
            this.myArtifactTargetPaths = artifactTargetPaths;
            this.myArchiveRuleSet = archiveRuleSet;
            this.build(baseDir);
        }

        @NotNull
        public Collection<String> getRelativePaths() {
            Collection<String> collection = this.myArtifactTargetPaths;
            if (collection == null) {
                ArtifactTargets.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        public List<File> getTargetFiles() {
            List<File> list = this.myTargetFiles;
            if (list == null) {
                ArtifactTargets.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public String getFullDestinationPaths() {
            String string = this.myAllDestinationsString;
            if (string == null) {
                ArtifactTargets.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public ArtifactDepRuleSet getArchiveRuleSet() {
            return this.myArchiveRuleSet;
        }

        private void build(File baseDir) {
            HashSet<File> files = new HashSet<File>();
            StringBuilder allDestinations = new StringBuilder();
            for (String targetPath : this.myArtifactTargetPaths) {
                File file = new File(targetPath);
                File targetFile = file.isAbsolute() ? file : new File(baseDir, targetPath);
                files.add(targetFile);
                allDestinations.append(targetFile.getAbsolutePath()).append("; ");
            }
            this.myTargetFiles = new ArrayList<File>(files);
            this.myAllDestinationsString = allDestinations.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactTargetPaths";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseDir";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/artifacts/impl/SingleDependencyProcessor$ArtifactTargets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/artifacts/impl/SingleDependencyProcessor$ArtifactTargets";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePaths";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetFiles";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullDestinationPaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

