/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourcePathParser {
    public static final String ARCHIVE_PART_DELIMITER = "!";
    @NotNull
    private final String myArtifactPath;
    private String myArchivePath;

    public SourcePathParser(String path) {
        path = path.replace('\\', '/');
        if (path.contains(ARCHIVE_PART_DELIMITER)) {
            int ind = path.indexOf(ARCHIVE_PART_DELIMITER);
            this.myArtifactPath = path.substring(0, ind);
            this.myArchivePath = path.substring(ind + 1);
            if (this.myArchivePath.startsWith("/")) {
                this.myArchivePath = this.myArchivePath.substring(1);
            }
        } else {
            this.myArtifactPath = path;
            this.myArchivePath = null;
        }
    }

    @NotNull
    public String getArtifactPath() {
        String string = this.myArtifactPath;
        if (string == null) {
            SourcePathParser.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public String getArchivePath() {
        return this.myArchivePath;
    }

    @Nullable
    public String getArchivePathNonWildcard() {
        if (this.myArchivePath == null || SourcePathParser.getWildcardIndex(this.myArchivePath) < 0) {
            return null;
        }
        return this.getPathNonWildcard(this.myArchivePath);
    }

    public static int getWildcardIndex(String s) {
        int qIndex = s.indexOf("?");
        if (qIndex < 0) {
            return s.indexOf("*");
        }
        int globIndex = s.indexOf("*");
        if (globIndex < 0) {
            return qIndex;
        }
        return Math.min(qIndex, globIndex);
    }

    public boolean hasArchivePath() {
        return this.myArchivePath != null;
    }

    public String getOriginalPath() {
        if (this.myArchivePath != null) {
            return this.myArtifactPath + ARCHIVE_PART_DELIMITER + this.myArchivePath;
        }
        return this.myArtifactPath;
    }

    public String trimBaseDir(String relativePath) {
        String base = this.getPathNonWildcard(this.myArtifactPath);
        if (!relativePath.startsWith(base + "/")) {
            return relativePath;
        }
        return StringUtil.removeLeadingSlash((String)relativePath.substring(base.length()));
    }

    @NotNull
    private String getPathNonWildcard(String result) {
        int lastSeparator;
        int wildcardIndex = SourcePathParser.getWildcardIndex(result);
        if (wildcardIndex >= 0) {
            result = result.substring(0, wildcardIndex);
        }
        if ((lastSeparator = result.lastIndexOf("/")) < 0) {
            if ("" == null) {
                SourcePathParser.$$$reportNull$$$0(1);
            }
            return "";
        }
        String string = result.substring(0, lastSeparator);
        if (string == null) {
            SourcePathParser.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String toString() {
        return this.getOriginalPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "jetbrains/buildServer/artifacts/impl/SourcePathParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactPath";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathNonWildcard";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

