/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jetbrains.buildServer.artifacts.ArtifactAccessor;
import jetbrains.buildServer.artifacts.ResolvingFailedException;
import jetbrains.buildServer.artifacts.URLContentRetriever;
import jetbrains.buildServer.artifacts.impl.ContentFetcher;
import jetbrains.buildServer.artifacts.impl.DownloadedArtifacts;
import jetbrains.buildServer.artifacts.impl.RecoverableContentFetcher;
import jetbrains.buildServer.artifacts.impl.RecoverableResolvingException;
import jetbrains.buildServer.artifacts.impl.SourcePathAwareResolvingFailedException;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TeamCityArtifactAccessor
implements ArtifactAccessor {
    private static final String ARTEFACT_URL_TEMPLATE = "[URL]/httpAuth/repository/download/[module]/[revision]/[artifact](.[ext])";
    private static final String TEAMCITY_IVY_XML = "teamcity-ivy.xml";
    private final ContentFetcher myContentFetcher;
    @NotNull
    private final DownloadedArtifacts myDownloadedArtifacts;
    @NotNull
    private final String myServerUrl;

    public TeamCityArtifactAccessor(@NotNull URLContentRetriever retriever, @NotNull String serverUrl) {
        if (retriever == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(0);
        }
        if (serverUrl == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(1);
        }
        this.myContentFetcher = new RecoverableContentFetcher(retriever);
        this.myDownloadedArtifacts = new DownloadedArtifacts.DisabledTracker();
        this.myServerUrl = serverUrl;
    }

    public TeamCityArtifactAccessor(@NotNull URLContentRetriever retriever, @NotNull DownloadedArtifacts downloadedArtifacts, @NotNull String serverUrl) {
        if (retriever == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(2);
        }
        if (downloadedArtifacts == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(3);
        }
        if (serverUrl == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(4);
        }
        this.myContentFetcher = new RecoverableContentFetcher(retriever);
        this.myDownloadedArtifacts = downloadedArtifacts;
        this.myServerUrl = serverUrl;
    }

    public static String getArtifactUrlFromTemplate(@NotNull String baseURL, @NotNull String sourceExternalId, @NotNull String revision, @NotNull String sourcePath) {
        if (baseURL == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(5);
        }
        if (sourceExternalId == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(6);
        }
        if (revision == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(7);
        }
        if (sourcePath == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(8);
        }
        String filledUrl = StringUtil.replace((String)ARTEFACT_URL_TEMPLATE, (String)"[URL]", (String)baseURL);
        String filledModule = StringUtil.replace((String)filledUrl, (String)"[module]", (String)TeamCityArtifactAccessor.urlEncodeParameter(sourceExternalId));
        String filledRevision = StringUtil.replace((String)filledModule, (String)"[revision]", (String)revision);
        return StringUtil.replace((String)filledRevision, (String)"[artifact](.[ext])", (String)TeamCityArtifactAccessor.urlEncodePath(sourcePath));
    }

    @NotNull
    private static String urlEncodePath(String path) {
        String[] parts;
        StringBuffer buffer = new StringBuffer();
        for (String part : parts = path.split("/|\\\\")) {
            buffer.append(TeamCityArtifactAccessor.urlEncodeParameter(part)).append("/");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        String string = buffer.toString();
        if (string == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String urlEncodeParameter(@NotNull String url) {
        if (url == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(10);
        }
        String string = StringUtil.encodeURLParameter((String)url).replace("+", "%2B");
        if (string == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getArtifactUrl(String sourceExternalId, @NotNull String revision, @Nullable String branch, @NotNull String sourcePath) {
        if (revision == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(12);
        }
        if (sourcePath == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(13);
        }
        String url = TeamCityArtifactAccessor.getArtifactUrlFromTemplate(this.myServerUrl, sourceExternalId, revision, sourcePath);
        if (branch != null) {
            url = url + "?branch=" + TeamCityArtifactAccessor.urlEncodeParameter(branch);
        }
        String string = url;
        if (string == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(14);
        }
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Collection<String> getArtifactSourcePathList(@NotNull String sourceExternalId, @NotNull String revision, @Nullable String branchName) {
        if (sourceExternalId == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(15);
        }
        if (revision == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(16);
        }
        this.myDownloadedArtifacts.setPaused(true);
        TreeSet<String> result = new TreeSet<String>();
        FileInputStream artifactListStream = null;
        File artifactListFile = null;
        try {
            artifactListFile = FileUtil.createTempFile((String)"artifactList", (String)"");
            artifactListStream = new FileInputStream(artifactListFile);
            String artifactUrl = this.getArtifactUrl(sourceExternalId, revision, branchName, TEAMCITY_IVY_XML);
            this.myContentFetcher.fetchContentToFile(artifactListFile, artifactUrl);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList artifactList = (NodeList)xpath.evaluate("/ivy-module/publications/artifact", new InputSource(artifactListStream), XPathConstants.NODESET);
            for (int i = 0; i < artifactList.getLength(); ++i) {
                Node artifact = artifactList.item(i);
                String artifactName = artifact.getAttributes().getNamedItem("name").getTextContent();
                String artifactExt = artifact.getAttributes().getNamedItem("ext").getTextContent();
                if (!StringUtil.isEmpty((String)artifactExt)) {
                    result.add(artifactName + "." + artifactExt);
                    continue;
                }
                result.add(artifactName);
            }
            this.myDownloadedArtifacts.setPaused(false);
        }
        catch (IOException e) {
            try {
                String string;
                StringBuilder stringBuilder = new StringBuilder().append("IO exception while creating or opening temp file");
                if (artifactListFile == null) {
                    string = "";
                    throw new ResolvingFailedException(stringBuilder.append(string).append(": ").append(e.getMessage()).toString(), (Throwable)e);
                }
                string = " [" + artifactListFile.getAbsolutePath() + "]";
                throw new ResolvingFailedException(stringBuilder.append(string).append(": ").append(e.getMessage()).toString(), (Throwable)e);
                catch (RecoverableResolvingException e2) {
                    throw new RecoverableResolvingException("Recoverable failure while getting source paths list: " + e2.getMessage(), e2.getCause());
                }
                catch (ResolvingFailedException e3) {
                    throw new ResolvingFailedException("Failed to get source paths list: " + e3.getMessage(), e3.getCause());
                }
                catch (XPathExpressionException e4) {
                    throw new ResolvingFailedException("Failed to parse source paths list.", (Throwable)e4);
                }
            }
            catch (Throwable throwable) {
                this.myDownloadedArtifacts.setPaused(false);
                FileUtil.close(artifactListStream);
                if (artifactListFile == null) throw throwable;
                FileUtil.delete((File)artifactListFile);
                throw throwable;
            }
        }
        FileUtil.close((Closeable)artifactListStream);
        if (artifactListFile != null) {
            FileUtil.delete((File)artifactListFile);
        }
        TreeSet<String> treeSet = result;
        if (treeSet != null) return treeSet;
        TeamCityArtifactAccessor.$$$reportNull$$$0(17);
        return treeSet;
    }

    @Override
    public void interrupt() {
        this.myContentFetcher.interrupt();
    }

    @Override
    public void downloadArtifacts(@NotNull String sourceExternalId, @NotNull String revision, @Nullable String branchName, @NotNull Map<String, File> sourceToFiles) {
        if (sourceExternalId == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(18);
        }
        if (revision == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(19);
        }
        if (sourceToFiles == null) {
            TeamCityArtifactAccessor.$$$reportNull$$$0(20);
        }
        for (Map.Entry<String, File> entry : sourceToFiles.entrySet()) {
            String sourcePath = entry.getKey();
            File target = entry.getValue();
            try {
                this.myContentFetcher.fetchContentToFile(target, this.getArtifactUrl(sourceExternalId, revision, branchName, sourcePath));
            }
            catch (RecoverableResolvingException e) {
                String message = "Recoverable failure while downloading file '" + sourcePath + "': " + e.getMessage();
                throw new RecoverableResolvingException(message, e.getCause());
            }
            catch (ResolvingFailedException e) {
                String message = "Failed to download file '" + sourcePath + "': " + e.getMessage();
                throw new SourcePathAwareResolvingFailedException(message, e.getCause(), sourcePath);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retriever";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadedArtifacts";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseURL";
                break;
            }
            case 6: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceExternalId";
                break;
            }
            case 7: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/impl/TeamCityArtifactAccessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceToFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/impl/TeamCityArtifactAccessor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "urlEncodePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "urlEncodeParameter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactUrl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactSourcePathList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactUrlFromTemplate";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "urlEncodeParameter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactUrl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactSourcePathList";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "downloadArtifacts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

