/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.impl;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.ExtensionsProvider;
import jetbrains.buildServer.artifacts.ArtifactAccessor;
import jetbrains.buildServer.artifacts.ArtifactCacheProvider;
import jetbrains.buildServer.artifacts.ArtifactStorageSettingsProvider;
import jetbrains.buildServer.artifacts.DependencyResolverContext;
import jetbrains.buildServer.artifacts.FileCache;
import jetbrains.buildServer.artifacts.TransportFactoryExtension;
import jetbrains.buildServer.artifacts.URLContentRetriever;
import jetbrains.buildServer.artifacts.impl.CachingHttpTransport;
import jetbrains.buildServer.artifacts.impl.CompositeURLContentRetriever;
import jetbrains.buildServer.artifacts.impl.DownloadedArtifacts;
import jetbrains.buildServer.artifacts.impl.ResolverRuntimeConfiguration;
import jetbrains.buildServer.artifacts.impl.TeamCityArtifactAccessor;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransportFactoriesFacade {
    private static final Logger LOG = Logger.getInstance((String)TransportFactoriesFacade.class.getName());
    private final ResolverRuntimeConfiguration myRuntimeConfig;
    @NotNull
    private final Collection<TransportFactoryExtension> myTransportFactoryExtensions;
    @Nullable
    private final ArtifactCacheProvider myCacheProvider;
    @NotNull
    private final ArtifactStorageSettingsProvider myConfigProvider;
    @NotNull
    private final DownloadedArtifacts myProgressTracker;

    public TransportFactoriesFacade(@NotNull ExtensionsProvider provider, @NotNull ResolverRuntimeConfiguration config, @Nullable ArtifactCacheProvider cacheProvider, @NotNull ArtifactStorageSettingsProvider configProvider, @NotNull DownloadedArtifacts progressTracker) {
        if (provider == null) {
            TransportFactoriesFacade.$$$reportNull$$$0(0);
        }
        if (config == null) {
            TransportFactoriesFacade.$$$reportNull$$$0(1);
        }
        if (configProvider == null) {
            TransportFactoriesFacade.$$$reportNull$$$0(2);
        }
        if (progressTracker == null) {
            TransportFactoriesFacade.$$$reportNull$$$0(3);
        }
        this.myRuntimeConfig = config;
        this.myTransportFactoryExtensions = provider.getExtensions(TransportFactoryExtension.class);
        this.myCacheProvider = cacheProvider;
        this.myConfigProvider = configProvider;
        this.myProgressTracker = progressTracker;
    }

    @NotNull
    private Map<String, String> getSettings(DependencyResolverContext context) {
        HashMap<String, String> defaultSettings = new HashMap<String, String>(this.myConfigProvider.getDefaultSettings());
        if (StringUtil.isNotEmpty((String)context.getUsername())) {
            defaultSettings.put("accessUser", context.getUsername());
            defaultSettings.put("accessCode", context.getPassword());
            defaultSettings.put("serverUrl", context.getServerUrl().toString());
            defaultSettings.put("connectionTimeout", String.valueOf(context.getConnectionTimeout()));
        }
        HashMap<String, String> hashMap = defaultSettings;
        if (hashMap == null) {
            TransportFactoriesFacade.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @NotNull
    public ArtifactAccessor getArtifactAccessor() {
        TeamCityArtifactAccessor teamCityArtifactAccessor = new TeamCityArtifactAccessor(this.getURLContentRetriever(), this.myProgressTracker, this.myRuntimeConfig.getContext().getServerUrl().toString());
        if (teamCityArtifactAccessor == null) {
            TransportFactoriesFacade.$$$reportNull$$$0(5);
        }
        return teamCityArtifactAccessor;
    }

    @NotNull
    public URLContentRetriever getURLContentRetriever() {
        CompositeURLContentRetriever retriever = new CompositeURLContentRetriever(this.getURLContentRetrievers(), this.myProgressTracker);
        FileCache httpCache = this.myCacheProvider != null ? this.myCacheProvider.getHttpCache(retriever) : null;
        Object res = httpCache != null ? new CachingHttpTransport(httpCache, retriever) : retriever;
        CompositeURLContentRetriever compositeURLContentRetriever = res;
        if (compositeURLContentRetriever == null) {
            TransportFactoriesFacade.$$$reportNull$$$0(6);
        }
        return compositeURLContentRetriever;
    }

    @NotNull
    public List<URLContentRetriever> getURLContentRetrievers() {
        final Map<String, String> settings = this.getSettings(this.myRuntimeConfig.getContext());
        List urlContentRetrievers = CollectionsUtil.convertCollection(this.myTransportFactoryExtensions, (Converter)new Converter<URLContentRetriever, TransportFactoryExtension>(){

            public URLContentRetriever createFrom(@NotNull TransportFactoryExtension source) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    return source.getTransport(settings);
                }
                catch (Throwable ex) {
                    LOG.warnAndDebugDetails("Cannot create artifacts transport for " + source.getClass() + "; Extension will be skipped.", ex);
                    return null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "jetbrains/buildServer/artifacts/impl/TransportFactoriesFacade$1", "createFrom"));
            }
        });
        List filtered = CollectionsUtil.filterNulls((Collection)urlContentRetrievers);
        if (filtered.isEmpty()) {
            throw new IllegalStateException("No available transport found in " + this.myTransportFactoryExtensions + " with settings: " + settings);
        }
        List list = filtered;
        if (list == null) {
            TransportFactoriesFacade.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTracker";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/impl/TransportFactoriesFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/impl/TransportFactoriesFacade";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactAccessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getURLContentRetriever";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getURLContentRetrievers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

