/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.rules;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jetbrains.buildServer.artifacts.rules.ArtifactDependencyFileRule;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.vcs.FileRule;
import jetbrains.buildServer.vcs.FileRuleSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDepRuleSet
extends FileRuleSet<ArtifactDependencyFileRule<ArtifactDepRuleSet>, ArtifactDependencyFileRule<ArtifactDepRuleSet>> {
    private static final String ARCHIVE_PART_DELIMITER = "!";
    private static final String TARGET_PART_DELIMITER = "=>";
    @Nullable
    private List<ArtifactDependencyFileRule<ArtifactDepRuleSet>> myIncludeArchRules;
    @Nullable
    private List<ArtifactDependencyFileRule<ArtifactDepRuleSet>> myExcludeArchRules;
    @Nullable
    private Set<String> myTargetDirs;

    private ArtifactDepRuleSet(@NotNull List<String> lines) {
        if (lines == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(0);
        }
        super(lines);
    }

    public ArtifactDepRuleSet(@NotNull String body) {
        if (body == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(1);
        }
        super(body);
    }

    protected void doPostInitProcess(@NotNull List<ArtifactDependencyFileRule<ArtifactDepRuleSet>> includeRules, @NotNull List<ArtifactDependencyFileRule<ArtifactDepRuleSet>> excludeRules) {
        if (includeRules == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(2);
        }
        if (excludeRules == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(3);
        }
        LinkedList<ArtifactDependencyFileRule<ArtifactDepRuleSet>> includeArchRules = new LinkedList<ArtifactDependencyFileRule<ArtifactDepRuleSet>>();
        LinkedList<ArtifactDependencyFileRule<ArtifactDepRuleSet>> excludeArchRules = new LinkedList<ArtifactDependencyFileRule<ArtifactDepRuleSet>>();
        HashSet<String> targetDirs = new HashSet<String>();
        for (ArtifactDependencyFileRule<ArtifactDepRuleSet> rule : includeRules) {
            if (!StringUtil.isEmpty((String)rule.getArchivePath())) {
                includeArchRules.add(rule);
            }
            targetDirs.add(rule.getTo());
        }
        ArrayList<ArtifactDependencyFileRule<ArtifactDepRuleSet>> excludeRulesCopy = new ArrayList<ArtifactDependencyFileRule<ArtifactDepRuleSet>>(excludeRules);
        for (ArtifactDependencyFileRule artifactDependencyFileRule : excludeRulesCopy) {
            if (StringUtil.isEmpty((String)artifactDependencyFileRule.getArchivePath())) continue;
            excludeArchRules.add(artifactDependencyFileRule);
            excludeRules.remove((Object)artifactDependencyFileRule);
        }
        this.myIncludeArchRules = includeArchRules;
        this.myExcludeArchRules = excludeArchRules;
        this.myTargetDirs = targetDirs;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    protected ArtifactDependencyFileRule<ArtifactDepRuleSet> createNewIncludeRule(@Nullable String rule) {
        if (null == rule) {
            return null;
        }
        return this.createRule(rule, true);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    protected ArtifactDependencyFileRule<ArtifactDepRuleSet> createNewExcludeRule(@Nullable String rule) {
        if (null == rule) {
            return null;
        }
        return this.createRule(rule, false);
    }

    @NotNull
    private ArtifactDependencyFileRule<ArtifactDepRuleSet> createRule(@NotNull String rule, boolean include) {
        int archDelimIndx;
        if (rule == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(4);
        }
        String from = rule;
        String archivePath = "";
        String to = "";
        int targetDelimIndx = rule.lastIndexOf(TARGET_PART_DELIMITER);
        if (targetDelimIndx > -1) {
            from = rule.substring(0, targetDelimIndx);
            to = rule.substring(targetDelimIndx + TARGET_PART_DELIMITER.length()).trim();
        }
        if ((archDelimIndx = from.lastIndexOf(ARCHIVE_PART_DELIMITER)) > -1) {
            archivePath = from.substring(archDelimIndx + ARCHIVE_PART_DELIMITER.length());
            from = from.substring(0, archDelimIndx);
        }
        ArtifactDependencyFileRule<ArtifactDepRuleSet> artifactDependencyFileRule = new ArtifactDependencyFileRule<ArtifactDepRuleSet>(from, to, archivePath, this, include);
        if (artifactDependencyFileRule == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(5);
        }
        return artifactDependencyFileRule;
    }

    @NotNull
    protected ArtifactDependencyFileRule<ArtifactDepRuleSet> createNewIncludeRule(@NotNull ArtifactDependencyFileRule<ArtifactDepRuleSet> includeRule) {
        if (includeRule == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(6);
        }
        FileRule fileRule = this.createNewIncludeRule(includeRule.toString());
        if (fileRule == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(7);
        }
        return fileRule;
    }

    @NotNull
    protected ArtifactDependencyFileRule<ArtifactDepRuleSet> createNewExcludeRule(@NotNull ArtifactDependencyFileRule<ArtifactDepRuleSet> excludeRule) {
        if (excludeRule == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(8);
        }
        FileRule fileRule = this.createNewExcludeRule(excludeRule.toString());
        if (fileRule == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(9);
        }
        return fileRule;
    }

    @NotNull
    public List<String> getTargetPath(@NotNull String sourcePath) {
        if (sourcePath == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(10);
        }
        List list = CollectionsUtil.convertCollection(this.getRulePathPairs(sourcePath), source -> (String)source.second);
        if (list == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<Pair<ArtifactDependencyFileRule<ArtifactDepRuleSet>, String>> getRulePathPairs(@NotNull String sourcePath) {
        if (sourcePath == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(12);
        }
        ArrayList<Pair<ArtifactDependencyFileRule<ArtifactDepRuleSet>, String>> result = new ArrayList<Pair<ArtifactDependencyFileRule<ArtifactDepRuleSet>, String>>();
        for (String targetDir : this.myTargetDirs) {
            ArtifactDependencyFileRule mostSpecific;
            TargetDirIncludeRuleFilter filter = new TargetDirIncludeRuleFilter(targetDir);
            if (!this.shouldInclude(sourcePath, filter) || (mostSpecific = (ArtifactDependencyFileRule)ArtifactDepRuleSet.findMostSpecific((String)sourcePath, (List)this.getIncludeRules(filter))) == null) continue;
            String barePath = mostSpecific.trimMatchedPath(sourcePath);
            if (!StringUtil.isEmpty((String)targetDir)) {
                result.add((Pair<ArtifactDependencyFileRule<ArtifactDepRuleSet>, String>)Pair.create((Object)((Object)mostSpecific), (Object)(targetDir + "/" + barePath)));
                continue;
            }
            result.add((Pair<ArtifactDependencyFileRule<ArtifactDepRuleSet>, String>)Pair.create((Object)((Object)mostSpecific), (Object)barePath));
        }
        ArrayList<Pair<ArtifactDependencyFileRule<ArtifactDepRuleSet>, String>> arrayList = result;
        if (arrayList == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    public ArtifactDepRuleSet findArchiveRuleSet(@NotNull String archivePath) {
        if (archivePath == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(14);
        }
        ArrayList<String> archiveRulesBody = new ArrayList<String>();
        for (ArtifactDependencyFileRule<ArtifactDepRuleSet> includeRule : this.myIncludeArchRules) {
            if (includeRule.getMatchedHead(archivePath) == null) continue;
            archiveRulesBody.add("+:" + includeRule.getArchivePath() + TARGET_PART_DELIMITER + includeRule.getTo());
        }
        for (ArtifactDependencyFileRule<ArtifactDepRuleSet> excludeRule : this.myExcludeArchRules) {
            if (excludeRule.getMatchedHead(archivePath) == null) continue;
            archiveRulesBody.add("-:" + excludeRule.getArchivePath());
        }
        if (archiveRulesBody.size() > 0) {
            return new ArtifactDepRuleSet(archiveRulesBody);
        }
        return null;
    }

    @NotNull
    public Set<String> getTargetPaths() {
        Set<String> set = Collections.unmodifiableSet(this.myTargetDirs);
        if (set == null) {
            ArtifactDepRuleSet.$$$reportNull$$$0(15);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeRules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeRules";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/rules/ArtifactDepRuleSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeRule";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeRule";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archivePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/rules/ArtifactDepRuleSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createRule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewIncludeRule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewExcludeRule";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulePathPairs";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doPostInitProcess";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRule";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewIncludeRule";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNewExcludeRule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTargetPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRulePathPairs";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findArchiveRuleSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TargetDirIncludeRuleFilter
    implements Filter<FileRule> {
        private final String myTargetDir;

        public TargetDirIncludeRuleFilter(String targetDir) {
            this.myTargetDir = targetDir;
        }

        public boolean accept(@NotNull FileRule data) {
            ArtifactDependencyFileRule fileRule;
            if (data == null) {
                TargetDirIncludeRuleFilter.$$$reportNull$$$0(0);
            }
            if (!(fileRule = (ArtifactDependencyFileRule)data).isIsInclude()) {
                return true;
            }
            if (StringUtil.isNotEmpty((String)fileRule.getArchivePath())) {
                return false;
            }
            String fileRuleTarget = fileRule.getTo();
            return StringUtil.notNullize((String)this.myTargetDir, (String)"").equals(fileRuleTarget);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/artifacts/rules/ArtifactDepRuleSet$TargetDirIncludeRuleFilter", "accept"));
        }
    }
}

