/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.rules;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.vcs.FileRule;
import jetbrains.buildServer.vcs.FileRuleSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactDependencyFileRule<T extends FileRuleSet>
extends FileRule<T> {
    @NotNull
    private String myTo;
    @NotNull
    private String myArchivePath;

    public ArtifactDependencyFileRule(@NotNull String from, @NotNull String to, @Nullable String archivePath, T t, boolean isInclude) {
        if (from == null) {
            ArtifactDependencyFileRule.$$$reportNull$$$0(0);
        }
        if (to == null) {
            ArtifactDependencyFileRule.$$$reportNull$$$0(1);
        }
        super(from.trim(), t, isInclude);
        this.myTo = "";
        this.myArchivePath = "";
        if (archivePath != null && !"".equals(archivePath.trim())) {
            this.myArchivePath = FileUtil.normalizeRelativePath((String)archivePath.trim());
        }
        if (to.length() > 0) {
            File toFile = new File(to);
            this.myTo = toFile.isAbsolute() ? FileUtil.normalizeSeparator((String)to.trim()) : FileUtil.normalizeRelativePath((String)to.trim());
        }
    }

    @Nullable
    public String trimMatchedPath(@NotNull String sourcePath) {
        String cleanPath;
        String matchedHead;
        if (sourcePath == null) {
            ArtifactDependencyFileRule.$$$reportNull$$$0(2);
        }
        if (null == (matchedHead = this.getMatchedHead(cleanPath = this.preparePathWithLowercase(sourcePath)))) {
            return null;
        }
        if (matchedHead.length() < cleanPath.length() && cleanPath.charAt(matchedHead.length()) == '/') {
            return cleanPath.substring(matchedHead.length() + 1);
        }
        int lastSeparator = matchedHead.lastIndexOf(47);
        if (lastSeparator < 0) {
            return cleanPath;
        }
        return cleanPath.substring(lastSeparator + 1);
    }

    @Nullable
    public String getMatchedHead(@NotNull String path) {
        if (path == null) {
            ArtifactDependencyFileRule.$$$reportNull$$$0(3);
        }
        if (path.startsWith(".teamcity") && !this.myFromFull.startsWith(".teamcity")) {
            return null;
        }
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            int firstGroupIndex;
            int groupCount = matcher.groupCount();
            if (groupCount > 0 && (firstGroupIndex = matcher.start(1)) > -1) {
                return this.preparePathWithLowercase(path.substring(0, firstGroupIndex));
            }
            return this.preparePathWithLowercase(path);
        }
        return null;
    }

    @NotNull
    protected String createPatternString(@NotNull String from) {
        if (from == null) {
            ArtifactDependencyFileRule.$$$reportNull$$$0(4);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < from.length(); ++i) {
            char nextChar = from.charAt(i);
            if (nextChar == '\\') {
                result.append("\\/");
                continue;
            }
            if (nextChar == '?') {
                result.append("(.)");
                continue;
            }
            if (nextChar == '$' || nextChar == '(' || nextChar == '{' || nextChar == ')' || nextChar == '}' || nextChar == '[' || nextChar == ']' || nextChar == '/' || nextChar == '.' || nextChar == '+') {
                result.append("\\").append(nextChar);
                continue;
            }
            if (nextChar == '*') {
                if (i < from.length() - 1 && from.charAt(i + 1) == '*') {
                    if (i < from.length() - 2 && from.charAt(i + 2) == '/') {
                        result.append("((.*)/)*");
                        i += 2;
                        continue;
                    }
                    result.append("(.*)");
                    ++i;
                    continue;
                }
                result.append("([^/]*)");
                continue;
            }
            result.append(nextChar);
        }
        String string = result.toString();
        if (string == null) {
            ArtifactDependencyFileRule.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getTo() {
        String string = this.myTo;
        if (string == null) {
            ArtifactDependencyFileRule.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getArchivePath() {
        String string = this.myArchivePath;
        if (string == null) {
            ArtifactDependencyFileRule.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/rules/ArtifactDependencyFileRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/rules/ArtifactDependencyFileRule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArchivePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "trimMatchedPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedHead";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPatternString";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

