/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import jetbrains.buildServer.artifacts.ArtifactData;
import jetbrains.buildServer.artifacts.ArtifactListData;
import jetbrains.buildServer.artifacts.util.SerializableArtifactListData;
import jetbrains.buildServer.util.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactListUtil {
    @NotNull
    private static final Logger LOG = Logger.getInstance(ArtifactListUtil.class);
    @NotNull
    private static final Charset OUR_CHARSET = StandardCharsets.UTF_8;
    @NotNull
    private static final Gson OUR_GSON = new GsonBuilder().setPrettyPrinting().create();

    @Nullable
    public static SerializableArtifactListData readArtifactList(@NotNull InputStream is) {
        if (is == null) {
            ArtifactListUtil.$$$reportNull$$$0(0);
        }
        try {
            SerializableArtifactListData serializableArtifactListData = (SerializableArtifactListData)OUR_GSON.fromJson((Reader)new InputStreamReader(is, OUR_CHARSET), SerializableArtifactListData.class);
            return serializableArtifactListData;
        }
        finally {
            FileUtil.close((Closeable)is);
        }
    }

    public static void writeArtifactList(@NotNull SerializableArtifactListData artifactsInfo, @NotNull File file) {
        if (artifactsInfo == null) {
            ArtifactListUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            ArtifactListUtil.$$$reportNull$$$0(2);
        }
        try {
            FileUtil.writeViaTmpFile((File)file, (InputStream)new BufferedInputStream(new ByteArrayInputStream(OUR_GSON.toJson((Object)artifactsInfo).getBytes(OUR_CHARSET))), (FileUtil.IOAction)FileUtil.IOAction.DO_NOTHING);
        }
        catch (IOException e) {
            LOG.warnAndDebugDetails("Failed to write artifact list to file [" + file.getAbsolutePath() + "]", (Throwable)e);
        }
    }

    @NotNull
    public static ArtifactListData filterDuplicatedArtifacts(@NotNull ArtifactListData artifactsInfo) {
        if (artifactsInfo == null) {
            ArtifactListUtil.$$$reportNull$$$0(3);
        }
        HashMap<String, ArtifactData> lastArtifactRecord = new HashMap<String, ArtifactData>();
        for (ArtifactData artifactData : artifactsInfo.getArtifactList()) {
            lastArtifactRecord.put(artifactData.getPath(), artifactData);
        }
        SerializableArtifactListData serializableArtifactListData = new SerializableArtifactListData(artifactsInfo.getStorageSettingsId(), artifactsInfo.getCommonProperties(), new ArrayList(lastArtifactRecord.values()));
        if (serializableArtifactListData == null) {
            ArtifactListUtil.$$$reportNull$$$0(4);
        }
        return serializableArtifactListData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactsInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/util/ArtifactListUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/util/ArtifactListUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDuplicatedArtifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readArtifactList";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeArtifactList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterDuplicatedArtifacts";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

