/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.artifacts.util;

import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import jetbrains.buildServer.artifacts.ArtifactData;
import jetbrains.buildServer.artifacts.ArtifactListData;
import jetbrains.buildServer.artifacts.util.SerializableArtifactData;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Converter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableArtifactListData
implements ArtifactListData {
    @SerializedName(value="version")
    @NotNull
    private final String myFormatVersion = "2017.1";
    @SerializedName(value="storage_settings_id")
    @NotNull
    private final String myStorageSettingsId;
    @SerializedName(value="properties")
    @NotNull
    private final SortedMap<String, String> myCommonProperties;
    @SerializedName(value="artifacts")
    @NotNull
    private final List<SerializableArtifactData> myArtifactList;

    public SerializableArtifactListData(@NotNull String storageSettingsId, @Nullable Map<String, String> commonProperties, @NotNull List<? extends ArtifactData> artifactList) {
        if (storageSettingsId == null) {
            SerializableArtifactListData.$$$reportNull$$$0(0);
        }
        if (artifactList == null) {
            SerializableArtifactListData.$$$reportNull$$$0(1);
        }
        this.myFormatVersion = "2017.1";
        this.myStorageSettingsId = storageSettingsId;
        this.myCommonProperties = new TreeMap<String, String>(commonProperties == null ? Collections.emptyMap() : commonProperties);
        this.myArtifactList = SerializableArtifactListData.toSerializableArtifactData(artifactList);
    }

    @NotNull
    public static List<SerializableArtifactData> toSerializableArtifactData(@NotNull List<? extends ArtifactData> artifacts) {
        if (artifacts == null) {
            SerializableArtifactListData.$$$reportNull$$$0(2);
        }
        List list = CollectionsUtil.convertCollection(artifacts, (Converter)new Converter<SerializableArtifactData, ArtifactData>(){

            public SerializableArtifactData createFrom(@NotNull ArtifactData artifact) {
                if (artifact == null) {
                    1.$$$reportNull$$$0(0);
                }
                return SerializableArtifactData.toSerializableArtifactData(artifact);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "jetbrains/buildServer/artifacts/util/SerializableArtifactListData$1", "createFrom"));
            }
        });
        if (list == null) {
            SerializableArtifactListData.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<ArtifactData> getArtifactList() {
        List<ArtifactData> list = Collections.unmodifiableList(this.myArtifactList);
        if (list == null) {
            SerializableArtifactListData.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Map<String, String> getCommonProperties() {
        SortedMap<String, String> sortedMap = Collections.unmodifiableSortedMap(this.myCommonProperties);
        if (sortedMap == null) {
            SerializableArtifactListData.$$$reportNull$$$0(5);
        }
        return sortedMap;
    }

    @NotNull
    public String getStorageSettingsId() {
        String string = this.myStorageSettingsId;
        if (string == null) {
            SerializableArtifactListData.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageSettingsId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/artifacts/util/SerializableArtifactListData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/artifacts/util/SerializableArtifactListData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toSerializableArtifactData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageSettingsId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toSerializableArtifactData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

