/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.backgroundTasks.impl;

import java.util.concurrent.Future;
import jetbrains.buildServer.backgroundTasks.ActivityProgress;
import jetbrains.buildServer.backgroundTasks.BackgroundActivity;
import jetbrains.buildServer.backgroundTasks.BackgroundTask;

public class BackgroundTaskImpl
implements BackgroundTask,
ActivityProgress {
    private final String myId;
    private float myFraction;
    private String myProgressText;
    private Future<?> myFuture;
    private boolean myCanceled;

    public BackgroundTaskImpl(String id, BackgroundActivity action) {
        this.myId = id;
    }

    public String getId() {
        return this.myId;
    }

    public synchronized String getProgressText() {
        return this.myProgressText;
    }

    public synchronized float getFraction() {
        return this.myFraction;
    }

    public synchronized Future getFuture() {
        return this.myFuture;
    }

    public synchronized boolean isDone() {
        return this.myCanceled || this.myFuture != null && this.myFuture.isDone();
    }

    public synchronized void setFraction(float completed) {
        this.myFraction = completed;
    }

    public synchronized void setProgressText(String progressText) {
        this.myProgressText = progressText;
    }

    public synchronized void checkCanceled() throws InterruptedException {
        if (this.myCanceled || this.myFuture != null && this.myFuture.isCancelled()) {
            throw new InterruptedException();
        }
    }

    synchronized void setFuture(Future<?> future) {
        this.myFuture = future;
    }

    synchronized void cancel() {
        this.myCanceled = true;
    }
}

