/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.backgroundTasks.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import jetbrains.buildServer.backgroundTasks.ActivityProgress;
import jetbrains.buildServer.backgroundTasks.BackgroundActivity;
import jetbrains.buildServer.backgroundTasks.BackgroundTask;
import jetbrains.buildServer.backgroundTasks.BackgroundTaskManager;
import jetbrains.buildServer.backgroundTasks.impl.BackgroundTaskImpl;

public class BackgroundTaskManagerImpl
implements BackgroundTaskManager {
    private final Executor myExecutorService;
    private final Map<String, BackgroundTask> myTasks = new HashMap<String, BackgroundTask>();

    public BackgroundTaskManagerImpl(Executor executor) {
        this.myExecutorService = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTask findTask(String id) {
        Map<String, BackgroundTask> map = this.myTasks;
        synchronized (map) {
            return this.myTasks.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackgroundTask getOrCreateTask(final String id, final BackgroundActivity action) {
        Map<String, BackgroundTask> map = this.myTasks;
        synchronized (map) {
            BackgroundTask existing = this.findTask(id);
            if (existing != null) {
                return existing;
            }
            final BackgroundTaskImpl task = new BackgroundTaskImpl(id, action);
            FutureTask<Object> toExecute = new FutureTask<Object>(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        action.runIt((ActivityProgress)task);
                    }
                    finally {
                        Map map = BackgroundTaskManagerImpl.this.myTasks;
                        synchronized (map) {
                            BackgroundTaskManagerImpl.this.myTasks.remove(id);
                        }
                    }
                }
            }, null){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    task.cancel();
                    BackgroundTaskManagerImpl.this.myTasks.remove(id);
                    return super.cancel(mayInterruptIfRunning);
                }
            };
            task.setFuture(toExecute);
            this.myTasks.put(id, task);
            this.myExecutorService.execute(toExecute);
            return task;
        }
    }
}

