/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.codeInspection;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class InspectionMessageBean {
    public static final byte SEVERITY_ERROR = 0;
    public static final byte SEVERITY_WARNING = 1;
    public static final byte SEVERITY_INFO = 2;
    public static final byte SEVERITY_TYPO = 3;
    public static final byte SEVERITY_UNKNOWN = 100;
    public static final String SEVERITY_ERROR_ID = HighlightSeverity.ERROR.myName;
    public static final String SEVERITY_WARNING_ID = HighlightSeverity.WARNING.myName;
    public static final String SEVERITY_INFO_ID = HighlightSeverity.INFO.myName;
    public static final String SEVERITY_TYPO_ID = "TYPO";
    public static final byte TYPE_UNKNOWN = 45;
    public static final byte TYPE_NONE = 48;
    public static final byte TYPE_FILE = 49;
    public static final byte TYPE_CLASS = 50;
    public static final byte TYPE_FIELD = 51;
    public static final byte TYPE_METHOD = 52;
    public static final byte TYPE_PARAM = 53;
    public static final byte TYPE_MODULE = 54;
    public static final byte TYPE_PACKAGE = 55;
    public static final byte TYPE_PROJECT = 56;
    public static final byte TYPE_DIR = 57;
    public static final String TYPE_FILE_ID = "file";
    public static final String TYPE_CLASS_ID = "class";
    public static final String TYPE_FIELD_ID = "field";
    public static final String TYPE_METHOD_ID = "method";
    public static final String TYPE_PARAM_ID = "parameter";
    public static final String TYPE_PROJECT_ID = "project";
    public static final String TYPE_MODULE_ID = "module";
    public static final String TYPE_PACKAGE_ID = "package";
    public static final String TYPE_DIR_ID = "dir";
    private final String myInspectionId;
    private final String myFileUrl;
    private final int myLine;
    private final String myProblemMessage;
    private Map<String, List<String>> myAttributes = new HashMap<String, List<String>>();
    private final byte mySeverity;
    private final boolean myLocalResult;
    private final byte myType;
    private final String myFQName;
    private String[] myHints;
    private String[] myParentFQNames;
    private byte[] myParentTypes;
    private String myModuleName;
    private static final Map<String, Byte> mySeverityToByte = new HashMap<String, Byte>();
    private static final Map<String, Byte> myTypeToByte;
    private static final Map<Byte, String> myByteToType;

    private static void putType(String typeStr, byte typeCode) {
        myTypeToByte.put(typeStr, typeCode);
        myByteToType.put(typeCode, typeStr);
    }

    public static byte convertSeverity(String sev) {
        Byte severity = mySeverityToByte.get(sev);
        if (severity != null) {
            return severity;
        }
        return 100;
    }

    public static byte convertType(String type) {
        Byte res = myTypeToByte.get(type);
        if (res != null) {
            return res;
        }
        return 45;
    }

    @Nullable
    public static String convertType(byte type) {
        return myByteToType.get(type);
    }

    public InspectionMessageBean(String problemMessage, String inspectionId, String fileUrl, int line, byte type, String FQName, byte severity, boolean localResult, String[] hints) {
        this.myProblemMessage = problemMessage;
        this.myInspectionId = inspectionId;
        this.myFileUrl = fileUrl;
        this.myLine = line;
        this.myType = type;
        this.myFQName = FQName;
        this.mySeverity = severity;
        this.myLocalResult = localResult;
        this.myHints = hints;
    }

    public String getInspectionId() {
        return this.myInspectionId;
    }

    public String[] getHints() {
        return this.myHints;
    }

    public String getFileUrl() {
        return this.myFileUrl;
    }

    public byte getType() {
        return this.myType;
    }

    public String getFQName() {
        return this.myFQName;
    }

    public byte getSeverity() {
        return this.mySeverity;
    }

    public boolean isLocalResult() {
        return this.myLocalResult;
    }

    public int getLine() {
        return this.myLine;
    }

    public String getProblemMessage() {
        return this.myProblemMessage;
    }

    public String getId() {
        if (this.myFQName == null) {
            return "";
        }
        int i = this.myFQName.lastIndexOf(46);
        return i > 0 ? this.myFQName.substring(i + 1) : this.myFQName;
    }

    public String[] getParentFQNames() {
        return this.myParentFQNames;
    }

    public void setParentFQNames(String[] parentFQNames) {
        this.myParentFQNames = parentFQNames;
    }

    public byte[] getParentTypes() {
        return this.myParentTypes;
    }

    public void setParentTypes(int[] parentTypes) {
        this.myParentTypes = new byte[parentTypes.length];
        int i = 0;
        for (int type : parentTypes) {
            this.myParentTypes[i++] = (byte)type;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectionMessageBean that = (InspectionMessageBean)o;
        if (this.myLine != that.myLine) {
            return false;
        }
        if (this.myLocalResult != that.myLocalResult) {
            return false;
        }
        if (this.mySeverity != that.mySeverity) {
            return false;
        }
        if (this.myType != that.myType) {
            return false;
        }
        if (this.myFQName != null ? !this.myFQName.equals(that.myFQName) : that.myFQName != null) {
            return false;
        }
        if (this.myFileUrl != null ? !this.myFileUrl.equals(that.myFileUrl) : that.myFileUrl != null) {
            return false;
        }
        if (this.myInspectionId != null ? !this.myInspectionId.equals(that.myInspectionId) : that.myInspectionId != null) {
            return false;
        }
        if (this.myProblemMessage != null ? !this.myProblemMessage.equals(that.myProblemMessage) : that.myProblemMessage != null) {
            return false;
        }
        return this.getAttributes().equals(that.getAttributes());
    }

    public int hashCode() {
        int result = this.myProblemMessage != null ? this.myProblemMessage.hashCode() : 0;
        result = 31 * result + (this.myInspectionId != null ? this.myInspectionId.hashCode() : 0);
        result = 31 * result + (this.myFileUrl != null ? this.myFileUrl.hashCode() : 0);
        result = 31 * result + this.myLine;
        result = 31 * result + this.myType;
        result = 31 * result + (this.myFQName != null ? this.myFQName.hashCode() : 0);
        result = 31 * result + this.mySeverity;
        result = 31 * result + (this.myLocalResult ? 1 : 0);
        result = 31 * result + this.getAttributes().hashCode();
        return result;
    }

    public String toString() {
        return "InspectionMessageBean{myProblemMessage='" + this.myProblemMessage + '\'' + ", myInspectionId='" + this.myInspectionId + '\'' + ", myFileUrl='" + this.myFileUrl + '\'' + ", myLine=" + this.myLine + ", myType=" + this.myType + ", myFQName='" + this.myFQName + '\'' + ", mySeverity=" + this.mySeverity + ", myLocalResult=" + this.myLocalResult + ", myHints=" + (this.myHints == null ? null : Arrays.asList(this.myHints)) + ", myAttributes=" + this.getAttributes() + '}';
    }

    public void addHint(String hint) {
        this.myHints = this.myHints != null ? (String[])ArrayUtil.mergeArrays((Object[])this.myHints, (Object[])new String[]{hint}, String.class) : new String[]{hint};
    }

    public void setModule(String moduleName) {
        this.myModuleName = moduleName;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    public void addAttribute(String attributeId, Collection<String> value) {
        this.myAttributes.put(attributeId, new ArrayList<String>(value));
    }

    public Map<String, List<String>> getAttributes() {
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap<String, List<String>>();
        }
        return this.myAttributes;
    }

    static {
        mySeverityToByte.put(SEVERITY_ERROR_ID, (byte)0);
        mySeverityToByte.put(SEVERITY_WARNING_ID, (byte)1);
        mySeverityToByte.put(SEVERITY_INFO_ID, (byte)2);
        mySeverityToByte.put("WEAK WARNING", (byte)2);
        mySeverityToByte.put(SEVERITY_TYPO_ID, (byte)3);
        myTypeToByte = new HashMap<String, Byte>();
        myByteToType = new HashMap<Byte, String>();
        InspectionMessageBean.putType(null, (byte)48);
        InspectionMessageBean.putType(TYPE_FILE_ID, (byte)49);
        InspectionMessageBean.putType(TYPE_CLASS_ID, (byte)50);
        InspectionMessageBean.putType(TYPE_FIELD_ID, (byte)51);
        InspectionMessageBean.putType(TYPE_METHOD_ID, (byte)52);
        InspectionMessageBean.putType(TYPE_PARAM_ID, (byte)53);
        InspectionMessageBean.putType(TYPE_MODULE_ID, (byte)54);
        InspectionMessageBean.putType(TYPE_PACKAGE_ID, (byte)55);
        InspectionMessageBean.putType(TYPE_PROJECT_ID, (byte)56);
        InspectionMessageBean.putType(TYPE_DIR_ID, (byte)57);
    }
}

