/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.coverage;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import jetbrains.buildServer.agent.AgentRunningBuild;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.util.FileUtil;

public class AgentCoverageUtil {
    public static final String TEMPORARY_DIRECTORY_PATH = "teamcity.coverage.tempdir.path";

    public static File createTempDirectory(AgentRunningBuild build, String coverageEngineName) {
        File tempDir;
        try {
            tempDir = FileUtil.createTempDirectory((String)coverageEngineName, (String)"coverage", (File)build.getBuildTempDirectory());
        }
        catch (IOException e) {
            if (Loggers.AGENT.isDebugEnabled()) {
                Loggers.AGENT.debug("Cannot create temp directory for " + coverageEngineName + " coverage", (Throwable)e);
            } else {
                Loggers.AGENT.warn("Cannot create temp directory for " + coverageEngineName + " coverage");
            }
            tempDir = new File(build.getCheckoutDirectory(), coverageEngineName + "_coverage_temp_" + UUID.randomUUID().toString());
        }
        return tempDir;
    }

    public static String getOrCreateTempDirectory(AgentRunningBuild build, String runnerName) {
        String dir = (String)build.getSharedConfigParameters().get(TEMPORARY_DIRECTORY_PATH);
        if (dir == null) {
            File jacoco = AgentCoverageUtil.createTempDirectory(build, runnerName);
            return jacoco.getAbsolutePath();
        }
        return dir;
    }
}

