/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.coverage;

import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import jetbrains.buildServer.agent.BuildRunnerContext;
import jetbrains.buildServer.coverage.AgentCoverageUtil;
import jetbrains.buildServer.util.IncludeExcludeRules;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JacocoUtil {
    public static final String JACOCO_COVERAGE_LOG_FILENAME = "jacoco.log";
    private static final String JACOCOAGENT_JAR = "jacocoagent.jar";

    public static String buildArgString(BuildRunnerContext runner) {
        String includes = (String)runner.getBuildParameters().getSystemProperties().get("teamcity.coverage.jacoco.includePatterns");
        String excludes = (String)runner.getBuildParameters().getSystemProperties().get("teamcity.coverage.jacoco.excludePatterns");
        return JacocoUtil.getArgString(includes, excludes, JacocoUtil.getJacocoAgentJarPath(runner), JacocoUtil.getJacocoExecFilePath(runner));
    }

    @NotNull
    public static String getArgString(String includes, String excludes, String jacocoAgentJarPath, String jacocoExecFilePath) {
        StringBuilder sb = new StringBuilder("-javaagent:").append(jacocoAgentJarPath).append("=");
        if (includes != null) {
            sb.append("includes=").append(includes.replace(' ', ':')).append(",");
        }
        if (excludes != null) {
            sb.append("excludes=").append(excludes.replace(' ', ':')).append(",");
        }
        sb.append("append=true,destfile=").append(jacocoExecFilePath);
        String string = sb.toString();
        if (string == null) {
            JacocoUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String getJacocoExecFilePath(BuildRunnerContext runner) {
        String jacocoExecFilePath = (String)runner.getBuildParameters().getSystemProperties().get("teamcity.jacoco.coverage.datafile");
        if (jacocoExecFilePath == null) {
            String tempDir = AgentCoverageUtil.getOrCreateTempDirectory(runner.getBuild(), "JACOCO");
            jacocoExecFilePath = tempDir + File.separator + "jacoco.exec";
            runner.getBuild().addSharedConfigParameter("teamcity.jacoco.coverage.datafile", jacocoExecFilePath);
        }
        return jacocoExecFilePath;
    }

    public static String getJacocoAgentJarPath(BuildRunnerContext runner) {
        return new File((String)runner.getBuildParameters().getSystemProperties().get("teamcity.tool.jacoco"), JACOCOAGENT_JAR).getAbsolutePath();
    }

    @NotNull
    public static String escape(@NotNull String str) {
        if (str == null) {
            JacocoUtil.$$$reportNull$$$0(1);
        }
        String string = str.replaceAll("\\\\", "\\\\\\\\").replaceAll(" ", "\\\\ ");
        if (string == null) {
            JacocoUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static String[] parse(@Nullable String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return new String[0];
        }
        ArrayList<String> res = new ArrayList<String>();
        boolean isPrevEscape = false;
        int wordStart = 0;
        block4: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case ' ': {
                    if (isPrevEscape) continue block4;
                    res.add(JacocoUtil.unescape(str.substring(wordStart, i)));
                    wordStart = i + 1;
                    continue block4;
                }
                case '\\': {
                    isPrevEscape = !isPrevEscape;
                    continue block4;
                }
                default: {
                    isPrevEscape = false;
                }
            }
        }
        res.add(JacocoUtil.unescape(str.substring(wordStart)));
        return res.toArray(new String[res.size()]);
    }

    @NotNull
    public static String[] parseIncludeExcludeRules(@Nullable String str) {
        if (str == null) {
            String[] stringArray = new String[]{};
            if (stringArray == null) {
                JacocoUtil.$$$reportNull$$$0(3);
            }
            return stringArray;
        }
        String q = str.replaceAll("((?<!\\\\) )", "\n").replaceAll("\\\\ ", " ");
        IncludeExcludeRules rules = new IncludeExcludeRules(q);
        ArrayList<String> result = new ArrayList<String>(rules.getRules().size());
        for (IncludeExcludeRules.Rule rule : rules.getRules()) {
            result.add(rule.isInclude() ? "+:" + rule.getRule() : "-:" + rule.getRule());
        }
        String[] stringArray = result.toArray(new String[result.size()]);
        if (stringArray == null) {
            JacocoUtil.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @Nullable
    public static String unescape(@Nullable String substring) {
        if (substring == null) {
            return null;
        }
        return substring.replaceAll(Pattern.quote("\\ "), " ").replaceAll(Pattern.quote("\\\\"), "\\\\");
    }

    @Nullable
    public static String packPatterns(@Nullable String[] patterns) {
        if (patterns == null || patterns.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String param : patterns) {
            builder.append(JacocoUtil.escape(param)).append(' ');
        }
        return builder.substring(0, Math.max(0, builder.length() - 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/coverage/JacocoUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/coverage/JacocoUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "escape";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIncludeExcludeRules";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "escape";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

