/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.coverage.emma;

import com.vladium.emma.Command;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.buildServer.ResourceUtil;
import jetbrains.buildServer.agent.BuildProgressLogger;
import jetbrains.buildServer.agent.ant.AntTaskExtensionAdapter;
import jetbrains.buildServer.agent.ant.AntUtil;
import jetbrains.buildServer.agent.ant.patches.ElementPatch;
import jetbrains.buildServer.coverage.emma.EmmaCoverageSupport;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.types.Path;

public class EmmaAntTaskExtension
extends AntTaskExtensionAdapter {
    private static final String TEST_NGANT_TASK_CLASSNAME = "org.testng.TestNGAntTask";
    private final EmmaCoverageSupport myCoverageSupport = new EmmaCoverageSupport();

    public boolean isEnabled() {
        return "EMMA".equals(System.getProperty("teamcity.coverage.runner"));
    }

    public void buildStarted(BuildEvent event, BuildProgressLogger logger) {
        this.myCoverageSupport.onStart();
    }

    public void buildFinished(BuildEvent event, final BuildProgressLogger logger) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                EmmaAntTaskExtension.this.myCoverageSupport.createReport(logger);
            }
        });
    }

    public boolean taskStarted(Task task, BuildProgressLogger logger) {
        if (task instanceof UnknownElement) {
            ElementPatch rootPatch;
            UnknownElement element = (UnknownElement)task;
            if (AntUtil.isAssignableFrom((UnknownElement)element, (String)TEST_NGANT_TASK_CLASSNAME)) {
                rootPatch = new ElementPatch(element);
                this.addEmmaToClasspath(rootPatch);
                EmmaAntTaskExtension.addCoverageProperties(rootPatch);
                logger.message("Adding emma to classpath of TestNGTask.");
            }
            if (AntUtil.isAssignableFrom((UnknownElement)element, (String)Java.class.getName())) {
                rootPatch = new ElementPatch(element);
                EmmaAntTaskExtension.addCoverageProperties(rootPatch);
                logger.message("Adding emma system properties to Java task.");
            }
            if (AntUtil.isAssignableFrom((UnknownElement)element, (String)JUnitTask.class.getName())) {
                rootPatch = new ElementPatch(element);
                this.addEmmaToClasspath(rootPatch);
                EmmaAntTaskExtension.addCoverageProperties(rootPatch);
                logger.message("Adding emma to classpath of JUnitTask.");
            }
            if (AntUtil.isAssignableFrom((UnknownElement)element, (String)Javac.class.getName())) {
                rootPatch = new ElementPatch(element);
                rootPatch.setAttribute("debug", "true");
                logger.message("Adding debug=true parameter to javac task");
            }
        }
        return false;
    }

    public boolean taskFinished(Task task, BuildProgressLogger logger) {
        UnknownElement element;
        if (task instanceof UnknownElement && AntUtil.isAssignableFrom((UnknownElement)(element = (UnknownElement)task), (String)Javac.class.getName())) {
            List children;
            String srcDirValue;
            String destDirValue = (String)AntUtil.getAttrValueIgnoreCase((Map)element.getRuntimeConfigurableWrapper().getAttributeMap(), (String)"destdir");
            if (destDirValue != null) {
                File path = EmmaAntTaskExtension.resolvePath(task, destDirValue);
                this.myCoverageSupport.instrumentClasses(path, logger);
            }
            if ((srcDirValue = (String)AntUtil.getAttrValueIgnoreCase((Map)element.getRuntimeConfigurableWrapper().getAttributeMap(), (String)"srcdir")) != null) {
                this.myCoverageSupport.addSourcePath(EmmaAntTaskExtension.resolvePath(task, srcDirValue).getAbsolutePath());
            }
            if ((children = element.getChildren()) != null) {
                for (UnknownElement child : children) {
                    Object proxy;
                    if (!child.getQName().equalsIgnoreCase("src") || !((proxy = child.getWrapper().getProxy()) instanceof Path)) continue;
                    String[] sources = ((Path)proxy).list();
                    for (int i = 0; i < sources.length; ++i) {
                        this.myCoverageSupport.addSourcePath(EmmaAntTaskExtension.resolvePath(task, sources[i]).getAbsolutePath());
                    }
                }
            }
        }
        return false;
    }

    public Collection getAntRuntimeClasspathClasses() {
        HashSet<Class<Command>> result = new HashSet<Class<Command>>();
        result.add(Command.class);
        return result;
    }

    public Collection getJavaTaskClasspathClasses(Task task) {
        return this.getAntRuntimeClasspathClasses();
    }

    private static File resolvePath(Task task, String path) {
        Project project = task.getProject();
        return project.resolveFile(project.replaceProperties(path));
    }

    private void addEmmaToClasspath(ElementPatch task) {
        Collection classes = this.getAntRuntimeClasspathClasses();
        if (classes == null) {
            return;
        }
        ElementPatch classpathPatch = task.createAndAdd("classpath");
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            String path = ResourceUtil.getResourceRoot((Class)((Class)it.next()));
            classpathPatch.createAndAdd("path").setAttribute("path", path);
        }
    }

    private static void addCoverageProperties(ElementPatch task) {
        String[] props = new String[]{"report.html.out.file", "emma.instrumentation.parameters", "emma.disable.source", "emma.coverage.out.file", "emma.metadata.out.file", "report.txt.out.file", "emma.rt.control", "teamcity.coverage.runner"};
        for (int i = 0; i < props.length; ++i) {
            ElementPatch jvmArgEl = task.createAndAdd("jvmarg");
            String value = System.getProperty(props[i]);
            if (value == null) continue;
            jvmArgEl.setAttribute("value", "-D" + props[i] + "=" + value);
        }
        ElementPatch jvmArgEl = task.createAndAdd("jvmarg");
        jvmArgEl.setAttribute("value", "-XX:-UseSplitVerifier");
    }
}

