/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.coverage.emma;

import com.vladium.emma.Command;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jetbrains.buildServer.agent.BuildProgressLogger;

public class EmmaCoverageSupport {
    private final Set mySources = new HashSet();
    private static final byte[] BUF = new byte[10240];

    private static boolean sourcesEnabled() {
        return !"true".equals(System.getProperty("emma.disable.source"));
    }

    public void onStart() {
        boolean removeOldFiles = !EmmaCoverageSupport.keepOldCoverageData();
        this.makePropertyWithAbsolutePathToFile("emma.coverage.out.file", "coverage.ec", removeOldFiles);
        this.makePropertyWithAbsolutePathToFile("emma.metadata.out.file", "coverage.em", removeOldFiles);
        this.makePropertyWithAbsolutePathToFile("report.txt.out.file", "coverage.txt", removeOldFiles);
        File indexHtml = new File(System.getProperty("report.html.out.file"));
        File zip = new File(indexHtml.getParentFile(), "coverage.zip");
        if (removeOldFiles) {
            zip.delete();
        }
        this.mySources.clear();
        if (System.getProperty("emma.rt.control") == null) {
            System.setProperty("emma.rt.control", "false");
        }
    }

    private static boolean keepOldCoverageData() {
        return "true".equals(System.getProperty("teamcity.no.coverage.cleanup"));
    }

    private void makePropertyWithAbsolutePathToFile(String propertyName, String fileName, boolean removeOldFiles) {
        if (System.getProperty(propertyName) == null) {
            System.setProperty(propertyName, new File(fileName).getAbsolutePath());
        }
        if (removeOldFiles) {
            new File(System.getProperty(propertyName)).delete();
        }
    }

    public void addSourcePath(String path) {
        if (EmmaCoverageSupport.sourcesEnabled()) {
            this.mySources.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instrumentClasses(File classesDir, BuildProgressLogger logger) {
        try {
            logger.flush();
            logger.activityStarted("EMMA: Instrumenting classes", "EMMA");
            ArrayList<String> list = new ArrayList<String>();
            this.addCustomParameters(list);
            list.add("-cp");
            list.add(classesDir.getAbsolutePath());
            list.add("-m");
            list.add("overwrite");
            String[] args = list.toArray(new String[list.size()]);
            logger.message("EMMA commandline: " + list.toString());
            try {
                Command.create((String)"instr", (String)"emma instr", (String[])args).run();
            }
            catch (Exception e) {
                logger.exception((Throwable)e);
            }
        }
        finally {
            logger.activityFinished("EMMA: Instrumenting classes", "EMMA");
            logger.flush();
        }
    }

    private void addCustomParameters(ArrayList list) {
        String filter = System.getProperty("emma.instrumentation.parameters");
        if (filter == null) {
            filter = "";
        }
        StringTokenizer tokenizer = new StringTokenizer(filter, " ", false);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createReport(BuildProgressLogger logger) {
        try {
            logger.activityStarted("EMMA: Create Report", "EMMA");
            if (this.notExists(logger, this.coverageEm())) {
                return;
            }
            if (this.notExists(logger, this.coverageEc())) {
                return;
            }
            if (EmmaCoverageSupport.keepOldCoverageData() && EmmaCoverageSupport.sourcesEnabled() && this.mySources.size() == 0) {
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("-r");
            list.add("html,txt");
            list.add("-in");
            list.add(this.coverageEm() + "," + this.coverageEc());
            String index_html = System.getProperty("report.html.out.file");
            list.add("-Dreport.html.out.file=" + index_html);
            String reportTxt = System.getProperty("report.txt.out.file");
            list.add("-Dreport.txt.out.file=" + reportTxt);
            Iterator it = this.mySources.iterator();
            while (it.hasNext()) {
                list.add("-sp");
                String s = (String)it.next();
                list.add(s);
            }
            logger.message("EMMA commandline: " + list.toString());
            String[] args = list.toArray(new String[list.size()]);
            Command.create((String)"report", (String)"emma report", (String[])args).run();
            File parentDir = new File(index_html).getParentFile();
            File coverageReportArchive = new File(parentDir, "coverage.zip");
            File[] toArchive = new File[]{new File(index_html), new File(parentDir, "_files")};
            if (coverageReportArchive.exists()) {
                coverageReportArchive.delete();
            }
            logger.activityStarted("EMMA: Create ZIP: " + coverageReportArchive.getAbsolutePath(), "EMMA");
            this.createZip(coverageReportArchive, toArchive);
            logger.activityFinished("EMMA: Create ZIP: " + coverageReportArchive.getAbsolutePath(), "EMMA");
            this.deleteFiles(toArchive);
        }
        catch (Throwable e) {
            logger.warning("EMMA: Trouble while creating report:");
            logger.exception(e);
        }
        finally {
            logger.activityFinished("EMMA: Create Report", "EMMA");
            logger.flush();
        }
    }

    private String coverageEm() {
        return System.getProperty("emma.metadata.out.file");
    }

    private String coverageEc() {
        return System.getProperty("emma.coverage.out.file");
    }

    private boolean notExists(BuildProgressLogger logger, String file) {
        boolean result;
        int i = 0;
        File theFile = new File(file);
        try {
            while (theFile.length() == 0L && i++ < 200) {
                Thread.sleep(20L);
            }
        }
        catch (Exception e) {
            logger.message("Unable to find " + file + ", cannot create EMMA report");
            logger.exception((Throwable)e);
            return true;
        }
        boolean bl = result = theFile.length() == 0L;
        if (result) {
            logger.message("Unable to find " + file + ", cannot create EMMA report");
        }
        return result;
    }

    private void deleteFiles(File[] toDelete) {
        for (int i = 0; i < toDelete.length; ++i) {
            File file = toDelete[i];
            if (file.isDirectory()) {
                this.deleteFiles(file.listFiles());
            }
            file.delete();
        }
    }

    private void createZip(File archive, File[] filesToArchive) {
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(archive));
            for (int i = 0; i < filesToArchive.length; ++i) {
                File file = filesToArchive[i];
                String parentDir = file.getParentFile().getAbsolutePath();
                this.archiveRecursively(out, parentDir, file);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void archiveRecursively(ZipOutputStream out, String parentDir, File file) throws IOException {
        if (file.isDirectory()) {
            out.putNextEntry(new ZipEntry(EmmaCoverageSupport.getName(file, parentDir) + "/"));
            out.closeEntry();
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.archiveRecursively(out, parentDir, files[i]);
            }
        } else {
            int len;
            out.putNextEntry(new ZipEntry(EmmaCoverageSupport.getName(file, parentDir)));
            FileInputStream in = new FileInputStream(file);
            while ((len = in.read(BUF)) > 0) {
                out.write(BUF, 0, len);
            }
            in.close();
            out.closeEntry();
        }
    }

    private static String getName(File file, String parentDir) {
        return file.getAbsolutePath().substring(parentDir.length() + 1);
    }
}

