/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.coverage.idea;

import java.io.File;
import java.util.Collection;
import jetbrains.buildServer.agent.BuildProgressLogger;
import jetbrains.buildServer.agent.ant.AntTaskExtensionAdapter;
import jetbrains.buildServer.agent.ant.AntUtil;
import jetbrains.buildServer.agent.ant.TestNGUtil;
import jetbrains.buildServer.agent.ant.patches.ElementPatch;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.util.ReflectUtil;

public abstract class AgentCoverageForAnt
extends AntTaskExtensionAdapter {
    protected BuildProgressLogger myLogger;
    private final String myCoverageEngineName;

    public AgentCoverageForAnt(String coverageEngineName) {
        this.myCoverageEngineName = coverageEngineName;
    }

    public boolean isEnabled() {
        return this.myCoverageEngineName.equals(System.getProperty("teamcity.coverage.runner"));
    }

    public void buildStarted(BuildEvent event, BuildProgressLogger logger) {
        this.myLogger = logger;
    }

    public void buildFinished(BuildEvent event, BuildProgressLogger logger) {
        this.myLogger = null;
    }

    public boolean taskStarted(Task task, BuildProgressLogger logger) {
        if (task instanceof UnknownElement) {
            UnknownElement element = (UnknownElement)task;
            if (TestNGUtil.isTestNGTask((Task)task)) {
                ElementPatch rootPatch = new ElementPatch(element);
                if (this.addJavaAgent(rootPatch, logger)) {
                    logger.message(this.myCoverageEngineName + " Coverage: Java agent added to TestNG task");
                }
            } else if (AntUtil.isAssignableFrom((UnknownElement)element, (String)Java.class.getName())) {
                ElementPatch rootPatch = new ElementPatch(element);
                if (this.addJavaAgent(rootPatch, logger)) {
                    logger.message(this.myCoverageEngineName + " Coverage: Java agent added to Java task");
                }
                if (this.enableForkIfNeeded(rootPatch, false)) {
                    logger.warning(this.myCoverageEngineName + " Coverage: fork is enabled for Java task");
                }
            } else if (AntUtil.isAssignableFrom((UnknownElement)element, (String)"org.apache.tools.ant.taskdefs.optional.junit.JUnitTask")) {
                ElementPatch rootPatch = new ElementPatch(element);
                if (this.addJavaAgent(rootPatch, logger)) {
                    logger.message(this.myCoverageEngineName + " Coverage: Java agent added to JUnit task");
                }
                if (this.enableForkIfNeeded(rootPatch, true)) {
                    logger.warning(this.myCoverageEngineName + " Coverage: fork is enabled for JUnit task, forkmode is set to once");
                }
            }
            new ElementPatch((UnknownElement)task).recreateRuntimeConfigurable();
        } else if (task instanceof Java) {
            if (this.addJavaAgent((Java)task, logger)) {
                logger.message(this.myCoverageEngineName + " Coverage: Java agent added to Java task");
            }
            if (this.enableForkIfNeeded((Java)task)) {
                logger.warning(this.myCoverageEngineName + " Coverage: fork is enabled for JUnit task, forkmode is set to once");
            }
        }
        return false;
    }

    public abstract Collection getAntRuntimeClasspathClasses();

    public Collection getJavaTaskClasspathClasses(Task task) {
        return null;
    }

    private boolean addJavaAgent(ElementPatch parentTask, BuildProgressLogger logger) {
        try {
            String javaAgentArg = this.buildArgString(logger);
            if (javaAgentArg != null) {
                this.addJavaArg(javaAgentArg, parentTask);
                return true;
            }
        }
        catch (Throwable e) {
            logger.warning("Cannot add -javaagent JVM argument due to error: " + e.toString());
            logger.warning(System.getProperties().toString());
        }
        return false;
    }

    private boolean addJavaAgent(Java task, BuildProgressLogger logger) {
        try {
            String javaAgentArg = this.buildArgString(logger);
            if (javaAgentArg != null) {
                task.createJvmarg().setValue(javaAgentArg);
                return true;
            }
        }
        catch (Throwable e) {
            logger.warning("Cannot add -javaagent JVM argument due to error: " + e.toString());
            logger.warning(System.getProperties().toString());
        }
        return false;
    }

    protected abstract String buildArgString(BuildProgressLogger var1);

    private boolean enableForkIfNeeded(ElementPatch parentTask, boolean withForkMode) {
        if (AntUtil.isForkEnabled((UnknownElement)parentTask.getElement())) {
            return false;
        }
        parentTask.setAttribute("fork", "true");
        if (withForkMode) {
            parentTask.setAttribute("forkmode", "once");
        }
        return true;
    }

    private boolean enableForkIfNeeded(Java task) {
        try {
            Boolean fork = (Boolean)ReflectUtil.getField((Object)task, (String)"fork");
            if (fork.booleanValue()) {
                return false;
            }
        }
        catch (BuildException buildException) {
            // empty catch block
        }
        task.setFork(true);
        return true;
    }

    private void addJavaArg(String arg, ElementPatch parentTask) {
        UnknownElement jvmArgEl = parentTask.createChild("jvmarg");
        parentTask.insertOrAddChild(jvmArgEl, 0).setAttribute("value", arg);
    }

    protected File getOrCreateTempDirectory() {
        String path = System.getProperty("teamcity.coverage.tempdir.path");
        if (path == null) {
            String checkoutDir = AgentCoverageForAnt.getCheckoutDir();
            File dir = new File(checkoutDir, "coverage_report_tempdir");
            return this.getOrCreateDirFile(dir);
        }
        return this.getOrCreateDirFile(new File(path));
    }

    protected static String getCheckoutDir() {
        return System.getProperty("teamcity.build.checkoutDir");
    }

    private File getOrCreateDirFile(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                System.err.println("Cannot create temporary report directory for " + this.myCoverageEngineName + " coverage in path " + dir.getAbsolutePath() + ". Coverage report will not be generated.");
                return null;
            }
            return dir;
        }
        if (dir.isDirectory()) {
            return dir;
        }
        System.err.println("Cannot write " + this.myCoverageEngineName + " coverage report in path " + dir.getAbsolutePath() + " - is not a directory. Coverage report will not be generated.");
        return null;
    }
}

