/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.coverage.idea;

import com.intellij.rt.coverage.main.CoveragePremain;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import jetbrains.buildServer.ResourceUtil;
import jetbrains.buildServer.agent.BuildProgressLogger;

public class CoverageJavaArgsBuilder {
    private File myCoverageBaseDir;
    private File myCoverageDataFile;
    private File myTempDir;
    private String myIncludePatterns;
    private String myExcludePatterns;
    private Boolean myRegexExcludePatternsMode = null;

    public void setRegexExcludePatternsMode(boolean regexExcludePatternsMode) {
        this.myRegexExcludePatternsMode = regexExcludePatternsMode;
    }

    public void setCoverageBaseDir(File coverageBaseDir) {
        this.myCoverageBaseDir = coverageBaseDir;
    }

    public void setCoverageDataFile(File coverageDataFile) {
        this.myCoverageDataFile = coverageDataFile;
    }

    public void setTempDir(File tempDir) {
        this.myTempDir = tempDir;
    }

    public void setIncludePatterns(String includePatterns) {
        this.myIncludePatterns = includePatterns;
    }

    public void setExcludePatterns(String excludePatterns) {
        this.myExcludePatterns = excludePatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildArgString(BuildProgressLogger logger) {
        if (this.myCoverageBaseDir == null && this.myCoverageDataFile == null) {
            throw new IllegalStateException("Coverage data base dir or path to coverage data file must be specified");
        }
        File tempDir = this.getActualTempDir();
        String includePatterns = this.getActualIncludePatterns();
        String excludePatterns = this.getActualExcludePatterns();
        File coverageIc = this.getActualDataFile();
        File sourceMapFile = this.getSourceMapFile(coverageIc.getParentFile());
        boolean regexExcludePatternsMode = this.isActualRegexExcludePatternsMode();
        PrintWriter writer = null;
        File argsFile = null;
        try {
            argsFile = File.createTempFile("coverage", "args", tempDir);
            writer = new PrintWriter(new FileOutputStream(argsFile));
            writer.println(coverageIc.getAbsolutePath());
            writer.println("true\ntrue\ntrue\ntrue\ntrue");
            writer.println(sourceMapFile.getAbsolutePath());
            writer.println(CoverageJavaArgsBuilder.getIncludeExcludePatterns(includePatterns, excludePatterns, regexExcludePatternsMode));
        }
        catch (IOException e) {
            logger.warning("Failed to create temp file under the: " + tempDir + ", error: " + e.toString());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        if (argsFile == null) {
            return null;
        }
        File jar = new File(ResourceUtil.getResourceRoot(CoveragePremain.class));
        return "-javaagent:" + jar.getAbsolutePath() + "=" + argsFile.getAbsolutePath();
    }

    private boolean isActualRegexExcludePatternsMode() {
        if (this.myRegexExcludePatternsMode != null) {
            return this.myRegexExcludePatternsMode;
        }
        return Boolean.getBoolean("teamcity.coverage.idea.regexExcludePatterns");
    }

    private File getSourceMapFile(File parent) {
        return new File(parent, "coverage.ism");
    }

    private File getActualDataFile() {
        if (this.myCoverageDataFile != null) {
            return this.myCoverageDataFile;
        }
        return new File(this.myCoverageBaseDir, "coverage.ic");
    }

    private String getActualExcludePatterns() {
        if (this.myExcludePatterns != null) {
            return this.myExcludePatterns;
        }
        return System.getProperty("teamcity.coverage.idea.excludePatterns", "");
    }

    public String getActualIncludePatterns() {
        if (this.myIncludePatterns != null) {
            return this.myIncludePatterns;
        }
        return System.getProperty("teamcity.coverage.idea.includePatterns", "*");
    }

    private File getActualTempDir() {
        if (this.myTempDir != null) {
            return this.myTempDir;
        }
        File temp = new File(System.getProperty("java.io.tmpdir"));
        temp.mkdirs();
        return temp;
    }

    private static String getIncludeExcludePatterns(String includePatterns, String excludePatterns, boolean regexMode) {
        String pattern;
        StringBuffer buf = new StringBuffer();
        StringTokenizer st = new StringTokenizer(includePatterns, " ");
        while (st.hasMoreElements()) {
            pattern = st.nextToken();
            buf.append(CoverageJavaArgsBuilder.convertToRegex(pattern)).append("\n");
        }
        buf.append("-exclude").append("\n");
        st = new StringTokenizer(excludePatterns, " ");
        while (st.hasMoreElements()) {
            pattern = st.nextToken();
            buf.append(regexMode ? CoverageJavaArgsBuilder.convertExcludePattern(pattern) : CoverageJavaArgsBuilder.convertToRegex(pattern)).append("\n");
        }
        return buf.toString();
    }

    public static String convertExcludePattern(String property) {
        if (property != null && CoverageJavaArgsBuilder.shouldAppendInnerRegex(property)) {
            return property + "(\\$.*)?";
        }
        return property;
    }

    public static String convertToRegex(String property) {
        if (property == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < property.length(); ++i) {
            char c = property.charAt(i);
            switch (c) {
                case '.': {
                    buf.append('\\');
                    break;
                }
                case '*': {
                    buf.append('.');
                }
            }
            buf.append(c);
        }
        if (CoverageJavaArgsBuilder.shouldAppendInnerRegex(property)) {
            buf.append("(\\$.*)?");
        }
        return buf.toString();
    }

    private static boolean shouldAppendInnerRegex(String property) {
        return !property.endsWith(".*") && !property.endsWith("(\\$.*)?") && !property.endsWith("(\\$.*)*") && !property.endsWith("(\\$.*)");
    }
}

